from abc import ABC, abstractmethod
from typing import Protocol, Dict
from .ICoordinates import IPair
from .Coordinate import APair
from enum import Enum

class IFontSize(IPair, Protocol):
    """
    A protocol defining the interface for FontSize classes.
    """
    pass

class IFont(Protocol):
    """
    A protocol defining the interface for Font classes.
    """
    font_name: str

class FontSizeUnitsEnum(Enum):
    """
    Font size units for font resizing.
    """
    RULER = 0
    POINTS = 1
    PERCENT = 2

class FontStyleEnum(Enum):
    """
    Enumeration for different font styles.
    """
    NORMAL = 0
    BOLD = 1 << 0
    ITALIC = 1 << 1

class IFontSizeUnits(Protocol):
    """
    A protocol defining the interface for FontSizeUnits classes.
    """
    font_size_units: FontSizeUnitsEnum

class IFontStyle(Protocol):
    """
    A protocol defining the interface for FontStyle classes.
    """
    font_style: FontStyleEnum

class IFontSettings(IFont, IFontStyle, IFontSizeUnits, Protocol):
    """
    A protocol defining the interface for FontSettings classes.
    """
    pass

class FontSize(APair, IFontSize):
    """
    Font size in the X and Y direction allows for stretching/resizing when non-default font size is desired.
    """
    def __init__(self, x: float, y: float): ...

class IResidentFonts(Protocol):
    """
    A protocol defining the interface for ResidentFonts classes.
    """
    font_names_table: Dict[str, str]

class ResidentFonts:
    """
    Provides a table of resident font names.
    """
    @staticmethod
    def names() -> Dict[str, str]: ...
