//
//  IMaxicodeMsg.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef IMaxicodeMsg_h
#define IMaxicodeMsg_h

#import <Foundation/Foundation.h>
#import <UniPRT/IMaxicodeData.h>

/**
 * @~english
 * @protocol IMaxicodeMsg
 * @brief Maxicode barcode data. Does not apply to Mode 2 or 3.
 *
 * This protocol defines the interface for objects that manage Maxicode barcode data for modes other than Mode 2 or 3. It includes properties for specifying the primary and secondary messages.
 *
 * @ingroup Interface
 *
 * @~chinese
 * @protocol IMaxicodeMsg
 * @brief Maxicode 条码数据。不适用于模式 2 或 3。
 *
 * 此协议定义了用于管理除模式 2 或 3 之外的模式的 Maxicode 条码数据的对象接口。它包括用于指定主消息和次消息的属性。
 *
 * @ingroup Interface
 *
 * @~Chinese-Traditional
 * @protocol IMaxicodeMsg
 * @brief Maxicode 條碼數據。不適用於模式 2 或 3。
 *
 * 此協議定義了用於管理除模式 2 或 3 之外的模式的 Maxicode 條碼數據的對象接口。它包括用於指定主消息和次消息的屬性。
 *
 * @ingroup Interface
 */
@protocol IMaxicodeMsg <IMaxicodeData>

/**
 * @~english
 * @brief Primary Message, excluding the mode value, typically has a maximum of 9 characters.
 *
 * The primary message in Maxicode barcode data is generally limited to 9 characters, not including the mode value.
 *
 * @~chinese
 * @brief 主消息，不包括模式值，通常最多为 9 个字符。
 *
 * Maxicode 条码数据中的主消息通常限制为 9 个字符，不包括模式值。
 *
 * @~Chinese-Traditional
 * @brief 主消息，不包括模式值，通常最多為 9 個字符。
 *
 * Maxicode 條碼數據中的主消息通常限制為 9 個字符，不包括模式值。
 */
@property (nonatomic, copy) NSString *primaryMsg;

/**
 * @~english
 * @brief Secondary Message, typically has a maximum of 68 characters for modes with EEC or 84 characters for modes with SEC.
 *
 * The secondary message in Maxicode barcode data is generally limited to 68 characters for Extended Error Correction (EEC) modes or 84 characters for Standard Error Correction (SEC) modes.
 *
 * @~chinese
 * @brief 次消息，对于带有 EEC 的模式，通常最多为 68 个字符，对于带有 SEC 的模式，通常最多为 84 个字符。
 *
 * Maxicode 条码数据中的次消息通常限制为带有扩展错误校正 (EEC) 的模式为 68 个字符，带有标准错误校正 (SEC) 的模式为 84 个字符。
 *
 * @~Chinese-Traditional
 * @brief 次消息，對於帶有 EEC 的模式，通常最多為 68 個字符，對於帶有 SEC 的模式，通常最多為 84 個字符。
 *
 * Maxicode 條碼數據中的次消息通常限制為帶有擴展錯誤校正 (EEC) 的模式為 68 個字符，帶有標準錯誤校正 (SEC) 的模式為 84 個字符。
 */
@property (nonatomic, copy) NSString *remainingMsg;

@end

#endif /* IMaxicodeMsg_h */
