#import <Foundation/Foundation.h>
@import UniPRT;

int main(int argc, const char * argv[]) {
    @autoreleasepool {
        NSString *ipAddress = @"10.0.10.170";
        TcpComm *tcpComm = [[TcpComm alloc] initWithIPAddress:ipAddress port:DEFAULT_MGMT_PORT];
        [tcpComm open];

        OdvMonitor *odvMonitor = [[OdvMonitor alloc] initWithTcpComm:tcpComm];
        PrinterMonitor *printerMonitor = [[PrinterMonitor alloc] initWithTcpComm:tcpComm];
        
        int choice = 0;
        do
        {
            NSLog(@"\nMenu:");
            NSLog(@"1 - Get Printer Info");
            NSLog(@"2 - Listen to OdvReport");
            NSLog(@"3 - Print example file");
            NSLog(@"4 - Exit");
            NSLog(@"Enter your choice (1-4):");

            char buffer[10];
            fgets(buffer, 10, stdin);
            choice = atoi(buffer);

            switch (choice) {
                case 1: {
                    
                    PrinterInfo *printerInfo = [printerMonitor getPrinterInfo];
                    NSLog(@"\n======= ODV Printer Info: ");
                    NSLog(@"Printer Model: %@", printerInfo.model);
                    NSLog(@"Printer SN: %@", printerInfo.serialNumber);
                    NSLog(@"Printer FW PN: %@", printerInfo.firmwarePartNumber);
                    NSLog(@"Printer FW Ver: %@", printerInfo.firmwareVersion);
                    NSLog(@"Printhead Resolution (Dots/Inch): %@", printerInfo.printheadResolution);
                    NSLog(@"Has ODV: %@", printerInfo.hasOdvOption ? @"Yes" : @"No");
                    break;
                }
                case 2: {
                    [NSThread detachNewThreadWithBlock:^{
                        odvMonitor.odvReportCallback = ^(OdvReport *report) {
                            if ([report failed]) {
                                NSLog(@"\nBarcode Failed.");
                            } else {
                                NSLog(@"\nBarcode Passed.");
                                NSLog(@"Grade: %f", [report overallGradeAsFloat]);

                                if ([report overallGradeAsFloat] > 3.5) {
                                    NSLog(@"Print Quality passed. \n Overall Grade= %.2f", [report overallGradeAsFloat]);
                                } else {
                                    NSLog(@"Print Quality Failed. \n Overall Grade= %.2f", [report overallGradeAsFloat]);
                                }

                                NSLog(@"Barcode Symbology: %@", [report symbology]);
                                NSLog(@"Barcode Data: %@", [report data]);
                            }
                        };
                        [odvMonitor SetOdvReportListening:YES];
                    }];
                    break;
                }
                case 3: {
                    TcpComm *tcpComm2 = [[TcpComm alloc] initWithIPAddress:@"10.0.10.171" port:9100];
                    [tcpComm2 sendPrintFile:@"10.0.10.171" fileName:@"/Users/realbuber/Downloads/TestOdvMonitor/DM_PRINTRONIX_1.pgl"];
                    NSLog(@"Sending datamatrix barcode print job...");
                    break;
                }
                case 4:
                    NSLog(@"Exiting...");
                    break;
                default:
                    NSLog(@"Invalid choice. Please enter a number between 1 and 4.");
            }
        } while (choice != 4);
    }
    return 0;
}
