//
//  ICellSquare.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef ICellSquare_h
#define ICellSquare_h

#import <Foundation/Foundation.h>
#import <UniPRT/IRuler.h>

/**
 * @~english
 * @protocol ICellSquare
 * @brief Sets the size of the single cell square of a 2D barcode.
 *
 * The cell size refers to the size of the unit within the barcode and not the shape of the barcode.
 * @ingroup Interface
 *
 * @~chinese
 * @protocol ICellSquare
 * @brief 设置2D条码单元方块的大小。
 *
 * 单元大小指的是条码内部单元的尺寸，而不是条码的形状。
 * @ingroup Interface
 *
 * @~Chinese-Traditional
 * @protocol ICellSquare
 * @brief 設置2D條碼單元方塊的大小。
 *
 * 單元大小指的是條碼內部單元的尺寸，而不是條碼的形狀。
 * @ingroup Interface
 */
@protocol ICellSquare <NSObject>

/**
 * @~english
 * @brief Ruler to use for cell size.
 *
 * @~chinese
 * @brief 用于单元大小的标尺。
 *
 * @~Chinese-Traditional
 * @brief 用於單元大小的標尺。
 */
@property (nonatomic, strong) id<IRuler> ruler;

/**
 * @~english
 * @brief X dimension cell size (width).
 *
 * @~chinese
 * @brief X 维度单元大小（宽度）。
 *
 * @~Chinese-Traditional
 * @brief X 維度單元大小（寬度）。
 */
@property (nonatomic, assign) float xdim;

@end

#endif /* ICellSquare_h */
