//
//  PglBarcode_1D.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/24.
//

#ifndef PglBarcode_1D_h
#define PglBarcode_1D_h

#import <Foundation/Foundation.h>

#import <UniPRT/ABarcode1D.h>
#import <UniPRT/IBarcodeItem.h>

/**
 * \~English
 * @class PglBarcode_1D
 * @brief A class representing a 1D barcode.
 *
 * This class inherits from ABarcode1D and provides functionality for initializing and describing 1D barcodes.
 *
 * @ingroup PGL
 *
 * \~Chinese
 * @class PglBarcode_1D
 * @brief 表示一维条形码的类。
 *
 * 该类继承自ABarcode1D，并提供了初始化和描述一维条形码的功能。
 *
 * @ingroup PGL
 *
 * \~Chinese-Traditional
 * @class PglBarcode_1D
 * @brief 表示一維條碼的類。
 *
 * 該類繼承自ABarcode1D，並提供了初始化和描述一維條碼的功能。
 *
 * @ingroup PGL
 */
@interface PglBarcode_1D : ABarcode1D

/**
 * \~English
 * @brief Initializes a new instance of the PglBarcode_1D class.
 *
 * @return A new instance of PglBarcode_1D.
 *
 * \~Chinese
 * @brief 初始化PglBarcode_1D类的新实例。
 *
 * @return PglBarcode_1D的新实例。
 *
 * \~Chinese-Traditional
 * @brief 初始化PglBarcode_1D類的新實例。
 *
 * @return PglBarcode_1D的新實例。
 */
- (instancetype)init;

/**
 * \~English
 * @brief Initializes a new instance of the PglBarcode_1D class with the specified barcode item.
 *
 * @param barcode The barcode item to be used for initialization.
 * @return A new instance of PglBarcode_1D.
 *
 * \~Chinese
 * @brief 使用指定的条形码项初始化PglBarcode_1D类的新实例。
 *
 * @param barcode 用于初始化的条形码项。
 * @return PglBarcode_1D的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的條碼項初始化PglBarcode_1D類的新實例。
 *
 * @param barcode 用於初始化的條碼項。
 * @return PglBarcode_1D的新實例。
 */
- (instancetype)initWithBarcodeItem:(id<IBarcodeItem>)barcode;

/**
 * \~English
 * @brief Returns the string that can be sent to printer.
 *
 * @return A string description of the PglBarcode_1D instance.
 *
 * \~Chinese
 * @brief 返回可以发送到打印机的字符串。
 *
 * @return PglBarcode_1D实例的字符串描述。
 *
 * \~Chinese-Traditional
 * @brief 返回可以發送到打印機的字符串。
 *
 * @return PglBarcode_1D實例的字符串描述。
 */
- (NSString *)description;

@end

#endif /* PglBarcode_1D_h */
