import Foundation
import UniPRT

func main() {
    let ipAddress = "10.0.10.170"
    let tcpComm = TcpComm(ipAddress: ipAddress, port: 3007)
    tcpComm?.open()

    let printerMonitor = PrinterMonitor(tcpComm: tcpComm)

    var choice = 0
    repeat {
        print("\nMenu:")
        print("1 - Get Printer Info")
        print("2 - Listen to Engine Status")
        print("3 - Listen to Display Status")
        print("4 - Listen to Alert Status")
        print("5 - Print example file")
        print("6 - Exit")
        print("Enter your choice (1-6):")

        if let input = readLine(), let number = Int(input.trimmingCharacters(in: .whitespaces)) {
            choice = number
        }

        switch choice {
        case 1:
            if let prtInfo = printerMonitor?.getPrinterInfo() {
                print("Printer Model: \(prtInfo.model() ?? "")")
                print("Printer SN: \(prtInfo.serialNumber() ?? "")")
                print("Printer FW PN: \(prtInfo.firmwarePartNumber() ?? "")")
                print("Printer FW Ver: \(prtInfo.firmwareVersion() ?? "")")
                print("Printhead Resolution (Dots/Inch): \(prtInfo.printheadResolution() ?? "")")
                print("Has RFID: \(prtInfo.hasRfidOption() == true ? "Yes" : "No")")
                print("Has ODV: \(prtInfo.hasOdvOption() == true ? "Yes" : "No")")
            }

        case 2:
            DispatchQueue.global().async {
                printerMonitor?.engineStatusCallback = { status in
                    print("Engine status update: \(status ?? "")")
                }
                printerMonitor?.setEngineStatusListening(true)
            }

        case 3:
            DispatchQueue.global().async {
                printerMonitor?.displayStatusCallback = { status in
                    print("Display status update: \(status?.joined(separator: ", ") ?? "")")
                }
                printerMonitor?.setDisplayStatusListening(true)
            }

        case 4:
            DispatchQueue.global().async {
                printerMonitor?.alertStatusCallback = { status in
                    print("Alert status update: \(status?.joined(separator: ", ") ?? "")")
                }
                printerMonitor?.setAlertStatusListening(true)
            }

        case 5:
            let tcpComm2 = TcpComm(ipAddress: "10.0.10.171", port: 9100)
            tcpComm2?.open()
            tcpComm2?.sendPrintFile("10.0.10.171", fileName: "/Users/realbuber/Downloads/Hello_1.pgl")
            print("Print file sent.")

        case 6:
            print("Exiting...")

        default:
            print("Invalid choice. Please enter a number between 1 and 6.")
        }
    } while choice != 6
}

main()
