//
//  APdf417.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef APdf417_h
#define APdf417_h

#import <Foundation/Foundation.h>
#import <AutoIdSDK/ABarcode2D.h>
#import <AutoIdSDK/IRectangleCell.h>
#import <AutoIdSDK/Pdf417ErrCorrectionEnum.h>

@interface APdf417 : ABarcode2D <IRectangleCell>

@property (nonatomic, strong) id<IPoint> start;
@property (nonatomic, strong) NSString *data;
@property (nonatomic, strong) id<ICellRect> cellSize;
@property (nonatomic, assign) Pdf417ErrCorrectionEnum errorCorrection;
@property (nonatomic, assign) int rows;
@property (nonatomic, assign) int columns;

- (instancetype)initWithStart:(id<IPoint>)start data:(NSString *)data;
- (int)limitRange:(int)value minimum:(int)min maximum:(int)max;

@end


#endif /* APdf417_h */
