//
//  ATsplCmd.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/9.
//

#ifndef ATsplCmd_h
#define ATsplCmd_h

// ATsplCmd.h
#import <Foundation/Foundation.h>
 // Assuming this is the concrete implementation
#import <AutoIdSDK/ITsplCmd.h>
#import <AutoIdSDK/ITsplParamLine.h>
#import <AutoIdSDK/TsplParamLine.h>


@interface ATsplCmd : NSObject <ITsplCmd>

@property (nonatomic, strong) NSMutableArray<id<ITsplParamLine>> *parameterLines;
@property (nonatomic, strong) NSString *CMD;

- (instancetype)init;
- (instancetype)initWithCmd:(NSString *)cmd;
- (instancetype)initWithCmd:(NSString *)cmd cmdSuffix:(NSString *)cmdSuffix;
- (instancetype)initWithUseSfcc:(BOOL)useSfcc cmd:(NSString *)cmd cmdSuffix:(NSString *)cmdSuffix;

- (void)clearParameterLines;
- (id<ITsplParamLine>)getNewParameterLineWithStartOfLine:(NSString *)startOfLine endOfLine:(NSString *)endOfLine;
- (NSString *)getAsString;

@end

#endif /* ATsplCmd_h */
