//
//  Config.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/4/19.
//

#ifndef Config_h
#define Config_h


#endif /* Config_h */

#import <Foundation/Foundation.h>
#import <AutoIdSDK/JsonStringTokenizer.h>


/**
 * @class Config
 * @brief A class representing a configuration with various properties and methods to manipulate them.
 * @ingroup JSONMng
 */
@interface Config : NSObject

// Initializers

/**
 * @brief Initializes a new instance with the given configuration content.
 *
 * @param cfgContent The content of the configuration.
 * @return An initialized instance of Config, or nil if the object could not be created.
 */
- (instancetype)initWithCfgContent:(NSString *)cfgContent;

/**
 * @brief Initializes a new instance with default values.
 *
 * @return An initialized instance of Config, or nil if the object could not be created.
 */
- (instancetype)init;

// Methods

/**
 * @brief Converts the configuration to a string representation.
 *
 * @return A string representation of the configuration.
 */
- (NSString *)toString;

/**
 * @brief Gets the number associated with the configuration.
 *
 * @return The number associated with the configuration.
 */
- (NSInteger)getNumber;

/**
 * @brief Sets the number associated with the configuration.
 *
 * @param iNumber The number to set.
 */
- (void)setNumber:(int)iNumber;

/**
 * @brief Gets the model associated with the configuration.
 *
 * @return The model associated with the configuration.
 */
- (NSString *)getModel;

/**
 * @brief Sets the model associated with the configuration.
 *
 * @param strModel The model to set.
 */
- (void)setModel:(NSString *)strModel;

/**
 * @brief Gets the name associated with the configuration.
 *
 * @return The name associated with the configuration.
 */
- (NSString *)getName;

/**
 * @brief Sets the name associated with the configuration.
 *
 * @param strName The name to set.
 */
- (void)setName:(NSString *)strName;

/**
 * @brief Gets the program file associated with the configuration.
 *
 * @return The program file associated with the configuration.
 */
- (NSString *)getProgramFile;

/**
 * @brief Sets the program file associated with the configuration.
 *
 * @param strProgramFile The program file to set.
 */
- (void)setProgramFile:(NSString *)strProgramFile;

/**
 * @brief Gets the data associated with the configuration.
 *
 * @return The data associated with the configuration.
 */
- (NSString *)getData;

/**
 * @brief Sets the data associated with the configuration.
 *
 * @param strData The data to set.
 */
- (void)setData:(NSString *)strData;

@end
