//
//  JsonMng.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/7.
//

#ifndef JsonMng_h
#define JsonMng_h


#endif /* JsonMng_h */

/**
 * @class JsonMng
 * @brief A class for managing JSON messages.
 * @ingroup JSONMng
 */
@interface JsonMng : NSObject

/**
 * @brief The command of the JSON message.
 */
@property (nonatomic, strong) NSString *command;

/**
 * @brief The sender of the JSON message.
 */
@property (nonatomic, strong) NSString *from;

/**
 * @brief The recipient of the JSON message.
 */
@property (nonatomic, strong) NSString *to;

/**
 * @brief The track number of the JSON message.
 */
@property (nonatomic, strong) NSString *trackNo;

/**
 * @brief The response string of the JSON message.
 */
@property (nonatomic, strong) NSString *strResponse;

/**
 * @brief Gets the track number of the JSON message.
 *
 * @return The track number as a string.
 */
- (NSString *)getTrackNo;

/**
 * @brief Sets the track number of the JSON message.
 *
 * @param trackNo The track number to set.
 */
- (void)setTrackNo:(NSString *)trackNo;

/**
 * @brief Initializes a new instance with the given management message.
 *
 * @param mgmtMsg The management message to initialize with.
 * @return An initialized instance of JsonMng, or nil if the object could not be created.
 */
- (instancetype)initWithMgmtMsg:(NSString *)mgmtMsg;

@end
