//
//  JsonStringBuilder.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/2.
//


#ifndef JsonStringBuilder_h
#define JsonStringBuilder_h


#endif /* JsonStringBuilder_h */
#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @class JsonStringBuilder
 * @brief A utility class for building JSON strings.
 * @ingroup JSONMng
 */
@interface JsonStringBuilder : NSObject

/**
 * @brief The minimum value for a random message ID.
 */
extern const int MIN_RAND_MSG_ID;

/**
 * @brief The maximum value for a random message ID.
 */
extern const int MAX_RAND_MSG_ID;

/**
 * @brief The minimum value for a random object ID.
 */
extern const int MIN_RAND_OBJ_ID;

/**
 * @brief The maximum value for a random object ID.
 */
extern const int MAX_RAND_OBJ_ID;

/**
 * @brief Gets the prefix for data port messages.
 *
 * @return A string representing the data port prefix.
 */
+ (NSString *)dataPortPrefix;

/**
 * @brief Gets the suffix for data port messages.
 *
 * @return A string representing the data port suffix.
 */
+ (NSString *)dataPortSuffix;

/**
 * @brief Creates a message frame with the specified parameters, optionally using the data port.
 *
 * @param fromId The ID of the sender.
 * @param trackId The tracking ID for the message.
 * @param command The command of the message.
 * @param content The content of the message.
 * @param toId The ID of the recipient.
 * @param usingDataPort A flag indicating whether to use the data port.
 * @return A string representing the message frame.
 */
+ (NSString *)createMsgFrameWithFromId:(NSString *)fromId
                               trackId:(NSString *)trackId
                               command:(NSString *)command
                               content:(NSString *)content
                                  toId:(NSString *)toId
                          usingDataPort:(BOOL)usingDataPort;

/**
 * @brief Creates a message frame with the specified parameters.
 *
 * @param fromId The ID of the sender.
 * @param trackId The tracking ID for the message.
 * @param command The command of the message.
 * @param content The content of the message.
 * @param toId The ID of the recipient.
 * @return A string representing the message frame.
 */
+ (NSString *)createMsgFrameWithFromId:(NSString *)fromId
                               trackId:(NSString *)trackId
                               command:(NSString *)command
                               content:(NSString *)content
                                  toId:(NSString *)toId;

/**
 * @brief Gets a random ID in JSON format.
 *
 * @return A string representing a random ID in JSON format.
 */
+ (NSString *)getRandomIdJson;

/**
 * @brief Gets a random object ID in JSON format.
 *
 * @return A string representing a random object ID in JSON format.
 */
+ (NSString *)getRandomObjectIdJson;

@end

NS_ASSUME_NONNULL_END


