//
//  PglTranslate.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/24.
//

#ifndef PglTranslate_h
#define PglTranslate_h

#import <Foundation/Foundation.h>

#import <AutoIdSDK/RotateEnum.h>
#import <AutoIdSDK/AlignEnum.h>
#import <AutoIdSDK/BarcodeTypeEnum_1D.h>
#import <AutoIdSDK/QRCodeModelEnum.h>
#import <AutoIdSDK/QRCodeErrorCorrectionEnum.h>
#import <AutoIdSDK/QRCodeManualEncodingEnum.h>
#import <AutoIdSDK/RfidMemBlockEnum.h>
#import <AutoIdSDK/RfidPasswordTypeEnum.h>
#import <AutoIdSDK/PGL.h>


@interface PglTranslate : NSObject

+ (PGLRotation)rotationWithEnum:(RotateEnum)rotation;
+ (PGLAlignEnum)alignmentWithEnum:(AlignEnum)align;
+ (PGLBarcodeType1D)barcodeType1DWithEnum:(BarcodeTypeEnum1D)barcodeType;
+ (int)qrCodeModelWithEnum:(QRCodeModelEnum)model;
+ (int)qrCodeErrorCorrectionWithEnum:(QRCodeErrorCorrectionEnum)ErrCorr;
+ (char)qrCodeEncodingWithEnum:(QRCodeManualEncodingEnum)manualEncodeType;
+ (NSString *)rfidMemBlockWithEnum:(RfidMemBlockEnum)memBlockSelect;
+ (NSString *)rfidLockTypeWithEnum:(RfidPasswordTypeEnum)lockType;

@end

#endif /* PglTranslate_h */
