//
//  Setting.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/14.
//

#ifndef Setting_h
#define Setting_h


#endif /* Setting_h */

#import <Foundation/Foundation.h>

/**
 * @class Setting
 * @brief A class representing a configurable setting with various properties.
 * @ingroup JSONMng
 */
@interface Setting : NSObject

/**
 * @brief The type of the setting.
 */
@property (nonatomic, strong) NSString *type;

/**
 * @brief The permission level of the setting (e.g., read-only, read-write).
 */
@property (nonatomic, strong) NSString *permission;

/**
 * @brief The value of the setting.
 */
@property (nonatomic, strong) NSString *value;

/**
 * @brief The minimum allowable value for the setting.
 */
@property (nonatomic, assign) double minimum;

/**
 * @brief The maximum allowable value for the setting.
 */
@property (nonatomic, assign) double maximum;

/**
 * @brief The increment value for the setting.
 */
@property (nonatomic, assign) double increment;

/**
 * @brief The list of allowable options for the setting, if applicable.
 */
@property (nonatomic, strong) NSArray<NSString *> *options;

@end
