//
//  QRCodeErrorCorrectionEnum.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef QRCodeErrorCorrectionEnum_h
#define QRCodeErrorCorrectionEnum_h

#import <Foundation/Foundation.h>

/**
 * \~English
 * @class QRCodeErrorCorrectionEnum
 * @brief Error correction allows for barcodes to remain readable if damaged but increases the amount of data encoded.
 *
 * Higher error correction levels enable barcodes to withstand more damage while remaining readable. However, this also increases the barcode's size because more data is required for higher levels of error correction.
 *
 * @ingroup Interface
 *
 * | Value                           | Description                                              |
 * |---------------------------------|----------------------------------------------------------|
 * | QRCodeErrorCorrection7          | 7% Error Correction. Also known as 'L' level.            |
 * | QRCodeErrorCorrection15         | 15% Error Correction. Also known as 'M' level.           |
 * | QRCodeErrorCorrection25         | 25% Error Correction. Also known as 'Q' level.           |
 * | QRCodeErrorCorrection30         | 30% Error Correction. Also known as 'H' level.           |
 *
 * \~Chinese
 * @class QRCodeErrorCorrectionEnum
 * @brief 纠错功能允许条形码在损坏的情况下仍然可读，但会增加编码的数据量。
 *
 * 较高的纠错级别可以使条形码在受到更多损坏的情况下仍然可读。然而，这也会增加条形码的尺寸，因为较高的纠错级别需要更多的数据。
 *
 * @ingroup Interface
 *
 * | 值                           | 描述                                                      |
 * |---------------------------------|----------------------------------------------------------|
 * | QRCodeErrorCorrection7          | 7% 的纠错。 也称为 'L' 级别。                            |
 * | QRCodeErrorCorrection15         | 15% 的纠错。 也称为 'M' 级别。                           |
 * | QRCodeErrorCorrection25         | 25% 的纠错。 也称为 'Q' 级别。                           |
 * | QRCodeErrorCorrection30         | 30% 的纠错。 也称为 'H' 级别。                           |
 *
 * \~Chinese-Traditional
 * @class QRCodeErrorCorrectionEnum
 * @brief 錯誤更正功能允許條形碼在損壞的情況下仍然可讀，但會增加編碼的數據量。
 *
 * 較高的錯誤更正級別可以使條形碼在受到更多損壞的情況下仍然可讀。然而，這也會增加條形碼的尺寸，因為較高的錯誤更正級別需要更多的數據。
 *
 * @ingroup Interface
 *
 * | 值                           | 描述                                                      |
 * |---------------------------------|----------------------------------------------------------|
 * | QRCodeErrorCorrection7          | 7% 的錯誤更正。 也稱為 'L' 級別。                         |
 * | QRCodeErrorCorrection15         | 15% 的錯誤更正。 也稱為 'M' 級別。                        |
 * | QRCodeErrorCorrection25         | 25% 的錯誤更正。 也稱為 'Q' 級別。                        |
 * | QRCodeErrorCorrection30         | 30% 的錯誤更正。 也稱為 'H' 級別。                        |
 */
typedef NS_ENUM(NSUInteger, QRCodeErrorCorrectionEnum) {
    QRCodeErrorCorrection7 = 0,  ///< \~English 7% Error Correction ('L' level). \~Chinese 7% 的纠错（'L' 级别）。 \~Chinese-Traditional 7% 的錯誤更正（'L' 級別）。
    QRCodeErrorCorrection15,     ///< \~English 15% Error Correction ('M' level). \~Chinese 15% 的纠错（'M' 级别）。 \~Chinese-Traditional 15% 的錯誤更正（'M' 級別）。
    QRCodeErrorCorrection25,     ///< \~English 25% Error Correction ('Q' level). \~Chinese 25% 的纠错（'Q' 级别）。 \~Chinese-Traditional 25% 的錯誤更正（'Q' 級別）。
    QRCodeErrorCorrection30      ///< \~English 30% Error Correction ('H' level). \~Chinese 30% 的纠错（'H' 级别）。 \~Chinese-Traditional 30% 的錯誤更正（'H' 級別）。
};

#endif /* QRCodeErrorCorrectionEnum_h */
