//
//  PrintPlane.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/6.
//

#ifndef PrintPlane_h
#define PrintPlane_h

#import <Foundation/Foundation.h>

#import <UniPRT/IPrintPlane.h>
#import <UniPRT/IPrintResolution.h>
#import <UniPRT/IRuler.h>
#import <UniPRT/IPoint.h>

/** @cond **/

@interface PrintPlane : NSObject <IPrintPlane>

@property (nonatomic, strong) id<IPrintResolution> printerResolution;
@property (nonatomic, strong) id<IRuler> ruler;

- (instancetype)init;  //
- (instancetype)initWithRuler:(id<IRuler>)ruler;  //
- (instancetype)initWithRuler:(id<IRuler>)ruler printResolution:(id<IPrintResolution>)printResolution;  //

//
- (float)dotsPerUnitWithRuler:(id<IRuler>)ruler resolution:(id<IPrintResolution>)resolution;
- (float)dotsToPointsWithDots:(float)dots resolution:(id<IPrintResolution>)resolution;
- (float)inchToDotsWithInchValue:(float)inchValue resolution:(id<IPrintResolution>)resolution;
- (float)inchToPointsWithInchValue:(float)inchValue resolution:(id<IPrintResolution>)resolution;
- (float)mmToDotsWithMMValue:(float)mmValue resolution:(id<IPrintResolution>)resolution;
- (float)mmToPointsWithMMValue:(float)mmValue resolution:(id<IPrintResolution>)resolution;
- (float)toPointsWithScaledNumber:(float)scaledNumber ruler:(id<IRuler>)ruler resolution:(id<IPrintResolution>)resolution;
- (float)toDotsWithScaledNumber:(float)scaledNumber ruler:(id<IRuler>)ruler resolution:(id<IPrintResolution>)resolution;
- (float)toInchWithScaledNumber:(float)scaledNumber ruler:(id<IRuler>)ruler resolution:(id<IPrintResolution>)resolution;
- (float)toMMWithScaledNumber:(float)scaledNumber ruler:(id<IRuler>)ruler resolution:(id<IPrintResolution>)resolution;
- (id<IPoint>)toDotsWithScaledPosition:(id<IPoint>)scaledPosition ruler:(id<IRuler>)ruler resolution:(id<IPrintResolution>)resolution;
+ (int)round:(float)numToRound;
@end

/** @endcond **/

#endif /* PrintPlane_h */
