package com.test.UniPRTSdk;

import android.content.Context;

import com.UniPRT.Sdk.Comm.TcpConnection;
import com.UniPRT.Sdk.Comm.IComm;
import com.UniPRT.Sdk.Json.SettingsReadWrite;
import com.UniPRT.Sdk.Utilities.Tuple;

import java.util.*;

public class SettingsSnippet {
    private static String ACTION_USB_PERMISSION = "com.example.UniPRTsdk_test.USB_PERMISSION";
    static Context ctx;

    public static void test(Context _ctx) {
        ctx = _ctx;
        IComm ptrComm;

        ptrComm = new TcpConnection("192.168.1.50", TcpConnection.DEFAULT_MGMT_PORT);

        try {
            ptrComm.Open();
            System.out.println("\nReading some settings...\n");
            readSomePrinterSettings(ptrComm);

            System.out.println("\nMaking Setting Changes...\n");
            changePrinterSettings(ptrComm);
        } catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        } finally {
            ptrComm.Close();
        }
    }

    public static void readSomePrinterSettings(IComm ptrComm) {
        try {
            if (ptrComm != null) {
                if (!ptrComm.Connected()) {
                    System.out.println("Error: no connection");
                    return;
                }

                SettingsReadWrite mySettings = new SettingsReadWrite(ptrComm);

                // Read individual settings if needed
                System.out.println("LCD Units: '" + mySettings.GetValue("LCD.LabelUnits") + "'");
                System.out.println("Printer Resolution: '" + mySettings.GetValue("Printer.Head.DPI-d") + "'");
                System.out.println("LCD Language: '" + mySettings.GetValue("LCD.Language") + "'");

                // Read list of settings
                System.out.println();
                System.out.println("Reading label settings:");
                List<String> keys = Arrays.asList("Handling.Type", "Image.Length-in", "Image.Width-in", "Image.Clip-b", "Label.Sensor");
                Map<String, String> contentList = mySettings.GetValues(keys);
                for (Map.Entry<String, String> item : contentList.entrySet()) {
                    System.out.println("\"" + item.getKey() + "\" = " + item.getValue());
                }

                mySettings.Dispose();
            }
        } catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public static void changePrinterSettings(IComm ptrComm) {
        try {
            if (ptrComm != null) {
                if (!ptrComm.Connected()) {
                    System.out.println("Error: no connection");
                    return;
                }

                SettingsReadWrite mySettings = new SettingsReadWrite(ptrComm);

                // Change units displayed on LCD
                mySettings.SetValue("LCD.MediaUnits", "\"eInches\"");
                mySettings.SetValue("Image.Length-in", "4.3");

                // Change list of settings
                Map<String, String> setKeys = new HashMap<>();
                setKeys.put("Handling.Type", "\"eContinuous\"");
                setKeys.put("Image.Clip-b", "false");
                setKeys.put("Label.Sensor", "\"eGap\"");

                if (mySettings.SetValues(setKeys)) {
                    System.out.println("SetValues SUCCESS.");
                } else {
                    System.out.println("SetValues failed.");
                }

                System.out.println();
                System.out.println("Settings read after changes made:");
                Map<String, String> contentList = mySettings.GetValues(new ArrayList<>(setKeys.keySet()));
                for (Map.Entry<String, String> item : contentList.entrySet()) {
                    System.out.println("\"" + item.getKey() + "\" = " + item.getValue());
                }

                mySettings.Dispose();
            }
        } catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }
}
