#include "CommSDK.h"
#include "JsonSDK.h"
#include <cstdio>
#include <iostream>
#include <string>
#include <sstream>
#include <string>
#include <cstring>
#include <iomanip>
#include <fstream>
#include <vector>
#include <thread>
#include <mutex>
#include <atomic>
#include <chrono>
#include <condition_variable>



using byte = unsigned char;



void ShowPrinterInfo(stPrinterInfo* pPrtInfo, INFO_TYP InfoTyp)
{
	GetPrinterInfo(pPrtInfo, InfoTyp);

	std::cout << std::endl;
	std::cout << "Printer Model: " << pPrtInfo->Model << std::endl;
	std::cout << "Printer SN: " << pPrtInfo->SerialNumber << std::endl;
	std::cout << "Printer FW PN: " << pPrtInfo->FirmwarePartNumber << std::endl;
	std::cout << "Printer FW Ver: " << pPrtInfo->FirmwareVersion << std::endl;
	std::cout << "Printhead Resolution (Dots/Inch): " << pPrtInfo->PrintheadResolution << std::endl;
	std::cout << std::endl;
	std::cout << "Has RFID: " << (pPrtInfo->HasRfidOption ? "yes" : "no") << std::endl;
	

}


void RfidReportCallback(const RfidReport& report)
{
	if (report.Failed())
	{
		std::cout << "\nRFID Failed." << std::endl;
	}
	else
	{
		std::string memoryType = "";
		switch (report.DataType())
		{
		//case RfidReport::RfidDataType::USR:
        case RfidDataType::USR:
			memoryType = "USR";
			break;
		//case RfidReport::RfidDataType::TID:
        case RfidDataType::TID:
			memoryType = "TID";
			break;
		//case RfidReport::RfidDataType::UNKNOWN:
        case RfidDataType::UNKNOWN:
			memoryType = "UNKNOWN";
			break;
		}

		std::cout << "\nRFID Passed." << std::endl;
		std::cout << "Write Action: " << ((report.IsWriteOperation()) ? "yes" : "no") << std::endl;
		//std::cout << "Operation on EPC Memory: " << ((report.DataType() == RfidReport::RfidDataType::EPC) ? "yes" : "no") << std::endl;
        std::cout << "Operation on EPC Memory: " << ((report.DataType() == RfidDataType::EPC) ? "yes" : "no") << std::endl;
		//if (report.DataType() != RfidReport::RfidDataType::EPC)
        if (report.DataType() != RfidDataType::EPC)
		{
			std::cout << "  memory accessed: " << memoryType << std::endl;
		}

		std::cout << "Data: \n" << report.Data() << std::endl;
	}
}

int main()
{
	
	
    stPrinterInfo PrtInfo;
	std::string ptrIpRfid = "10.0.10.171";

	RfidMonitorConnection((char*)ptrIpRfid.c_str());
	PrinterMonitorConnection((char*)ptrIpRfid.c_str(), INFO_TYP::RFID_TYP);

	std::cout << "\n=======Rfid Printer Info: ";
	ShowPrinterInfo(&PrtInfo, INFO_TYP::RFID_TYP);


	if (PrtInfo.HasRfidOption == false)
	{
		std::cout << "WARNING: Missing RFID option on printer at: " << ptrIpRfid << std::endl;
		return 1;
	}


	// ============================
	// -------------  RFID Printer: setup for RFID report monitoring
	// ============================
	SetRfidReportListening(true);
	SetRfidReportCallback(RfidReportCallback);


	SendPrintFile((char*)(ptrIpRfid.c_str()), (char*)"rfid.pgl");
	std::cout << "Sending RFID print job..." << std::endl;


	int userInput;

	// 循環等待用戶輸入，直到用戶輸入0為止
	do {

		std::cout << std::endl;
		std::cout << std::endl;
		std::cout << "Press 0 to exit";
		std::cout << std::endl;
		std::cin >> userInput;
	} while (userInput != 0);

	// 使用者輸入0後程式結束
	std::cout << std::endl;
	std::cout << "Program exit" << std::endl;
	std::cout << std::endl;

	Close();
	RfidMonitorDispose();
	PrinterMonitorDispose(INFO_TYP::RFID_TYP);


	
    return 0;

}



