package com.test.AutoIdSdk;

import com.AutoId.Sdk.Comm.TcpConnection;
import com.AutoId.Sdk.Comm.UsbConnection;
import com.AutoId.Sdk.Comm.IComm;
import com.AutoId.Sdk.Json.SettingsReadWrite;
import com.AutoId.Sdk.Utilities.Tuple;

import java.util.*;

public class SettingsSnippet {
    public static void main(String[] args) {
        IComm ptrComm;

        // ptrComm = getUsbConnection();
        ptrComm = new TcpConnection("192.168.1.50", TcpConnection.DEFAULT_MGMT_PORT);

        try {
            ptrComm.Open();
            System.out.println("\nReading some settings...\n");
            readSomePrinterSettings(ptrComm);

            System.out.println("\nMaking Setting Changes...\n");
            changePrinterSettings(ptrComm);
        } catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        } finally {
            ptrComm.Close();
        }
    }

    public static IComm getUsbConnection() {
        UsbConnection ptrUsbComm = null;
        List<Tuple<Short, Short>> devices = UsbConnection.AvaliableDevices();
        if (devices.size() > 0) {
            System.out.println(devices.size() + " USB devices found...\n");
            for (int i = 0; i < devices.size(); i++) {
                Tuple<Short, Short> device = devices.get(i);
                System.out.println("Device " + i + ": VendorID= " + Integer.toHexString(device.GetX()) + " ProductID=" + Integer.toHexString(device.GetY()));
                if (UsbConnection.PTX_USB_VID == device.GetX()) {
                    ptrUsbComm = new UsbConnection(device.GetX(), device.GetY());
                    break;
                }
            }
        }

        return ptrUsbComm;
    }

    public static void readSomePrinterSettings(IComm ptrComm) {
        try {
            if (ptrComm != null) {
                if (!ptrComm.Connected()) {
                    System.out.println("Error: no connection");
                    return;
                }

                SettingsReadWrite mySettings = new SettingsReadWrite(ptrComm);

                // Read individual settings if needed
                System.out.println("LCD Units: '" + mySettings.GetValue("LCD.LabelUnits") + "'");
                System.out.println("Printer Resolution: '" + mySettings.GetValue("Printer.Head.DPI-d") + "'");
                System.out.println("LCD Language: '" + mySettings.GetValue("LCD.Language") + "'");

                // Read list of settings
                System.out.println();
                System.out.println("Reading label settings:");
                List<String> keys = Arrays.asList("Handling.Type", "Image.Length-in", "Image.Width-in", "Image.Clip-b", "Label.Sensor");
                Map<String, String> contentList = mySettings.GetValues(keys);
                for (Map.Entry<String, String> item : contentList.entrySet()) {
                    System.out.println("\"" + item.getKey() + "\" = " + item.getValue());
                }

                mySettings.Dispose();
            }
        } catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public static void changePrinterSettings(IComm ptrComm) {
        try {
            if (ptrComm != null) {
                if (!ptrComm.Connected()) {
                    System.out.println("Error: no connection");
                    return;
                }

                SettingsReadWrite mySettings = new SettingsReadWrite(ptrComm);

                // Change units displayed on LCD
                mySettings.SetValue("LCD.MediaUnits", "\"eInches\"");
                mySettings.SetValue("Image.Length-in", "4.3");

                // Change list of settings
                Map<String, String> setKeys = new HashMap<>();
                setKeys.put("Handling.Type", "\"eContinuous\"");
                setKeys.put("Image.Clip-b", "false");
                setKeys.put("Label.Sensor", "\"eGap\"");

                if (mySettings.SetValues(setKeys)) {
                    System.out.println("SetValues SUCCESS.");
                } else {
                    System.out.println("SetValues failed.");
                }

                System.out.println();
                System.out.println("Settings read after changes made:");
                Map<String, String> contentList = mySettings.GetValues(new ArrayList<>(setKeys.keySet()));
                for (Map.Entry<String, String> item : contentList.entrySet()) {
                    System.out.println("\"" + item.getKey() + "\" = " + item.getValue());
                }

                mySettings.Dispose();
            }
        } catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }
}
