//
//  IBarcode1D.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef IBarcode1D_h
#define IBarcode1D_h

#import <Foundation/Foundation.h>

#import <UniPRT/IBarcode_1D_Properties.h>
#import <UniPRT/IBarcodeItem.h>

/**
 * @~english
 * @protocol IBarcode1D
 * @brief A protocol defining the interface for Barcode1D classes.
 * @ingroup Interface
 *
 * @~chinese
 * @protocol IBarcode1D
 * @brief 定义 Barcode1D 类接口的协议。
 * @ingroup Interface
 *
 * @~chinese_traditional
 * @protocol IBarcode1D
 * @brief 定義 Barcode1D 類接口的協議。
 * @ingroup Interface
 */
@protocol IBarcode1D <IBarcode_1D_Properties>

/**
 * @~english
 * @brief An array of barcode items.
 *
 * @~chinese
 * @brief 条码项目的数组。
 *
 * @~chinese_traditional
 * @brief 條碼項目的數組。
 */
@property (nonatomic, strong) NSMutableArray<id<IBarcodeItem>> *barcodes;

/**
 * @~english
 * @brief Returns the string that can be sent to printer.
 *
 * @~chinese
 * @brief 返回可发送到打印机的字符串。
 *
 * @~chinese_traditional
 * @brief 返回可發送到打印機的字符串。
 */
- (NSString *)description;

@end

#endif /* IBarcode1D_h */
