//
//  Point.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/6.
//

#ifndef Point_h
#define Point_h

#import <Foundation/Foundation.h>

#import <UniPRT/APair.h>
#import <UniPRT/IPoint.h>

/**
 * @~english
 * @class Points
 * @brief A class for Points, inheriting from IPoint.
 * @ingroup Interface
 *
 * This class provides an implementation for a point in a 2D coordinate system, defining both the horizontal (x) and vertical (y) positions.
 *
 * @~chinese
 * @class Points
 * @brief 继承自 IPoint 的 Points 类。
 * @ingroup Interface
 *
 * 此类用于在二维坐标系中定义一个点，指定水平 (x) 和垂直 (y) 位置。
 *
 * @~chinese_traditional
 * @class Points
 * @brief 繼承自 IPoint 的 Points 類。
 * @ingroup Interface
 *
 * 此類用於在二維坐標系中定義一個點，指定水平 (x) 和垂直 (y) 位置。
 */
@interface Points : APair <IPoint>

/**
 * @~english
 * @brief Initializes a new instance with the given x and y.
 *
 * @param x First value. e.g. Horizontal, x, position of a point.
 * @param y Second value. e.g. Vertical, y, position of a point.
 * @return An initialized instance of Points, or nil if the object could not be created.
 *
 * @~chinese
 * @brief 用给定的 x 和 y 初始化一个新的实例。
 *
 * @param x 第一个值，例如点的水平 (x) 位置。
 * @param y 第二个值，例如点的垂直 (y) 位置。
 * @return 初始化的 Points 实例，如果对象无法创建则返回 nil。
 *
 * @~chinese_traditional
 * @brief 用給定的 x 和 y 初始化一個新的實例。
 *
 * @param x 第一個值，例如點的水平 (x) 位置。
 * @param y 第二個值，例如點的垂直 (y) 位置。
 * @return 初始化的 Points 實例，如果對象無法創建則返回 nil。
 */
- (instancetype)initWithX:(float)x y:(float)y;

@end


#endif /* Point_h */
