//
//  AMaxicodeMsgStructuredOpenSystemStandard.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef AMaxicodeMsgStructuredOpenSystemStandard_h
#define AMaxicodeMsgStructuredOpenSystemStandard_h

#import <Foundation/Foundation.h>
#import <UniPRT/IMaxicodeMsgStructuredOpenSystemStandard.h>
#import <UniPRT/MaxicodeModeEnum.h>

/**
 * @~english
 * @class AMaxicodeMsgStructuredOpenSystemStandard
 * @brief This class applies only to Mode 2 or 3.
 *
 *
 * @ingroup Labelmaker
 *
 * @~chinese
 * @class AMaxicodeMsgStructuredOpenSystemStandard
 * @brief 此类仅适用于模式2或模式3。
 *
 *
 * @ingroup Labelmaker
 *
 * @~chinese_traditional
 * @class AMaxicodeMsgStructuredOpenSystemStandard
 * @brief 此類僅適用於模式2或模式3。
 *
 *
 * @ingroup Labelmaker
 */

@interface AMaxicodeMsgStructuredOpenSystemStandard : NSObject <IMaxicodeMsgStructuredOpenSystemStandard>
@property (nonatomic, copy) NSString *postalCode;
@property (nonatomic, copy) NSString *countryCode;
@property (nonatomic, copy) NSString *serviceClass;
@property (nonatomic, copy) NSString *year;
@property (nonatomic, copy) NSString *remainingMsg;
@property (nonatomic, assign) MaxicodeModeEnum mode;

- (instancetype)init;
- (instancetype)initWithMode:(MaxicodeModeEnum)mode year:(NSString *)year postalCode:(NSString *)postalCode countryCode:(NSString *)countryCode serviceClass:(NSString *)serviceClass remainingMsg:(NSString *)remainingMsg NS_DESIGNATED_INITIALIZER;

@end

#endif /* AMaxicodeMsgStructuredOpenSystemStandard_h */
