//
//  IRectangleCell.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef IRectangleCell_h
#define IRectangleCell_h

#import <Foundation/Foundation.h>
#import <UniPRT/ICellRect.h>

/**
 * @~english
 * @protocol IRectangleCell
 * @brief A protocol defining the interface for RectangleCell classes.
 * @ingroup Interface
 *
 * @~chinese
 * @protocol IRectangleCell
 * @brief 定义矩形单元类接口的协议。
 * @ingroup Interface
 *
 * @~chinese_traditional
 * @protocol IRectangleCell
 * @brief 定義矩形單元類接口的協議。
 * @ingroup Interface
 */
@protocol IRectangleCell <NSObject>

/**
 * @~english
 * @brief Barcode cell size. Larger cell size results in barcodes that take up a larger area.
 *
 * @~chinese
 * @brief 条码单元大小。较大的单元大小会使条码占用更大的面积。
 *
 * @~chinese_traditional
 * @brief 條碼單元大小。較大的單元大小會使條碼占用更大的面積。
 */
@property (nonatomic, strong) id<ICellRect> cellSize;  // Barcode cell size for rectangle cells

@end

#endif /* IRectangleCell_h */
