#import "ViewController.h"

@import UniPRT;

@interface ViewController ()
@property (strong) TcpComm *tcpComm;
@property (nonatomic, strong) UITextField *ipTextField;
@property (nonatomic, strong) UITextView *resultTextView;
@property (nonatomic, strong) UITextView *callbackTextView;
@property (nonatomic, strong) UIButton *openButton;
@property (nonatomic, strong) UIButton *readButton;
@property (nonatomic, strong) UIButton *connectCloseButton;
@property (nonatomic, strong) UITextView *textView;
@property (nonatomic, strong) UISegmentedControl *connectionSegmentedControl;
@property (nonatomic, strong) UIButton *connectshowPrinterInfoTestButton;
@property (nonatomic, strong) UIButton *connectOdvMonitorTestButton;
@property (nonatomic, strong) UIButton *connectPrintTestButton;
@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    UIScrollView *scrollView = [[UIScrollView alloc] initWithFrame:self.view.bounds];
    scrollView.contentSize = CGSizeMake(self.view.bounds.size.width, 1500);
    scrollView.userInteractionEnabled = YES;
    scrollView.scrollEnabled = YES;
    [self.view addSubview:scrollView];
    
    // Create and configure IP address text field
    self.ipTextField = [[UITextField alloc] initWithFrame:CGRectMake(20, 50, 200, 30)];
    self.ipTextField.placeholder = @"Enter IP Address";
    self.ipTextField.borderStyle = UITextBorderStyleRoundedRect;
    [scrollView addSubview:self.ipTextField];
    self.ipTextField.text = @"10.0.10.178";
    
    // Create and configure result text view
    self.resultTextView = [[UITextView alloc] initWithFrame:CGRectMake(20, 150, 300, 200)];
    self.resultTextView.editable = NO;
    self.resultTextView.scrollEnabled = YES;
    self.resultTextView.layer.borderWidth = 1.0;
    self.resultTextView.layer.borderColor = [[UIColor blackColor] CGColor];
    [scrollView addSubview:self.resultTextView];
    
    // Create callback text view
    self.callbackTextView = [[UITextView alloc] initWithFrame:CGRectMake(20, 550, 300, 1000)];
    self.callbackTextView.editable = NO;
    self.callbackTextView.scrollEnabled = YES;
    self.callbackTextView.layer.borderWidth = 1.0;
    self.callbackTextView.layer.borderColor = [[UIColor blackColor] CGColor];
    [scrollView addSubview:self.callbackTextView];
    
    self.connectCloseButton = [self createButtonWithTitle:@"Connect" frame:CGRectMake(20, 370, 300, 30)];
    self.connectCloseButton.backgroundColor = [UIColor redColor];
    [self.connectCloseButton addTarget:self action:@selector(connectCloseButtonPressed) forControlEvents:UIControlEventTouchUpInside];
    [scrollView addSubview:self.connectCloseButton];
    
    // Create and configure buttons
    self.openButton = [self createButtonWithTitle:@"Open" frame:CGRectMake(20, 420, 300, 30)];
    self.openButton.backgroundColor = [UIColor redColor];
    [self.openButton addTarget:self action:@selector(openButtonPressed) forControlEvents:UIControlEventTouchUpInside];
    [scrollView addSubview:self.openButton];
    
    self.connectshowPrinterInfoTestButton = [self createButtonWithTitle:@"showPrinterInfoTest" frame:CGRectMake(20, 460, 300, 30)];
    self.connectshowPrinterInfoTestButton.backgroundColor = [UIColor redColor];
    [self.connectshowPrinterInfoTestButton addTarget:self action:@selector(showPrinterInfoTestButtonPressed) forControlEvents:UIControlEventTouchUpInside];
    [scrollView addSubview:self.connectshowPrinterInfoTestButton];
    
    self.connectOdvMonitorTestButton = [self createButtonWithTitle:@"OdvMonitorTest" frame:CGRectMake(20, 500, 300, 30)];
    self.connectOdvMonitorTestButton.backgroundColor = [UIColor redColor];
    [self.connectOdvMonitorTestButton addTarget:self action:@selector(odvMonitorTestButtonPressed) forControlEvents:UIControlEventTouchUpInside];
    [scrollView addSubview:self.connectOdvMonitorTestButton];
    
    self.connectPrintTestButton = [self createButtonWithTitle:@"PrinterTest" frame:CGRectMake(20, 535, 300, 30)];
    self.connectPrintTestButton.backgroundColor = [UIColor redColor];
    [self.connectPrintTestButton addTarget:self action:@selector(connectPrintTestButtonPressed) forControlEvents:UIControlEventTouchUpInside];
    [scrollView addSubview:self.connectPrintTestButton];
}

- (UIButton *)createButtonWithTitle:(NSString *)title frame:(CGRect)frame {
    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
    button.frame = frame;
    [button setTitle:title forState:UIControlStateNormal];
    return button;
}

- (void)openButtonPressed {
    [self.tcpComm open];
}

- (void)connectCloseButtonPressed {
    NSString *currentTitle = [self.connectCloseButton titleForState:UIControlStateNormal];
    
    if ([currentTitle isEqualToString:@"Connect"]) {
        NSString *ipAddress = self.ipTextField.text;
        self.tcpComm = [[TcpComm alloc] initWithIPAddress:ipAddress port:3007];
        [self.connectCloseButton setTitle:@"Close" forState:UIControlStateNormal];
    } else if ([currentTitle isEqualToString:@"Close"]) {
        [self.tcpComm close];
        [self.connectCloseButton setTitle:@"Connect" forState:UIControlStateNormal];
    }
}

- (void)showPrinterInfoTestButtonPressed {
    PrinterMonitor *printerMonitor = [[PrinterMonitor alloc] initWithTcpComm:self.tcpComm];
    PrinterInfo *printerInfo = [printerMonitor getPrinterInfo];
    NSMutableString *receivedString = [[NSMutableString alloc] init];
    [receivedString appendString:@"======= ODV Printer Info: \n"];
    [receivedString appendFormat:@"Printer Model: %@\n", printerInfo.model];
    [receivedString appendFormat:@"Printer SN: %@\n", printerInfo.serialNumber];
    [receivedString appendFormat:@"Printer FW PN: %@\n", printerInfo.firmwarePartNumber];
    [receivedString appendFormat:@"Printer FW Ver: %@\n", printerInfo.firmwareVersion];
    [receivedString appendFormat:@"Printhead Resolution (Dots/Inch): %@\n", printerInfo.printheadResolution];
    [receivedString appendFormat:@"Has ODV: %@\n", printerInfo.hasOdvOption ? @"Yes" : @"No"];

    NSLog(@"%@", receivedString);
    self.resultTextView.text = receivedString;
}

- (void)odvMonitorTestButtonPressed {
    OdvMonitor *odvMonitor = [[OdvMonitor alloc] initWithTcpComm:self.tcpComm];
    NSMutableString *receivedString = [[NSMutableString alloc] init];
    
    odvMonitor.odvReportCallback = ^(OdvReport *report) {
        if ([report failed]) {
            [receivedString appendFormat:@"\nBarcode Failed."];
        } else {
            [receivedString appendFormat:@"\nBarcode Passed."];
            [receivedString appendFormat:@"Grade: %f", [report overallGradeAsFloat]];
            if ([report overallGradeAsFloat] > 3.5) {
                [receivedString appendFormat:@"Print Quality passed. \n Overall Grade= %.2f", [report overallGradeAsFloat]];
            } else {
                [receivedString appendFormat:@"Print Quality Failed. \n Overall Grade= %.2f", [report overallGradeAsFloat]];
            }
            [receivedString appendFormat:@"Barcode Symbology: %@", [report symbology]];
            [receivedString appendFormat:@"Barcode Data: %@", [report data]];
            dispatch_async(dispatch_get_main_queue(), ^{
                self.callbackTextView.text = receivedString;
            });
        }
    };
    
    [odvMonitor SetOdvReportListening:YES];
}

- (void)connectPrintTestButtonPressed {
    NSString *ipAddress = self.ipTextField.text;
    TcpComm *tcpComm2 = [[TcpComm alloc] initWithIPAddress:ipAddress port:DEFAULT_DATA_PORT];
    [tcpComm2 sendPrintFile:ipAddress fileName:@"/Users/realbuber/Documents/doc/TestOdvMonitor/DM_PRINTRONIX_1.pgl"];
    NSLog(@"Sending ODV print job...");
}

@end
