//
//  IPrintResolution.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/6.
//

#ifndef IPrintResolution_h
#define IPrintResolution_h

#import <Foundation/Foundation.h>

/**
 * \~English
 * @protocol IPrintResolution
 * @brief The print resolution can be set in either inch or millimeter (MM) scale. Setting or updating either scale results in updates to both.
 *
 * The print resolution must match the resolution of the printer. Incorrect printing will occur if the resolution does not match the printer's specification.
 *
 * \~Chinese
 * @protocol IPrintResolution
 * @brief 打印分辨率可以设置为英寸或毫米 (MM) 尺度。设置或更新任一尺度将导致两者的更新。
 *
 * 打印分辨率必须与打印机的分辨率匹配。如果分辨率与打印机的规格不匹配，将导致打印不正确。
 *
 * \~Chinese-Traditional
 * @protocol IPrintResolution
 * @brief 打印解析度可以設置為英寸或毫米 (MM) 尺度。設置或更新任一尺度將導致兩者的更新。
 *
 * 打印解析度必須與打印機的解析度匹配。如果解析度與打印機的規格不匹配，將導致打印不正確。
 *
 * @ingroup Interface
 */
@protocol IPrintResolution <NSObject>

/**
 * \~English
 * @brief Dots per Inch (DPI) print resolution.
 *
 * \~Chinese
 * @brief 每英寸点数 (DPI) 的打印分辨率。
 *
 * \~Chinese-Traditional
 * @brief 每英寸點數 (DPI) 的打印解析度。
 */
@property (nonatomic) float dotsPerInch;

/**
 * \~English
 * @brief Dots per millimeter (DPMM) print resolution.
 *
 * \~Chinese
 * @brief 每毫米点数 (DPMM) 的打印分辨率。
 *
 * \~Chinese-Traditional
 * @brief 每毫米點數 (DPMM) 的打印解析度。
 */
@property (nonatomic) float dotsPerMM;

@end

#endif /* IPrintResolution_h */
