//
//  IRuler.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/6.
//

#import <Foundation/Foundation.h>

/**
 * \~English
 * @class ScaleEnum
 * @brief Scale types for object placement within a plane.
 * @ingroup Interface
 *
 * This enumeration defines the different scale types that can be used for object placement within a two-dimensional plane.
 *
 * | Value               | Description                         |
 * |---------------------|-------------------------------------|
 * | ScaleEnumDot        | Dot scale.                          |
 * | ScaleEnumMM         | Millimeter scale.                   |
 * | ScaleEnumInch       | Inch scale.                         |
 *
 * \~Chinese
 * @class ScaleEnum
 * @brief 对象在平面内放置的刻度类型。
 * @ingroup Interface
 *
 * 该枚举定义了可以用于在二维平面内放置对象的不同刻度类型。
 *
 * | 值                     | 描述                               |
 * |---------------------|-----------------------------------|
 * | ScaleEnumDot        | 点刻度。                           |
 * | ScaleEnumMM         | 毫米刻度。                         |
 * | ScaleEnumInch       | 英寸刻度。                         |
 *
 * \~Chinese-Traditional
 * @class ScaleEnum
 * @brief 對象在平面內放置的刻度類型。
 * @ingroup Interface
 *
 * 該枚舉定義了可以用於在二維平面內放置對象的不同刻度類型。
 *
 * | 值                     | 描述                               |
 * |---------------------|-----------------------------------|
 * | ScaleEnumDot        | 點刻度。                           |
 * | ScaleEnumMM         | 毫米刻度。                         |
 * | ScaleEnumInch       | 英寸刻度。                         |
 */
typedef NS_ENUM(NSInteger, ScaleEnum) {
    ScaleEnumDot,
    ScaleEnumMM,
    ScaleEnumInch
};

/**
 * \~English
 * @protocol IRuler
 * @brief The units and resolution used for object placement within a plane.
 *
 * Objects can be placed on a plane based on Inch, MM, or Dot positioning. In order for proper placement of objects within a plane, it is necessary to know the native dot resolution of the printing device.
 *
 * @ingroup Interface
 *
 * \~Chinese
 * @protocol IRuler
 * @brief 对象在平面内放置时使用的单位和分辨率。
 *
 * 对象可以根据英寸、毫米或点位置放置在平面上。为了在平面内正确放置对象，必须了解打印设备的本机点分辨率。
 *
 * @ingroup Interface
 *
 * \~Chinese-Traditional
 * @protocol IRuler
 * @brief 對象在平面內放置時使用的單位和解析度。
 *
 * 對象可以根據英寸、毫米或點位置放置在平面上。為了在平面內正確放置對象，必須了解打印設備的本機點解析度。
 *
 * @ingroup Interface
 */
@protocol IRuler <NSObject>

/**
 * \~English
 * @brief Scale used for object placement within a plane.
 *
 * \~Chinese
 * @brief 在平面内放置对象时使用的刻度。
 *
 * \~Chinese-Traditional
 * @brief 在平面內放置對象時使用的刻度。
 */
@property (nonatomic) ScaleEnum scale;
@end
