//
//  PglPdf417Barcode.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/27.
//

#ifndef PglPdf417Barcode_h
#define PglPdf417Barcode_h

#import <Foundation/Foundation.h>

#import <UniPRT/APdf417.h>
#import <UniPRT/IPoint.h>

/**
 * \~English
 * @class PglPdf417Barcode
 * @brief A class representing a PDF417 barcode.
 *
 * This class inherits from APdf417 and provides functionality for initializing and describing PDF417 barcodes.
 *
 * @ingroup PGL
 *
 * \~Chinese
 * @class PglPdf417Barcode
 * @brief 表示 PDF417 条码的类。
 *
 * 该类继承自 APdf417，并提供了初始化和描述 PDF417 条码的功能。
 *
 * @ingroup PGL
 *
 * \~Chinese-Traditional
 * @class PglPdf417Barcode
 * @brief 表示 PDF417 條碼的類。
 *
 * 該類繼承自 APdf417，並提供了初始化和描述 PDF417 條碼的功能。
 *
 * @ingroup PGL
 */
@interface PglPdf417Barcode : APdf417

/**
 * \~English
 * @brief The starting point of the barcode.
 *
 * \~Chinese
 * @brief 条码的起始点。
 *
 * \~Chinese-Traditional
 * @brief 條碼的起始點。
 */
@property (nonatomic, strong) id<IPoint> start;

/**
 * \~English
 * @brief The data to be encoded in the barcode.
 *
 * \~Chinese
 * @brief 要在条码中编码的数据。
 *
 * \~Chinese-Traditional
 * @brief 要在條碼中編碼的數據。
 */
@property (nonatomic, strong) NSString *data;

/**
 * \~English
 * @brief Initializes a new instance of the PglPdf417Barcode class with the specified start point and data.
 *
 * @param start The starting point of the barcode.
 * @param data The data to be encoded in the barcode.
 * @return A new instance of PglPdf417Barcode.
 *
 * \~Chinese
 * @brief 使用指定的起始点和数据初始化 PglPdf417Barcode 类的新实例。
 *
 * @param start 条码的起始点。
 * @param data 要在条码中编码的数据。
 * @return PglPdf417Barcode 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的起始點和數據初始化 PglPdf417Barcode 類的新實例。
 *
 * @param start 條碼的起始點。
 * @param data 要在條碼中編碼的數據。
 * @return PglPdf417Barcode 的新實例。
 */
- (instancetype)initWithStart:(id<IPoint>)start data:(NSString *)data;

/**
 * \~English
 * @brief Returns a string that can be sent to the printer.
 *
 * This method generates a string representation of the PglPdf417Barcode instance that
 * is formatted and ready to be sent to a printer. The string includes all the
 * necessary commands and data required for printing.
 *
 * @return A string description of the PglPdf417Barcode instance.
 *
 * \~Chinese
 * @brief 返回可以发送到打印机的字符串。
 *
 * 该方法生成 PglPdf417Barcode 实例的字符串表示形式，
 * 格式化并准备好发送到打印机。字符串包括打印所需的所有命令和数据。
 *
 * @return PglPdf417Barcode 实例的字符串描述。
 *
 * \~Chinese-Traditional
 * @brief 返回可以發送到打印機的字符串。
 *
 * 該方法生成 PglPdf417Barcode 實例的字符串表示形式，
 * 格式化並準備好發送到打印機。字符串包括打印所需的所有命令和數據。
 *
 * @return PglPdf417Barcode 實例的字符串描述。
 */
- (NSString *)description;

@end

#endif /* PglPdf417Barcode_h */
