//
//  IFontSettings.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef IFontSettings_h
#define IFontSettings_h

// IFontSettings.h
#import <Foundation/Foundation.h>

#import <UniPRT/IFont.h>
#import <UniPRT/IFontStyle.h>
#import <UniPRT/IFontSizeUnits.h>

/**
 * \~English
 * @protocol IFontSettings
 * @brief A protocol defining the interface for FontSettings classes.
 * @ingroup Interface
 *
 * This protocol defines the interface for classes that handle font settings, including font type, style, and size units.
 *
 * \~Chinese
 * @protocol IFontSettings
 * @brief 定义FontSettings类的接口的协议。
 * @ingroup Interface
 *
 * 此协议定义了处理字体设置的类的接口，包括字体类型、样式和大小单位。
 *
 * \~Chinese-Traditional
 * @protocol IFontSettings
 * @brief 定義FontSettings類的接口的協議。
 * @ingroup Interface
 *
 * 此協議定義了處理字體設置的類的接口，包括字體類型、樣式和大小單位。
 */
@protocol IFontSettings <IFont, IFontStyle, IFontSizeUnits>
@end

#endif /* IFontSettings_h */
