//
//  JsonConnection.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/8.
//

#ifndef JsonConnection_h
#define JsonConnection_h


#endif /* JsonConnection_h */

#import <Foundation/Foundation.h>
#import <AutoIdSDK/TcpComm.h>
#import <AutoIdSDK/JsonComm.h>


@interface JsonConnection : NSObject {
    // Instance variables
    NSInteger _userCount;
    NSString *_descriptor;
    // Assuming TcpConnection and TcpComm are also translated to Objective-C
    TcpComm *_tcpComm;
    JsonComm *_jsonComm;
    BOOL _disposed;
}

// Initializers
//- (instancetype)init;
- (instancetype)initWithCommDescriptor:(NSString *)commDescriptor;

// APIs
//- (void)jsonConnectionInitWithCommDescriptor:(NSString *)commDescriptor;
- (NSInteger)addUser;
- (NSInteger)removeUser;
- (NSInteger)getUserCount;
- (NSString *)getDescriptor;
- (void)dispose;
- (TcpComm *)getPtrComm;
- (JsonComm *)getJsonComm;

@end
