//
//  RfidMonitor.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/04/11.
//

#ifndef RfidMonitor_h
#define RfidMonitor_h

#import <Foundation/Foundation.h>
#import <AutoIdSDK/TcpComm.h>
#import <AutoIdSDK/JsonComm.h>
#import <AutoIdSDK/SynchronizationContext.h>
#import <AutoIdSDK/JsonCommController.h>
#import <AutoIdSDK/RfidReport.h>


@interface RfidMonitor : NSObject

@property (nonatomic, strong) NSString *DONT_CARE_ID;
@property (nonatomic, strong) NSString *engineStatus;
@property (nonatomic, strong) NSArray<NSString *> *alertStatus;
@property (nonatomic, strong) NSArray<NSString *> *displayStatus;
@property (nonatomic, strong) NSString *managedDescriptor;
@property (nonatomic) BOOL rfidReportListening;
@property (nonatomic, strong) NSThread *listenerThread;
@property (nonatomic, strong) SynchronizationContext *syncContext;

- (instancetype)initWithTcpComm:(TcpComm *)connection;
- (instancetype)initWithJsonComm:(JsonComm *)mgmtComm;
- (instancetype)initWithCommDescriptor:(NSString *)commDescriptor;
- (void)SetRfidReportListening:(BOOL)value;

typedef void (^RfidReportCallback)(RfidReport *report);
@property (nonatomic, copy) RfidReportCallback rfidReportCallback;

@end

#endif /* RfidMonitor_h */


