//
//  BarcodeItem.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef BarcodeItem_h
#define BarcodeItem_h

#import <Foundation/Foundation.h>
#import <UniPRT/ABarcodeItem.h>
#import <UniPRT/IPoint.h>


/**
 * @~english
 * @class BarcodeItem
 * @brief A class for BarcodeItem, inheriting from ABarcodeItem class.
 * @ingroup Interface
 *
 * @~chinese
 * @class BarcodeItem
 * @brief BarcodeItem 类，继承自 ABarcodeItem 类。
 * @ingroup Interface
 *
 * @~Chinese-Traditional
 * @class BarcodeItem
 * @brief BarcodeItem 類，繼承自 ABarcodeItem 類。
 * @ingroup Interface
 */
@interface BarcodeItem : ABarcodeItem

- (instancetype)initWithStart:(id<IPoint>)start data:(NSString *)data;
- (instancetype)initWithStart:(id<IPoint>)start height:(float)height data:(NSString *)data;
- (instancetype)initWithXStart:(float)xStart yStart:(float)yStart data:(NSString *)data;
- (instancetype)initWithXStart:(float)xStart yStart:(float)yStart height:(float)height data:(NSString *)data;

@end

#endif /* BarcodeItem_h */
