//
//  PglAlphanumeric.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/23.
//

#ifndef PglAlphanumeric_h
#define PglAlphanumeric_h

#import <Foundation/Foundation.h>

#import <UniPRT/PglCmd.h>
#import <UniPRT/PGL.h>


NS_ASSUME_NONNULL_BEGIN

/** @cond */

@interface PglAlphanumeric : NSObject

@property (nonatomic, assign) int SR;
@property (nonatomic, assign) int SC;
@property (nonatomic, assign) int VE;
@property (nonatomic, assign) int HE;
@property (nonatomic, strong) NSString *data;
@property (nonatomic, assign) BOOL dark;
@property (nonatomic, assign) BOOL reverse;
@property (nonatomic, assign) BOOL usingPoints;
@property (nonatomic, assign) PGLRotation rotation;
@property (nonatomic, assign) PGLAlignEnum align;

- (instancetype)initWithSR:(int)sr SC:(int)sc VE:(int)ve HE:(int)he data:(NSString *)data;
- (NSString *)description;

@end

/** @endcond */

NS_ASSUME_NONNULL_END

#endif /* PglAlphanumeric_h */
