//
//  IPoint.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/6.
//

#ifndef IPoint_h
#define IPoint_h

#import <UniPRT/IPair.h>

/**
 * \~English
 * @protocol IPoint
 * @brief Represents a coordinate pair within a 2D plane.
 * @ingroup Interface
 *
 * This protocol is used to define a coordinate point on a two-dimensional plane. It inherits from the IPair protocol.
 *
 * \~Chinese
 * @protocol IPoint
 * @brief 表示二维平面内的坐标对。
 * @ingroup Interface
 *
 * 此协议用于定义二维平面上的一个坐标点。它继承自 IPair 协议。
 *
 * \~Chinese-Traditional
 * @protocol IPoint
 * @brief 表示二維平面內的座標對。
 * @ingroup Interface
 *
 * 此協議用於定義二維平面上的一個座標點。它繼承自 IPair 協議。
 */
@protocol IPoint <IPair>

@end

#endif /* IPoint_h */
