﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Collections.Generic;
using System.IO;
using System.Drawing.Imaging;
using System.Windows.Forms;
using System.Threading;
using OposPOSPrinter_CCO;

namespace opos1
{
    public enum ResultCode { OPOS_SUCCESS = 0, OPOS_E_CLOSED = 101, OPOS_E_CLAIMED = 102, OPOS_E_NOTCLAIMED = 103, OPOS_E_NOSERVICE = 104 };
    public partial class Form1 : Form
    {

        const int PTR_S_JOURNAL = 1;
        const int PTR_S_RECEIPT = 2;
        const int PTR_BM_CENTER = -2;
        const int PTR_TP_TRANSACTION = 11;
        const int PTR_TP_NORMAL = 12;
        const int PTR_BCS_JAN13 = 104;
        const int PTR_BC_CENTER = -2;

        const int PTR_MM_DOTS = 1;
        const int PTR_MM_TWIPS = 2;
        const int PTR_MM_ENGLISH = 3;
        const int PTR_MM_METRIC = 4;

        const int PTR_RP_NORMAL = 0X0001;
        const int PTR_RP_RIGHT90 = 0X0101;
        const int PTR_RP_LEFT90 = 0X0102;
        const int PTR_RP_ROTATE180 = 0X0103;
        const int PTR_RP_BITMAP = 0X2000;

        const int PTR_PD_LEFT_TO_RIGHT = 1;
        const int PTR_PD_BOTTOM_TO_TOP = 2;
        const int PTR_PD_RIGHT_TO_LEFT = 3;
        const int PTR_PD_TOP_TO_BOTTOM = 4;

        const int PTR_PM_PAGE_MODE = 1;
        const int PTR_PM_PRINT_SAVE = 2;
        const int PTR_PM_NORMAL = 3;
        const int PTR_PM_CANCEL = 4;


        const int PTR_BC_LEFT = -1;
        const int PTR_BC_RIGHT = -3;

        const int PTR_BC_TEXT_NONE = -11;
        const int PTR_BC_TEXT_BELOW = -13;

        const int PTR_BM_LEFT = -1;
        const int PTR_BM_RIGHT = -3;
        const int PTR_BMT_BMP = 1;

        public Form1()
        {
            InitializeComponent();
        }


        OposPOSPrinter_CCO.OPOSPOSPrinter test = new OposPOSPrinter_CCO.OPOSPOSPrinter();

        private void button1_Click(object sender, EventArgs e)
        {
            byte ESC = 0X1B;
            byte vbLf = 0X0A;
            string logoFileName = @System.IO.Directory.GetCurrentDirectory() + @"\TSC.BMP";

            test.Open(textBox1.Text);
            int nResult = test.ClaimDevice(2500);
            test.DeviceEnabled = true;

            //text test
            nResult = test.PrintNormal(PTR_S_RECEIPT, "Text Test " + (char)vbLf);

            //barcode test
            nResult = test.PrintBarCode(2, "{A12345678", 110, 80, 2, PTR_BC_LEFT, PTR_BC_TEXT_BELOW);

            //bmp test
            if (test.CapRecBitmap)
            {
                nResult = test.SetBitmap(1, PTR_S_RECEIPT, logoFileName, test.RecLineWidth / 2, PTR_BM_LEFT);
                    
                if (nResult != 0)
                {

                    Thread.Sleep(10);
                }
                else
                {
                    nResult = test.PrintNormal(PTR_S_RECEIPT, (char)ESC + "|A'" + (char)ESC + "|1B");

                }

            }

            /*
            //rotate text test
            nResult = test.RotatePrint(PTR_S_RECEIPT, PTR_RP_LEFT90);
            test.PageModeStation = PTR_S_RECEIPT;
            test.PageModeVerticalPosition = 400;
            test.PageModeHorizontalPosition = 0;
            test.PageModePrintArea = "0,0,400,200";
            test.PrintNormal(PTR_S_RECEIPT, (char)ESC + "|N" + "ABCDEF" + (char)vbLf);
            nResult = test.RotatePrint(PTR_S_RECEIPT, PTR_RP_NORMAL);
            Thread.Sleep(10);
            */

            test.DeviceEnabled = false;
            test.ReleaseDevice();
            test.Close();

            return;
           
        }
        
        

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        
    }
}
       
