﻿#include <cstdio>
#include <iostream>
#include <cstring>
#include <vector>
#include <string>
#include <dlfcn.h> // 包含動態加載庫的頭文件
#include <sstream>
#include <thread>
#include <chrono>
#include <mutex>
#include <map>



#define TSC_USB_VID 0x1203
#define PTX_USB_VID 0x14ae

// 定義 Tuple 的結構
struct Tuple_c {
    short vendorId;
    short productId;
};

enum DescriptorPortType {

    // Data
    DATA,
    // Management
    MGMT,
    // Status
    STATUS
};

enum COMM_TYP
{
    USB_COMM = 0,
    TCP_COMM,
    BT_COMM,
    COM_COMM
};

typedef unsigned char byte;

void* handleCommSDKLib;
void* handleJsonSDKLib;

Tuple_c* devices = nullptr;

typedef int (*BytesAvailableFunc)();
typedef bool (*ConnectedFunc)();
typedef void (*ReadFunc)(byte* buffer, int size);
typedef void (*WriteFunc)(byte* dataOut, int iDataSize);
typedef byte* (*WriteAndWaitForResponseFunc)(byte* dataOut, int iDataSize, int responseStartTimeOut, int responseEndTimeOut, char* completetionToken);
typedef void (*CloseFunc)();
typedef void (*OpenFunc)();
typedef int (*GetAvailableDevicesFunc)(Tuple_c**, int*);
typedef void (*UsbConnectFunc)(Tuple_c device);
typedef void (*TcpConnectFunc)(char* ipAddress, int port);
typedef void (*BtConnectFunc)(uint64_t macAddress);
typedef void (*GetCommFunc)(void*& ptrComm); // for json
typedef void (*ComConnectFunc)(std::string ComPort, int BaudRate);


// JsonSDK. dll export
typedef void (*MessengerGetFunc)(void* ptrComm, COMM_TYP commTyp, int maxInputMsgCapacity, bool usingDataPort);
typedef void (*MessengerReleaseFunc)();
typedef void (*MessengerSendMsgFunc)(char* strCommand, char* strContent);
typedef void (*MessengerReadNextMsgFunc)(const char** strNextMsg);
typedef void (*MessengerSendMsgAndWaitForResponseFunc)(char* strCommand, char* strContent, int maxWaitTimeSecs, const char** strResponse);
typedef int (*MessengerUnreadMsgCountFunc)();



// new append
typedef char* (*GetPrinterAllValuesFunc)(void* ptrComm, COMM_TYP commTyp, bool usingDataPort);
typedef char* (*GetPrinterValueFunc)(void* ptrComm, COMM_TYP commTyp, bool usingDataPort, const char* key);
typedef char* (*GetPrinterValuesFunc)(void* ptrComm, COMM_TYP commTyp, bool usingDataPort, const std::vector<std::string>& keys);
typedef bool (*SetPrinterValueFunc)(void* ptrComm, COMM_TYP commTyp, bool usingDataPort, const char* key, const char* value);
typedef bool (*SetPrinterValuesFunc)(void*, COMM_TYP, bool, std::map<std::string, std::string>*);
typedef char* (*GetPrinterPropertiesFunc)(void*, COMM_TYP, bool, const char*);
typedef char* (*GetPrinterPropertiesExFunc)(void*, COMM_TYP, bool, const char* keys[], size_t keyCount);
typedef char* (*GetPrinterAllPropertiesFunc)(void*, COMM_TYP, bool);
typedef void (*FreeStringFunc)(char* str);
typedef char* (*GetPrinterConfigFunc)(void* ptrComm, COMM_TYP commTyp, bool usingDataPort, int CfgNumber);
typedef bool (*SetPrinterConfigFunc)(void* ptrComm, COMM_TYP commTyp, bool usingDataPort, char* pConfig);
typedef char* (*GetPrinterAllConfigFunc)(void* ptrComm, COMM_TYP commTyp, bool usingDataPort);



#define MAX_INPUT_MSG_CAPACITY 20
#define MAX_WAIT_TIME_SECS 5


GetAvailableDevicesFunc pGetAvailableDevices = NULL;
BytesAvailableFunc pBytesAvailable = NULL;
ConnectedFunc pConnected = NULL;
ReadFunc pRead = NULL;
WriteFunc pWrite = NULL;
WriteAndWaitForResponseFunc pWriteAndWaitForResponse = NULL;
CloseFunc pClose = NULL;
OpenFunc pOpen = NULL;
UsbConnectFunc pUsbConnect = NULL;
TcpConnectFunc pTcpConnect = NULL;
BtConnectFunc pBtConnect = NULL;
GetCommFunc pGetComm = NULL;
ComConnectFunc pComConnect = NULL;



MessengerGetFunc pMessengerGet = NULL;
MessengerReleaseFunc pMessengerRelease = NULL;
MessengerSendMsgFunc pMessengerSendMsg = NULL;
MessengerReadNextMsgFunc pMessengerReadNextMsg = NULL;
MessengerSendMsgAndWaitForResponseFunc pMessengerSendMsgAndWaitForResponse = NULL;
MessengerUnreadMsgCountFunc pMessengerUnreadMsgCount = NULL;



// new append
GetPrinterAllValuesFunc pGetPrinterAllValues = NULL;
GetPrinterValueFunc pGetPrinterValue = NULL;
GetPrinterValuesFunc pGetPrinterValues = NULL;
SetPrinterValueFunc pSetPrinterValue = NULL;
SetPrinterValuesFunc pSetPrinterValues = NULL;
GetPrinterPropertiesFunc pGetPrinterProperties = NULL;
GetPrinterPropertiesExFunc pGetPrinterPropertiesEx = NULL;
GetPrinterAllPropertiesFunc pGetPrinterAllProperties = NULL;
FreeStringFunc pFreeString = NULL;
GetPrinterConfigFunc pGetPrinterConfig = NULL;
SetPrinterConfigFunc pSetPrinterConfig = NULL;
GetPrinterAllConfigFunc pGetPrinterAllConfig = NULL;



bool _bAsyncListening = false;
bool _bConnected = false;
std::mutex _mutex;
std::thread listenerThread_;
std::string currentText;


void loadListOfUsbPrinters() {

    int count = 0;

    pGetAvailableDevices(&devices, &count);
    std::cout << "Number of devices: " << count << std::endl;

    if (count > 0) {
        bool fDevFound = false;
        for (int i = 0; i < count; i++) {
            std::cout << "Device " << i << ": VendorID= 0x" << std::hex << devices[i].vendorId
                << " ProductID= 0x" << devices[i].productId << std::endl;

            std::string usbItemDesc;
            if (TSC_USB_VID == devices[i].vendorId) {
                usbItemDesc = "TSC";
                fDevFound = true;
            }
            else if (PTX_USB_VID == devices[i].vendorId) {
                usbItemDesc = "Printronix";
                fDevFound = true;
            }

           
            if (fDevFound) {
                std::ostringstream oss;
                oss << std::hex << devices[i].vendorId;
                std::string vendorIdHex = oss.str();
                oss.str("");  // 清除 oss 的內容以供重用
                oss << std::hex << devices[i].productId;
                std::string productIdHex = oss.str();

                usbItemDesc += ", 0x" + vendorIdHex + ", 0x" + productIdHex;
                std::cout << usbItemDesc << std::endl;
            }
        }
    }



}


void ListenerAsync()
{
    while (_bAsyncListening && pConnected()) {
        std::this_thread::sleep_for(std::chrono::milliseconds(50));

        if (!_bAsyncListening)
            break;

        std::lock_guard<std::mutex> lock(_mutex);

        if (!_bAsyncListening)
            break;

        int iUnreadMsgCount = pMessengerUnreadMsgCount();
        if (iUnreadMsgCount > 0) {

            const char* strNextMsg = NULL;
            pMessengerReadNextMsg(&strNextMsg);

            if (!_bAsyncListening)
                break;

            if (strNextMsg != NULL)
            {
                int length = (int)strlen(strNextMsg);
                std::string str(reinterpret_cast<const char*>(strNextMsg), length);
                currentText += str;
                std::cout << std::endl;
                std::cout << std::endl;
                std::cout << "Response:";
                std::cout << currentText << std::endl;

            }


           
        }
        else {
            std::this_thread::sleep_for(std::chrono::milliseconds(10));
        }
    }

}




void RunAsyncListen()
{

    if (_bAsyncListening) {
        std::cout << "---Deactivate Listener" << std::endl;
        _bAsyncListening = false;
        if (listenerThread_.joinable()) {
            listenerThread_.join();
        }
    }
    else {
        if (!pConnected()) {
            std::cerr << "Connect first. Can't listen without a valid open/active connection." << std::endl;
            return;
        }
        std::cout << "Listening....." << std::endl;
        _bAsyncListening = true;
        listenerThread_ = std::thread(ListenerAsync);
        listenerThread_.detach();  //********************
        std::this_thread::sleep_for(std::chrono::seconds(1));
    }

}



int main()
{
    // 加載 libCommSDK.so 庫
    handleCommSDKLib = dlopen("libCommSDK.so", RTLD_LAZY);
    if (!handleCommSDKLib) {
        std::cerr << "Failed to load libCommSDK.so: " << dlerror() << std::endl;
        return 1;
    }

    handleJsonSDKLib = dlopen("libJsonSDK.so", RTLD_LAZY);
    if (!handleJsonSDKLib) {
        std::cerr << "Failed to load libCommSDK.so: " << dlerror() << std::endl;
        return 1;
    }


    pGetAvailableDevices = reinterpret_cast<GetAvailableDevicesFunc>(dlsym(handleCommSDKLib, "GetAvailableDevices"));
    pBytesAvailable = reinterpret_cast<BytesAvailableFunc>(dlsym(handleCommSDKLib, "BytesAvailable"));
    pConnected = reinterpret_cast<ConnectedFunc>(dlsym(handleCommSDKLib, "Connected"));
    pRead = reinterpret_cast<ReadFunc>(dlsym(handleCommSDKLib, "Read"));
    pWrite = reinterpret_cast<WriteFunc>(dlsym(handleCommSDKLib, "Write"));
    pWriteAndWaitForResponse = reinterpret_cast<WriteAndWaitForResponseFunc>(dlsym(handleCommSDKLib, "WriteAndWaitForResponse"));
    pClose = reinterpret_cast<CloseFunc>(dlsym(handleCommSDKLib, "Close"));
    pOpen = reinterpret_cast<OpenFunc>(dlsym(handleCommSDKLib, "Open"));
    pUsbConnect = reinterpret_cast<UsbConnectFunc>(dlsym(handleCommSDKLib, "UsbConnect"));
    pTcpConnect = reinterpret_cast<TcpConnectFunc>(dlsym(handleCommSDKLib, "TcpConnect"));
    pBtConnect = reinterpret_cast<BtConnectFunc>(dlsym(handleCommSDKLib, "BtConnect"));
    pGetComm = reinterpret_cast<GetCommFunc>(dlsym(handleCommSDKLib, "GetComm"));
    pComConnect = reinterpret_cast<ComConnectFunc>(dlsym(handleCommSDKLib, "ComConnect"));


    if (!pGetAvailableDevices || !pBytesAvailable || !pConnected || !pRead || !pWrite || 
        !pWriteAndWaitForResponse || !pOpen || !pUsbConnect || !pTcpConnect || !pBtConnect || !pGetComm ||
        !pComConnect )
    {
        std::cerr << "Failed to get address of libCommSDK.so API functions: " << dlerror() << std::endl;
        dlclose(handleCommSDKLib);
        return 1;
    }


    pMessengerGet = reinterpret_cast<MessengerGetFunc>(dlsym(handleJsonSDKLib, "MessengerGet"));
    pMessengerRelease = reinterpret_cast<MessengerReleaseFunc>(dlsym(handleJsonSDKLib, "MessengerRelease"));
    pMessengerSendMsg = reinterpret_cast<MessengerSendMsgFunc>(dlsym(handleJsonSDKLib, "MessengerSendMsg"));
    pMessengerReadNextMsg = reinterpret_cast<MessengerReadNextMsgFunc>(dlsym(handleJsonSDKLib, "MessengerReadNextMsg"));
    pMessengerSendMsgAndWaitForResponse = reinterpret_cast<MessengerSendMsgAndWaitForResponseFunc>(dlsym(handleJsonSDKLib, "MessengerSendMsgAndWaitForResponse"));
    pMessengerUnreadMsgCount = reinterpret_cast<MessengerUnreadMsgCountFunc>(dlsym(handleJsonSDKLib, "MessengerUnreadMsgCount"));

  


    pGetPrinterAllValues = reinterpret_cast<GetPrinterAllValuesFunc>(dlsym(handleJsonSDKLib, "GetPrinterAllValues"));
    pGetPrinterValue = reinterpret_cast<GetPrinterValueFunc>(dlsym(handleJsonSDKLib, "GetPrinterValue"));
    pGetPrinterValues = reinterpret_cast<GetPrinterValuesFunc>(dlsym(handleJsonSDKLib, "GetPrinterValues"));
    pFreeString = reinterpret_cast<FreeStringFunc>(dlsym(handleJsonSDKLib, "FreeString"));
    pSetPrinterValue = reinterpret_cast<SetPrinterValueFunc>(dlsym(handleJsonSDKLib, "SetPrinterValue"));
    pSetPrinterValues = reinterpret_cast<SetPrinterValuesFunc>(dlsym(handleJsonSDKLib, "SetPrinterValues"));
    pGetPrinterProperties = reinterpret_cast<GetPrinterPropertiesFunc>(dlsym(handleJsonSDKLib, "GetPrinterProperties"));
    pGetPrinterPropertiesEx = reinterpret_cast<GetPrinterPropertiesExFunc>(dlsym(handleJsonSDKLib, "GetPrinterPropertiesEx"));
    pGetPrinterAllProperties = reinterpret_cast<GetPrinterAllPropertiesFunc>(dlsym(handleJsonSDKLib, "GetPrinterAllProperties"));
    pGetPrinterConfig = reinterpret_cast<GetPrinterConfigFunc>(dlsym(handleJsonSDKLib, "GetPrinterConfig"));
    pSetPrinterConfig = reinterpret_cast<SetPrinterConfigFunc>(dlsym(handleJsonSDKLib, "SetPrinterConfig"));
    pGetPrinterAllConfig = reinterpret_cast<GetPrinterAllConfigFunc>(dlsym(handleJsonSDKLib, "GetPrinterAllConfig"));


    if (!pMessengerGet || !pMessengerRelease || !pMessengerSendMsg || !pMessengerReadNextMsg || !pMessengerSendMsgAndWaitForResponse || !pMessengerUnreadMsgCount || 
        !pGetPrinterAllValues || !pGetPrinterValue || !pGetPrinterValues || !pSetPrinterValues || !pSetPrinterValue ||
        !pGetPrinterProperties || !pGetPrinterPropertiesEx || !pGetPrinterAllProperties || !pFreeString || !pGetPrinterConfig || 
        !pSetPrinterConfig || !pGetPrinterAllConfig)
    {
        std::cerr << "Failed to get address of libJsonSDK.so API functions: " << dlerror() << std::endl;
        dlclose(handleJsonSDKLib);
        return 1;
    }

    
    loadListOfUsbPrinters();

    
    /*
    // USB
    if (devices != nullptr)
        pUsbConnect(devices[0]);
    else
    {
        std::cout << "Failed to call UsbConnect API!" << std::endl;
        dlclose(handleCommSDKLib);
        return 1;
    }
    */
    
    
    

    // NET
    pTcpConnect("10.0.10.187", 3007);


    // BT
    //pBtConnect(0x44B7D02E6EB7);
    //pBtConnect(0x000CBF1618D3);
    //pBtConnect(0x000CBF1215FC);
    // Serial Port
    pComConnect("/dev/ttyUSB1", 9600);


    try {
        pOpen();
    }
    catch (const std::exception& e)
    {
        std::cerr << "Exception caught during Open: " << e.what() << std::endl;
    }



    COMM_TYP commTyp = COMM_TYP::TCP_COMM;
    //COMM_TYP commTyp = COMM_TYP::USB_COMM;
    //COMM_TYP commTyp = COMM_TYP::BT_COMM;
    //COMM_TYP commTyp = COMM_TYP::COM_COMM;
    void* commPtr = NULL;

    if (pConnected())
    {
        pGetComm(commPtr);
        pMessengerGet(commPtr, commTyp, MAX_INPUT_MSG_CAPACITY, false);
        //pMessengerGet(commPtr, commTyp, MAX_INPUT_MSG_CAPACITY, true);

        RunAsyncListen();
        
        if (commPtr != NULL)
        {
            //char* pCmdStr = "Cfg.Item";
            char* pCmdStr = (char*)"Sys.Info";

            std::string content;
            content += "{\r\n";
            content += "\"From\" : \"1000\",\r\n";
            content += "\"TrackNo\" : \"init\"\r\n";
//            content += "\"Speed\" : null,\r\n";
            //content += "\"ODV.Symbol\" : null,\r\n";
//            content += "\"Label.Sensor\":null\r\n";
            content += "}\r\n";
           

            std::cout << std::endl;
            std::cout << "Send to Printer:" << std::endl;
//            std::cout << "\"Command\": \"Cfg.Item\"" << std::endl;
            std::cout << "\"Command\": \"Sys.Info\"" << std::endl;
            std::cout << "\"Content\":" << std::endl;
            std::cout << content;
            const char* pContentStr = content.c_str();
            
            _bAsyncListening = false;
            if (_bAsyncListening)
            {
                try {
                    pMessengerSendMsg(pCmdStr, (char*)pContentStr);
                   
                }
                catch (const std::exception& e)
                {
                    std::cerr << "Exception caught during Write: " << e.what() << std::endl;
                }

            }
            else
            {
                
                const char* strResponse = NULL;
                pMessengerSendMsgAndWaitForResponse(pCmdStr, (char*)pContentStr, MAX_WAIT_TIME_SECS, &strResponse);
                if (strResponse != NULL)
                {
                    int length = (int)strlen(strResponse);
                    std::string str(reinterpret_cast<const char*>(strResponse), length);
                    currentText += str;
                    std::cout << std::endl;
                    std::cout << std::endl;
                    std::cout << "Response:";
                    std::cout << currentText << std::endl;
                    free((void*)strResponse);
                }
                

                
                /*
                //char* values = pGetPrinterAllValues(commPtr, commTyp, false);
                char* values = pGetPrinterAllValues(commPtr, commTyp, true);
                if (values != NULL) {
                    std::cout << values << std::endl;
                    pFreeString(values);
                }
                */
                


                /*
                const std::string& key = "Ethernet.MAC";
                //char* value = pGetPrinterValue(commPtr, commTyp, false, key.c_str());
                char* value = pGetPrinterValue(commPtr, commTyp, true, key.c_str());
                if (value) {
                    std::cout << value << std::endl;
                    pFreeString(value);
                }
                */
                


                /*
                std::vector<std::string> keys = { "Ethernet.IP", "Ethernet.MAC", "Ethernet.Speed" };
                //char* values = pGetPrinterValues(commPtr, commTyp, false, keys);
                char* values = pGetPrinterValues(commPtr, commTyp, true, keys);
                if (values != NULL) {
                    std::cout << values << std::endl;
                    pFreeString(values);
                }
                */


                /*
                const std::string _key = "Ethernet.Speed";
                const std::string _value = "eAutomatic";
                //bool result = pSetPrinterValue(commPtr, commTyp, false, _key.c_str(), _value.c_str());
                bool result = pSetPrinterValue(commPtr, commTyp, true, _key.c_str(), _value.c_str());
                if (result) {
                    std::cout << "Successfully set " << _key << " to " << _value << std::endl;
                }
                else {
                    std::cerr << "Failed to set " << _key << std::endl;
                }
                */



                /*
                std::map<std::string, std::string> keyValues = {
                    {"Ethernet.Speed", "eAutomatic"},
                    {"Image.Width-in", "3.5"}

                };
                //bool _result = pSetPrinterValues(commPtr, commTyp, false, &keyValues);
                bool _result = pSetPrinterValues(commPtr, commTyp, true, &keyValues);
                if (_result) {
                    std::cout << "Successfully set values." << std::endl;
                }
                else {
                    std::cerr << "Failed to set values." << std::endl;
                }
                */


                /*
                std::string key_ = "Speed.Print-mmps";
                //std::string key_ = "BT.PairMethod";
                //char* Properties = pGetPrinterProperties(commPtr, commTyp, false, key_.c_str());
                char* Properties = pGetPrinterProperties(commPtr, commTyp, true, key_.c_str());
                if (Properties != NULL) {
                    std::cout << Properties << std::endl;
                    pFreeString(Properties);
                }
                */





                /*
                const char* keyProps[] = { "Speed", "Label.Sensor" };
                size_t keyCount = sizeof(keyProps) / sizeof(keyProps[0]);
                //char* PropertiesEx = pGetPrinterPropertiesEx(commPtr, commTyp, false, keyProps, keyCount);
                char* PropertiesEx = pGetPrinterPropertiesEx(commPtr, commTyp, true, keyProps, keyCount);
                if (PropertiesEx != NULL) {
                    std::cout << PropertiesEx << std::endl;
                    pFreeString(PropertiesEx);
                }
                */




                /*
                //char* AllProperties = pGetPrinterAllProperties(commPtr, commTyp, false);
                char* AllProperties = pGetPrinterAllProperties(commPtr, commTyp, true);
                if (AllProperties != NULL) {
                    std::cout << AllProperties << std::endl;
                    pFreeString(AllProperties);
                }
                */





                /*
                //char* pConfig = pGetPrinterConfig(commPtr, commTyp, false, 1);
                char* pConfig = pGetPrinterConfig(commPtr, commTyp, true, 1);
                if (pConfig != NULL) {
                    std::cout << pConfig << std::endl;
                }
                //bool result = pSetPrinterConfig(commPtr, commTyp, false, pConfig);
                bool result = pSetPrinterConfig(commPtr, commTyp, true, pConfig);
                if (result) {
                    std::cout << "Successfully set " << std::endl;
                }
                else {
                    std::cerr << "Failed to set " << std::endl;
                }
                if (pConfig != NULL)
                    pFreeString(pConfig);
                */
                
                
                
                std::cout << std::endl;
                std::cout << "Wait for a while...." << std::endl;
                
                //char* pAllConfig = pGetPrinterAllConfig(commPtr, commTyp, false);
                char* pAllConfig = pGetPrinterAllConfig(commPtr, commTyp, true);
                if (pAllConfig != NULL) {

                    std::cout << pAllConfig << std::endl;
                    pFreeString(pAllConfig);

                }
                






            }




        }



    }
    else
    {
        std::cerr << "Failed to Connect Printer " << dlerror() << std::endl;
        dlclose(handleCommSDKLib);
        dlclose(handleJsonSDKLib);
        return 1;
    }

    //if (devices != nullptr)
    //    delete[] devices;

    int userInput;

    // 循環等待用戶輸入，直到用戶輸入0為止
    do {

        std::cout << std::endl;
        std::cout << std::endl;
        std::cout << "Press 0 to exit";
        std::cout << std::endl;
        std::cin >> userInput;
    } while (userInput != 0);

    // 使用者輸入0後程式結束
    std::cout << std::endl;
    std::cout << "Program exit" << std::endl;
    std::cout << std::endl;

    _bAsyncListening = false;


   

    pMessengerRelease();
    pClose();
    // 釋放 libCommSDK.so / libJsonSDK.so 庫
    dlclose(handleCommSDKLib);
    dlclose(handleJsonSDKLib);

    if (listenerThread_.joinable()) {
        listenerThread_.join();
    }


    return 0;

}


