﻿#include <cstdio>
#include <iostream>
#include <vector>
#include <string>
#include <dlfcn.h> // 包含動態加載庫的頭文件


enum class Brand {
    ALL,
    TSC,
    PTX
};

typedef std::vector<std::string>* (*GetPrinterListFunc)(Brand brand, int responseTimeoutMs);
typedef void (*FreePrinterListFunc)(std::vector<std::string>* pList);
typedef std::vector<std::string>* (*GetPrinterList_IPv6Func)(std::string PREFIX, std::string INTERFACE_NAME, int responseTimeoutMs);
typedef void (*FreePrinterList_IPv6Func)(std::vector<std::string>* pList);


GetPrinterListFunc pGetPrinterList = NULL;
FreePrinterListFunc pFreePrinterList = NULL;
GetPrinterList_IPv6Func pGetPrinterList_IPv6 = NULL;
FreePrinterList_IPv6Func pFreePrinterList_IPv6 = NULL;

void* handleLib;

int main()
{
    handleLib = dlopen("libDiscovery.so", RTLD_LAZY);
    if (!handleLib) {
        std::cerr << "Failed to load libDiscovery.so: " << dlerror() << std::endl;
        return 1;
    }

    pGetPrinterList = reinterpret_cast<GetPrinterListFunc>(dlsym(handleLib, "GetPrinterList"));
    pFreePrinterList = reinterpret_cast<FreePrinterListFunc>(dlsym(handleLib, "FreePrinterList"));
    pGetPrinterList_IPv6 = reinterpret_cast<GetPrinterList_IPv6Func>(dlsym(handleLib, "GetPrinterList_IPv6"));
    pFreePrinterList_IPv6 = reinterpret_cast<FreePrinterList_IPv6Func>(dlsym(handleLib, "FreePrinterList_IPv6"));

    if (!pGetPrinterList || !pFreePrinterList ||
        !pGetPrinterList_IPv6 || !pFreePrinterList_IPv6)
    {
        std::cerr << "Failed to get address of libDiscovery.so API functions: " << dlerror() << std::endl;
        dlclose(handleLib);
        return 1;
    }


    std::cout << "Searching for printers..." << std::endl;


    std::vector<std::string>* pPrinterList = pGetPrinterList(Brand::ALL, 3000);
    //std::vector<std::string>* pPrinterList = pGetPrinterList(Brand::TSC, 3000);
    //std::vector<std::string>* pPrinterList = pGetPrinterList(Brand::PTX, 3000);

    if (pPrinterList == nullptr || pPrinterList->empty())
    {
        std::cout << "No Printers found." << std::endl;
    }
    else
    {
        std::cout << "Printers found at:" << std::endl;
        for (const auto& ip : *pPrinterList)
        {
            std::cout << ip << std::endl;
        }
    }


    if (pPrinterList)
    {
        pFreePrinterList(pPrinterList);
    }


    dlclose(handleLib);


    return 0;
}