﻿// TestCommSDK.cpp : 此檔案包含 'main' 函式。程式會於該處開始執行及結束執行。
//

#include <iostream>
#include <sstream>
#include <string>
#include <cstring>
#include <iomanip>
#include <fstream>
#include <vector>
#include <thread>
#include <mutex>
#include <atomic>
#include <chrono>
#include <condition_variable>
#include <cstdint>
#include <Windows.h>
#include <tchar.h>


#define TSC_USB_VID 0x1203
#define PTX_USB_VID 0x14ae

// 定義 Tuple 的結構
struct Tuple_c {
    short vendorId;
    short productId;
};

enum DescriptorPortType {

    // Data
    DATA,
    // Management
    MGMT,
    // Status
    STATUS
};


enum class Brand {
    TSC = 1,
    PTX
};


typedef unsigned char byte;


Tuple_c* devices = nullptr;


typedef int(__stdcall* PBYTESAVAILABLE)();
typedef bool(__stdcall* PCONNECTED)();
typedef void(__stdcall* PREAD)(byte* buffer, int size);
typedef void(__stdcall* PWRITE)(byte* dataOut, int iDataSize);
typedef void(__stdcall* PCLOSE)();
typedef void(__stdcall* POPEN)();
typedef int(__stdcall* PGETAVAILABLEDEVICES)(Tuple_c** devices, int* count);
typedef void(__stdcall* PUSBCONNECT)(Tuple_c device);
typedef void(__stdcall* PTCPCONNECT)(char* ipAddress, int port);
typedef void(__stdcall* PBTCONNECT)(unsigned __int64 macAddress);
typedef byte* (__stdcall* PWRITEANDWAITFORRESPONSE)(byte* dataOut, int iDataSize, int responseStartTimeOut, int responseEndTimeOut, char* completetionToken);
typedef void(__stdcall* PCOMCONNECT)(std::string ComPort, int BaudRate);



PBYTESAVAILABLE pBytesAvailable = NULL;
PCONNECTED pConnected = NULL;
PREAD pRead = NULL;
PWRITE pWrite = NULL;
PCLOSE pClose = NULL;
POPEN pOpen = NULL;
PGETAVAILABLEDEVICES pGetAvailableDevices = NULL;
PUSBCONNECT pUsbConnect = NULL;
PTCPCONNECT pTcpConnect = NULL;
PBTCONNECT pBtConnect = NULL;
PWRITEANDWAITFORRESPONSE pWriteAndWaitForResponse = NULL;
PCOMCONNECT pComConnect = NULL;



HINSTANCE m_SdkDLL = NULL;

bool _bAsyncListening = false;
bool _bConnected = false;
std::mutex _mutex;
std::thread listenerThread_;
std::string currentText;

void loadListOfUsbPrinters() {

    int count = 0;

    pGetAvailableDevices(&devices, &count);
    std::cout << "Number of devices: " << count << std::endl;

    if (count > 0) {
        bool fDevFound = false;
        for (int i = 0; i < count; i++) {
            std::cout << "Device " << i << ": VendorID= 0x" << std::hex << devices[i].vendorId
                << " ProductID= 0x" << devices[i].productId << std::endl;

            std::string usbItemDesc;
            if (TSC_USB_VID == devices[i].vendorId) {
                usbItemDesc = "TSC";
                fDevFound = true;
            }
            else if (PTX_USB_VID == devices[i].vendorId) {
                usbItemDesc = "Printronix";
                fDevFound = true;
            }

            
            if (fDevFound) {
                std::ostringstream oss;
                oss << std::hex << devices[i].vendorId;
                std::string vendorIdHex = oss.str();
                oss.str("");  // 清除 oss 的內容以供重用
                oss << std::hex << devices[i].productId;
                std::string productIdHex = oss.str();

                usbItemDesc += ", 0x" + vendorIdHex + ", 0x" + productIdHex;
                std::cout << usbItemDesc << std::endl;
            }
        }
    }



}



void ListenerAsync()
{

    while (_bAsyncListening && pConnected()) {
        std::this_thread::sleep_for(std::chrono::milliseconds(500));

        if (!_bAsyncListening)
            break;

        std::lock_guard<std::mutex> lock(_mutex);


        int iBytes = pBytesAvailable();
        byte* pBuf = nullptr;

        if (!_bAsyncListening)
            break;

        if (iBytes > 0) {

            pBuf = new byte[iBytes];
            pRead(pBuf, iBytes);

            if (!_bAsyncListening)
            {
                delete[] pBuf;
                pBuf = nullptr;
                break;
            }

            std::string str(reinterpret_cast<char*>(pBuf), iBytes);
            currentText += str;
            std::cout << std::endl;
            std::cout << std::endl;
            std::cout << "Response:";
            std::cout << currentText << std::endl;

            delete[] pBuf;
            pBuf = nullptr;
            
        }
        else {
            std::this_thread::sleep_for(std::chrono::milliseconds(10));
        }
    }

}




void RunAsyncListen()
{
    if (_bAsyncListening) {
        std::cout << "---Deactivate Listener" << std::endl;
        _bAsyncListening = false;
        if (listenerThread_.joinable()) {
            listenerThread_.join();
        }
    }
    else {
        if (!pConnected()) {
            std::cerr << "Connect first. Can't listen without a valid open/active connection." << std::endl;
            return;
        }
        std::cout << "Listening....." << std::endl;
        _bAsyncListening = true;
        listenerThread_ = std::thread(ListenerAsync);
        std::this_thread::sleep_for(std::chrono::seconds(1));
    }

}

int main()
{
	m_SdkDLL = LoadLibrary(_T("CommSDK.dll"));

	if (m_SdkDLL == NULL)
	{
		std::cout << "Load CommSDK.dll failed!" << std::endl;
		return 1;
	}

    pBytesAvailable = (PBYTESAVAILABLE)GetProcAddress(m_SdkDLL, "BytesAvailable");
	pConnected = (PCONNECTED)GetProcAddress(m_SdkDLL, "Connected");
	pRead = (PREAD)GetProcAddress(m_SdkDLL, "Read");
	pWrite = (PWRITE)GetProcAddress(m_SdkDLL, "Write");
	pClose = (PCLOSE)GetProcAddress(m_SdkDLL, "Close");
	pOpen = (POPEN)GetProcAddress(m_SdkDLL, "Open");
	pGetAvailableDevices = (PGETAVAILABLEDEVICES)GetProcAddress(m_SdkDLL, "GetAvailableDevices");
	pUsbConnect = (PUSBCONNECT)GetProcAddress(m_SdkDLL, "UsbConnect");
	pTcpConnect = (PTCPCONNECT)GetProcAddress(m_SdkDLL, "TcpConnect");
	pBtConnect = (PBTCONNECT)GetProcAddress(m_SdkDLL, "BtConnect");
	pWriteAndWaitForResponse = (PWRITEANDWAITFORRESPONSE)GetProcAddress(m_SdkDLL, "WriteAndWaitForResponse");
    pComConnect = (PCOMCONNECT)GetProcAddress(m_SdkDLL, "ComConnect");
  

	if (pBytesAvailable == NULL || pConnected == NULL || pRead == NULL || pOpen == NULL ||
		pClose == NULL || pWrite == NULL ||  pGetAvailableDevices == NULL || pUsbConnect == NULL ||  
        pTcpConnect == NULL || pBtConnect == NULL || pComConnect == NULL || pWriteAndWaitForResponse == NULL)
	{
		std::cout << "Load the CommSDK.dll APIs failed!" << std::endl;
        if (m_SdkDLL != NULL)
            FreeLibrary(m_SdkDLL);
		return 1;
	}

    loadListOfUsbPrinters();

    
    // USB 
    if (devices != nullptr)
        pUsbConnect(devices[0]);
    else
    {
        std::cout  << "Failed to call UsbConnect API!" << std::endl;
        if (m_SdkDLL != NULL)
            FreeLibrary(m_SdkDLL);
        return 1;
    }
    
    
    

    // NET
    //pTcpConnect((char*)"192.168.50.191", 9100); // IPv4 Address
    //pTcpConnect((char*)"fe80::208:96ff:fe40:9b04%35", 9100); // Link Local IPv6 Address
    //pTcpConnect((char*)"2001:b030:2219:c40:208:96ff:fe40:9b04", 9100); // Global Unicast IPv6 Address
    
    // BT
    //pBtConnect(0x3481F4433DA8);
    //pBtConnect(0x000CBF1618D3);

    // COM
    //pComConnect("COM5", 9600);

    pOpen();
    

    if (pConnected())
    {
        std::string content;

        // Print Job

        
        //TSPL
        content += "SIZE 3,2\r\n";
        content += "GAP 0 mm, 0 mm\r\n";
        content += "DIRECTION 1\r\n";
        content += "CLS\r\n";
        content += "TEXT 10, 30, \"3\", 0, 1, 1, \"123456\"\r\n";
        content += "BARCODE 10, 100, \"EAN13\", 80, 1, 0, 2, 4, \"123456789012\"\r\n";
        content += "TEXT 10, 70, \"4\", 0, 1, 1, \"TEST PRINTOUT\"\r\n";
        content += "PRINT 1, 1\r\n";
        
       



        
        /*
        // PGL
        content += "!PTX_SETUP\r\n";
        content += "PRINTJOB-START;1234\r\n";
        content += "PTX_END\r\n";

        content += "~NORMAL\r\n";

        content += "~CREATE;C39;72\r\n";
        content += "SCALE;DOT\r\n";
        content += "PAGE;30;40\r\n";
        content += "ALPHA\r\n";
        content += "C10;1;37;0;0;@HELLO@\r\n";
        content += "C16;54;37;0;0;@*World*@\r\n";
        content += "STOP\r\n";
        content += "BARCODE\r\n";
        content += "C128C;XRD3:3:6:6:9:9:12:12;H6;10;64\r\n";
        content += "@World@\r\n";
        content += "STOP\r\n";
        content += "END\r\n";
        content += "~EXECUTE;C39\r\n";
        content += "~NORMAL\r\n";

        content += "!PTX_SETUP\r\n";
        content += "PRINTJOB-END;1234\r\n";
        content += "PTX_END\r\n";
        // Print Job
        */

        

        /*
        //***AsyncListen
        RunAsyncListen(); 
        content += "A$=\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\"\r\n";
        content += "OUT A$\r\n";
        //***AsyncListen
        */
        


       
        
        
        
        std::cout << std::endl;
        std::cout << "Send to Printer:" << std::endl;
        std::cout << content;
        const char* pStr = content.c_str();
        pWrite((byte*)pStr, (int)strlen(pStr));
       
      


        /*
        // WriteAndWaitForResponse
        content += "FEED 100\r\n";
        content += "OUT \"12345678\"\r\n";
        std::cout << std::endl;
        std::cout << "Send to Printer:" << std::endl;
        std::cout << content;
        const char* pStr = content.c_str();
        byte* pResponse = pWriteAndWaitForResponse((byte*)pStr, content.size(), 1000, 500, (char*)"\r\n");
        std::string str(reinterpret_cast<char*>(pResponse), strlen(reinterpret_cast<char*>(pResponse)));
        std::cout << std::endl;
        std::cout << std::endl;
        std::cout << "Response:";
        std::cout << str << std::endl;
        // WriteAndWaitForResponse
        */


    }
    else
    {
        std::cout << "Failed to Connect Printer!" << std::endl;
        if (m_SdkDLL != NULL)
            FreeLibrary(m_SdkDLL);
        return 1;
    }

    
    int userInput;

    // 循環等待用戶輸入，直到用戶輸入0為止
    do {

        std::cout << std::endl;
        std::cout << std::endl;
        std::cout << "Press 0 to exit";
        std::cout << std::endl;
        std::cin >> userInput;
    } while (userInput != 0);

    // 使用者輸入0後程式結束
    std::cout << std::endl;
    std::cout << "Program exit" << std::endl;
    std::cout << std::endl;

    _bAsyncListening = false;

    pClose();

    if (listenerThread_.joinable()) {
        listenerThread_.join();
    }

          
    if (m_SdkDLL != NULL)
        FreeLibrary(m_SdkDLL);

    
	return 0;



}

