﻿// TestMgmtCommSDK.cpp : 此檔案包含 'main' 函式。程式會於該處開始執行及結束執行。
//
#define _CRTDBG_MAP_ALLOC
#include <cstdlib>
#include <crtdbg.h>

#include <iostream>
#include <sstream>
#include <string>
#include <cstring>
#include <iomanip>
#include <fstream>
#include <vector>
#include <thread>
#include <mutex>
#include <atomic>
#include <chrono>
#include <condition_variable>
#include <Windows.h>
#include <afx.h>
#include <map>

//#define _CRTDBG_MAP_ALLOC
//#include <cstdlib>
//#include <crtdbg.h>


#define TSC_USB_VID 0x1203
#define PTX_USB_VID 0x14ae

// 定義 Tuple 的結構
struct Tuple_c {
    short vendorId;
    short productId;
};

enum DescriptorPortType {

    // Data
    DATA,
    // Management
    MGMT,
    // Status
    STATUS
};

enum COMM_TYP
{
    USB_COMM = 0,
    TCP_COMM,
    BT_COMM,
    COM_COMM
};

#define MAX_INPUT_MSG_CAPACITY 20
#define MAX_WAIT_TIME_SECS 5

#define MAX_BUFSIZE 65536


typedef unsigned char byte;

Tuple_c* devices = nullptr;

// CommSDK.dll export
typedef int(__stdcall* PBYTESAVAILABLE)();
typedef bool(__stdcall* PCONNECTED)();
typedef void(__stdcall* PREAD)(byte* buffer, int size);
typedef void(__stdcall* PWRITE)(byte* dataOut, int iDataSize);
typedef void(__stdcall* PCLOSE)();
typedef void(__stdcall* POPEN)();
typedef int(__stdcall* PGETAVAILABLEDEVICES)(Tuple_c** devices, int* count);
typedef void(__stdcall* PUSBCONNECT)(Tuple_c device);
typedef void(__stdcall* PTCPCONNECT)(char* ipAddress, int port);
typedef void(__stdcall* PBTCONNECT)(uint64_t macAddress);
typedef void(__stdcall* PGETCOMM)(CObject*& ptrComm);
typedef void(__stdcall* PCOMCONNECT)(std::string ComPort, int BaudRate);

// JsonSDK.dll export
typedef void(__stdcall* PMESSENGERGET)(CObject* ptrComm, COMM_TYP commTyp, int maxInputMsgCapacity, bool usingDataPort);
typedef void(__stdcall* PMESSENGERRELEASE)();
typedef void(__stdcall* PMESSENGERSENDMSG)(char* strCommand, char* strContent);
typedef void(__stdcall* PMESSENGERREADNEXTMSG)(const char** strNextMsg);
typedef void(__stdcall* PMESSENGERSENDMSGANDWAITFORRESPONSE)(char* strCommand, char* strContent, int maxWaitTimeSecs, const char** strResponse);
typedef int(__stdcall* PMESSENGERUNREADMSGCOUNT)();



// new append
typedef char* (__stdcall* PGETPRINTERALLVALUES)(CObject* ptrComm, COMM_TYP commTyp, bool usingDataPort);
typedef char* (__stdcall* PGETPRINTERVALUE)(CObject* ptrComm, COMM_TYP commTyp, bool usingDataPort, const char* key);
typedef char* (__stdcall* PGETPRINTERVALUES)(CObject* ptrComm, COMM_TYP commTyp, bool usingDataPort, const std::vector<std::string>& keys);
typedef bool(__stdcall* PSETPRINTERVALUE)(CObject* ptrComm, COMM_TYP commTyp, bool usingDataPort, const char* key, const char* value);
typedef bool(__stdcall* PSETPRINTERVALUES)(CObject*, COMM_TYP, bool, std::map<std::string, std::string>*);
typedef char* (__stdcall* PGETPRINTERPROPERTIES)(CObject*, COMM_TYP, bool, const char*);
typedef char* (__stdcall* PGETPRINTERPROPERTIESEX)(CObject*, COMM_TYP, bool, const char* keys[], size_t keyCount);
typedef char* (__stdcall* PGETPRINTERALLPROPERTIES)(CObject*, COMM_TYP, bool);
typedef void(__stdcall* PFREESTRING)(char* str);
typedef char* (__stdcall* PGETPRINTERCONFIG)(CObject* ptrComm, COMM_TYP commTyp, bool usingDataPort, int CfgNumber);
typedef bool (__stdcall* PSETPRINTERCONFIG)(CObject* ptrComm, COMM_TYP commTyp, bool usingDataPort, char* pConfig);
typedef char* (__stdcall* PGETPRINTERALLCONFIG)(CObject* ptrComm, COMM_TYP commTyp, bool usingDataPort);


bool _bAsyncListening = false;
bool _bConnected = false;
std::mutex _mutex;
std::thread listenerThread_;
std::string currentText;


HINSTANCE m_CommSdkDLL = NULL;
HINSTANCE m_JsonSdkDLL = NULL;

PBYTESAVAILABLE pBytesAvailable = NULL;
PCONNECTED pConnected = NULL;
PREAD pRead = NULL;
PWRITE pWrite = NULL;
PCLOSE pClose = NULL;
POPEN pOpen = NULL;
PGETAVAILABLEDEVICES pGetAvailableDevices = NULL;
PUSBCONNECT pUsbConnect = NULL;
PTCPCONNECT pTcpConnect = NULL;
PBTCONNECT pBtConnect = NULL;
PGETCOMM pGetComm = NULL;
PCOMCONNECT pComConnect = NULL;



PMESSENGERGET pMessengerGet = NULL;
PMESSENGERRELEASE pMessengerRelease = NULL;
PMESSENGERSENDMSG pMessengerSendMsg = NULL;
PMESSENGERREADNEXTMSG pMessengerReadNextMsg = NULL;
PMESSENGERSENDMSGANDWAITFORRESPONSE pMessengerSendMsgAndWaitForResponse = NULL;
PMESSENGERUNREADMSGCOUNT pMessengerUnreadMsgCount = NULL;


// new append
PGETPRINTERALLVALUES pGetPrinterAllValues = NULL;
PGETPRINTERVALUE pGetPrinterValue = NULL;
PGETPRINTERVALUES pGetPrinterValues = NULL;
PSETPRINTERVALUE pSetPrinterValue = NULL;
PSETPRINTERVALUES pSetPrinterValues = NULL;
PGETPRINTERPROPERTIES pGetPrinterProperties = NULL;
PGETPRINTERPROPERTIESEX pGetPrinterPropertiesEx = NULL;
PGETPRINTERALLPROPERTIES pGetPrinterAllProperties = NULL;
PFREESTRING pFreeString = NULL;
PGETPRINTERCONFIG pGetPrinterConfig = NULL;
PSETPRINTERCONFIG pSetPrinterConfig = NULL;
PGETPRINTERALLCONFIG pGetPrinterAllConfig = NULL;


void loadListOfUsbPrinters() {

    int count = 0;

    pGetAvailableDevices(&devices, &count);
    std::cout << "Number of devices: " << count << std::endl;

    if (count > 0) {
        bool fDevFound = false;
        for (int i = 0; i < count; i++) {
            std::cout << "Device " << i << ": VendorID= 0x" << std::hex << devices[i].vendorId
                << " ProductID= 0x" << devices[i].productId << std::endl;

            std::string usbItemDesc;
            if (TSC_USB_VID == devices[i].vendorId) {
                usbItemDesc = "TSC";
                fDevFound = true;
            }
            else if (PTX_USB_VID == devices[i].vendorId) {
                usbItemDesc = "Printronix";
                fDevFound = true;
            }

           
            if (fDevFound) {
                std::ostringstream oss;
                oss << std::hex << devices[i].vendorId;
                std::string vendorIdHex = oss.str();
                oss.str("");  
                oss << std::hex << devices[i].productId;
                std::string productIdHex = oss.str();

                usbItemDesc += ", 0x" + vendorIdHex + ", 0x" + productIdHex;
                std::cout << usbItemDesc << std::endl;
            }
        }

        //CoTaskMemFree(devices);
    }



}


void ListenerAsync()
{
   
    while (_bAsyncListening && pConnected()) {
        std::this_thread::sleep_for(std::chrono::milliseconds(50));

        if (!_bAsyncListening)
            break;

        std::lock_guard<std::mutex> lock(_mutex);


        if (!_bAsyncListening)
            break;

        int iUnreadMsgCount = pMessengerUnreadMsgCount();
        if (iUnreadMsgCount > 0) {

            //const char* strNextMsg = NULL;
            const char* strNextMsg = new char[MAX_BUFSIZE];
            pMessengerReadNextMsg(&strNextMsg);

            if (!_bAsyncListening)
                break;

            if (strNextMsg != NULL)
            {
               
                std::string str(strNextMsg);
                currentText += str;
                std::cout << std::endl;
                std::cout << std::endl;
                std::cout << "Response:";
                std::cout << currentText << std::endl;
               

            }

            delete[] strNextMsg;

        }
        else {
            std::this_thread::sleep_for(std::chrono::milliseconds(10));
        }
    }

   


}




void RunAsyncListen()
{
    

    if (_bAsyncListening) {
        std::cout << "---Deactivate Listener" << std::endl;
        _bAsyncListening = false;
        if (listenerThread_.joinable()) {
            listenerThread_.join();
        }
    }
    else {

       
        if (!pConnected()) {
            std::cerr << "Connect first. Can't listen without a valid open/active connection." << std::endl;
            return;
        }
        std::cout << "Listening....." << std::endl;
        _bAsyncListening = true;


        listenerThread_ = std::thread(ListenerAsync);
        std::this_thread::sleep_for(std::chrono::seconds(1));
    }

}



int main()
{
    _CrtSetReportMode(_CRT_WARN, _CRTDBG_MODE_FILE);
    _CrtSetReportFile(_CRT_WARN, NULL);
    

    m_CommSdkDLL = LoadLibrary(_T("CommSDK.dll"));
    m_JsonSdkDLL = LoadLibrary(_T("JsonSDK.dll"));

    if (m_CommSdkDLL == NULL)
    {
        std::cout << "Load CommSDK.dll failed!" << std::endl;
        return 1;
    }

    if (m_JsonSdkDLL == NULL)
    {
        std::cout << "Load JsonSDK.dll failed!" << std::endl;
        return 1;
    }


    pBytesAvailable = (PBYTESAVAILABLE)GetProcAddress(m_CommSdkDLL, "BytesAvailable");
    pConnected = (PCONNECTED)GetProcAddress(m_CommSdkDLL, "Connected");
    pRead = (PREAD)GetProcAddress(m_CommSdkDLL, "Read");
    pWrite = (PWRITE)GetProcAddress(m_CommSdkDLL, "Write");
    pClose = (PCLOSE)GetProcAddress(m_CommSdkDLL, "Close");
    pOpen = (POPEN)GetProcAddress(m_CommSdkDLL, "Open");
    pGetAvailableDevices = (PGETAVAILABLEDEVICES)GetProcAddress(m_CommSdkDLL, "GetAvailableDevices");
    pUsbConnect = (PUSBCONNECT)GetProcAddress(m_CommSdkDLL, "UsbConnect");
    pTcpConnect = (PTCPCONNECT)GetProcAddress(m_CommSdkDLL, "TcpConnect");
    pBtConnect = (PBTCONNECT)GetProcAddress(m_CommSdkDLL, "BtConnect");
    pGetComm = (PGETCOMM)GetProcAddress(m_CommSdkDLL, "GetComm");
    pComConnect = (PCOMCONNECT)GetProcAddress(m_CommSdkDLL, "ComConnect");


    if (pBytesAvailable == NULL || pConnected == NULL || pRead == NULL || pOpen == NULL ||
        pClose == NULL || pWrite == NULL || pGetAvailableDevices == NULL || pUsbConnect == NULL ||  
        pTcpConnect == NULL || pBtConnect == NULL || pGetComm == NULL || pComConnect == NULL)
    {
        std::cout << "Load the CommSDK.dll APIs failed!" << std::endl;
        if (m_CommSdkDLL != NULL)
            FreeLibrary(m_CommSdkDLL);
        return 1;
    }

    //JsonSDK DLL

    pMessengerGet = (PMESSENGERGET)GetProcAddress(m_JsonSdkDLL, "MessengerGet");
    pMessengerRelease = (PMESSENGERRELEASE)GetProcAddress(m_JsonSdkDLL, "MessengerRelease");
    pMessengerSendMsg = (PMESSENGERSENDMSG)GetProcAddress(m_JsonSdkDLL, "MessengerSendMsg");
    pMessengerReadNextMsg = (PMESSENGERREADNEXTMSG)GetProcAddress(m_JsonSdkDLL, "MessengerReadNextMsg");
    pMessengerSendMsgAndWaitForResponse = (PMESSENGERSENDMSGANDWAITFORRESPONSE)GetProcAddress(m_JsonSdkDLL, "MessengerSendMsgAndWaitForResponse");
    pMessengerUnreadMsgCount = (PMESSENGERUNREADMSGCOUNT)GetProcAddress(m_JsonSdkDLL, "MessengerUnreadMsgCount");


    // new append
    pGetPrinterAllValues = (PGETPRINTERALLVALUES)GetProcAddress(m_JsonSdkDLL, "GetPrinterAllValues");
    pGetPrinterValue = (PGETPRINTERVALUE)GetProcAddress(m_JsonSdkDLL, "GetPrinterValue");
    pGetPrinterValues = (PGETPRINTERVALUES)GetProcAddress(m_JsonSdkDLL, "GetPrinterValues");
    pFreeString = (PFREESTRING)GetProcAddress(m_JsonSdkDLL, "FreeString");
    pSetPrinterValue = (PSETPRINTERVALUE)GetProcAddress(m_JsonSdkDLL, "SetPrinterValue");
    pSetPrinterValues = (PSETPRINTERVALUES)GetProcAddress(m_JsonSdkDLL, "SetPrinterValues");
    pGetPrinterProperties = (PGETPRINTERPROPERTIES)GetProcAddress(m_JsonSdkDLL, "GetPrinterProperties");
    pGetPrinterPropertiesEx = (PGETPRINTERPROPERTIESEX)GetProcAddress(m_JsonSdkDLL, "GetPrinterPropertiesEx");
    pGetPrinterAllProperties = (PGETPRINTERALLPROPERTIES)GetProcAddress(m_JsonSdkDLL, "GetPrinterAllProperties");
    pGetPrinterConfig = (PGETPRINTERCONFIG)GetProcAddress(m_JsonSdkDLL,"GetPrinterConfig");
    pSetPrinterConfig = (PSETPRINTERCONFIG)GetProcAddress(m_JsonSdkDLL, "SetPrinterConfig");
    pGetPrinterAllConfig = (PGETPRINTERALLCONFIG)GetProcAddress(m_JsonSdkDLL, "GetPrinterAllConfig");
   

    if (pMessengerGet == NULL || pMessengerRelease == NULL || pMessengerSendMsg == NULL || pMessengerReadNextMsg == NULL ||
        pMessengerSendMsgAndWaitForResponse == NULL || pMessengerUnreadMsgCount == NULL || pGetPrinterAllValues == NULL || 
        pGetPrinterValue == NULL || pGetPrinterValues == NULL || pSetPrinterValues == NULL || pSetPrinterValue == NULL ||
        pGetPrinterProperties == NULL || pGetPrinterPropertiesEx == NULL || pGetPrinterAllProperties == NULL || 
        pFreeString == NULL || pGetPrinterConfig == NULL || pSetPrinterConfig == NULL || pGetPrinterAllConfig == NULL )
    {
        std::cout << "Load the JsonSDK.dll APIs failed!" << std::endl;
        if (m_JsonSdkDLL != NULL)
            FreeLibrary(m_JsonSdkDLL);
        return 1;
    }

    
    
    loadListOfUsbPrinters();

  
    /*
    // USB
    if (devices != nullptr)
        pUsbConnect(devices[0]);
    else
    {
        std::cout << "Failed to call UsbConnect API!" << std::endl;
        if (m_CommSdkDLL != NULL)
            FreeLibrary(m_CommSdkDLL);
        return 1;
    }
    */
    

      
   
    // NET
    pTcpConnect((char*)"10.0.10.187", 3007);


    // BT
    //pBtConnect(0x44B7D02E6EB7);
    //pBtConnect(0x000CBF1618D3);
    //pBtConnect(0x000CBF1215FC);


    // COM
    //pComConnect("COM5", 9600);



    pOpen();

    COMM_TYP commTyp = COMM_TYP::TCP_COMM;
    //COMM_TYP commTyp = COMM_TYP::USB_COMM;
    //COMM_TYP commTyp = COMM_TYP::BT_COMM;
    //COMM_TYP commTyp = COMM_TYP::COM_COMM;
    CObject* commPtr = NULL;

    if (pConnected())
    {
        pGetComm(commPtr);
        pMessengerGet(commPtr, commTyp, MAX_INPUT_MSG_CAPACITY, false);
        //pMessengerGet(commPtr, commTyp, MAX_INPUT_MSG_CAPACITY, true);

        
                
        
        RunAsyncListen();

        if (commPtr != NULL)
        {

            
//            char* pCmdStr = (char*)"Cfg.Item";
            char* pCmdStr = (char*)"Sys.Info";
          
            std::string content;
            content += "{\r\n";
            content += "\"From\" : \"1000\",\r\n";
            content += "\"TrackNo\" : \"init\"\r\n";
 //           content += "\"Speed\" : null,\r\n";
            //content += "\"ODV.Symbol\" : null,\r\n";
 //           content += "\"Label.Sensor\":null\r\n";
            content += "}\r\n";


            std::cout << std::endl;
            std::cout << "Send to Printer:" << std::endl;
//            std::cout << "\"Command\": \"Cfg.Item\"" << std::endl;
            std::cout << "\"Command\": \"Sys.Info\"" << std::endl;
            std::cout << "\"Content\":" << std::endl;
            std::cout << content;
            const char* pContentStr = content.c_str();

            
            _bAsyncListening = false;
            if (_bAsyncListening)
            {
                pMessengerSendMsg(pCmdStr, (char*)pContentStr);
            }
            else
            {

                //const char* strResponse = NULL;
                const char* strResponse = new char[MAX_BUFSIZE];
                pMessengerSendMsgAndWaitForResponse(pCmdStr, (char*)pContentStr, MAX_WAIT_TIME_SECS, &strResponse);
                if (strResponse != NULL)
                {
                 
                    std::string str(strResponse);
                    currentText += str;
                    std::cout << std::endl;
                    std::cout << std::endl;
                    std::cout << "Response:";
                    std::cout << currentText << std::endl;
                   
                    
                }

                delete [] strResponse;
                
                

            }
            



            
            // new append
            
            /*
            //char* values = pGetPrinterAllValues(commPtr, commTyp, false);
            char* values = pGetPrinterAllValues(commPtr, commTyp, true);
            if (values != NULL) {
                std::cout << values << std::endl;
                pFreeString(values);
            }
            */
              

                
            /*
            const std::string& key = "Ethernet.MAC";
            //char* value = pGetPrinterValue(commPtr, commTyp, false, key.c_str());
            char* value = pGetPrinterValue(commPtr, commTyp, true, key.c_str());
            if (value) {
                std::cout << value << std::endl;
                pFreeString(value);
            }
            */
            

            /*
            std::vector<std::string> keys = { "Ethernet.IP", "Ethernet.MAC", "Ethernet.Speed" };
            //char* values = pGetPrinterValues(commPtr, commTyp, false, keys);
            char* values = pGetPrinterValues(commPtr, commTyp, true, keys);

            if (values != NULL) {
                std::cout << values << std::endl;
                pFreeString(values);
            }
            */


            /*
            const std::string _key = "Ethernet.Speed";
            const std::string _value = "eAutomatic";
            //const std::string _key = "Image.Width-in";
            //const std::string _value = "3.5";
            //bool result = pSetPrinterValue(commPtr, commTyp, false, _key.c_str(), _value.c_str());
            bool result = pSetPrinterValue(commPtr, commTyp, true, _key.c_str(), _value.c_str());
            if (result) {
                std::cout << "Successfully set " << _key << " to " << _value << std::endl;
            }
            else {
                std::cerr << "Failed to set " << _key << std::endl;
            }
            */



            /*
            std::map<std::string, std::string> keyValues = {
               {"Ethernet.Speed", "eAutomatic"},
               {"Image.Width-in", "3.5"}
              
            };
            //bool _result = pSetPrinterValues(commPtr, commTyp, false, &keyValues);
            bool _result = pSetPrinterValues(commPtr, commTyp, true, &keyValues);
            if (_result) {
                std::cout << "Successfully set values." << std::endl;
            }
            else {
                std::cerr << "Failed to set values." << std::endl;
            }
            */

            
            
            /*
            std::string key_ = "Speed.Print-mmps";
            //std::string key_ = "BT.PairMethod";
            //char* Properties = pGetPrinterProperties(commPtr, commTyp, false, key_.c_str());
            char* Properties = pGetPrinterProperties(commPtr, commTyp, true, key_.c_str());
            if (Properties != NULL) {
                std::cout << Properties << std::endl;
                pFreeString(Properties);
            }
            */




            
            /*
            const char* keyProps[] = { "Speed", "Label.Sensor" };
            size_t keyCount = sizeof(keyProps) / sizeof(keyProps[0]);
            //char* PropertiesEx = pGetPrinterPropertiesEx(commPtr, commTyp, false, keyProps, keyCount);
            char* PropertiesEx = pGetPrinterPropertiesEx(commPtr, commTyp, true, keyProps, keyCount);
            if (PropertiesEx != NULL) {
                std::cout << PropertiesEx << std::endl;
                pFreeString(PropertiesEx);
            }
            */
            



            /*
            //char* AllProperties = pGetPrinterAllProperties(commPtr, commTyp, false);
            char* AllProperties = pGetPrinterAllProperties(commPtr, commTyp, true);
            if (AllProperties != NULL) {
                std::cout << AllProperties << std::endl;
                pFreeString(AllProperties);
            }
            */
            
            
            


            
            /*
            //char* pConfig = pGetPrinterConfig(commPtr, commTyp, false, 1);
            char* pConfig = pGetPrinterConfig(commPtr, commTyp, true, 1);
            if (pConfig != NULL) {
                std::cout << pConfig << std::endl;
            }
            //bool result = pSetPrinterConfig(commPtr, commTyp, false, pConfig);
            bool result = pSetPrinterConfig(commPtr, commTyp, true, pConfig);
            if (result) {
                std::cout << "Successfully set " << std::endl;
            }
            else {
                std::cerr << "Failed to set " << std::endl;
            }
            if (pConfig != NULL)
                pFreeString(pConfig);
            */
            
            


            
            //char* pAllConfig = pGetPrinterAllConfig(commPtr, commTyp, false);
            char* pAllConfig = pGetPrinterAllConfig(commPtr, commTyp, true);
            std::cout << "Wait for a while...." << std::endl;
            if (pAllConfig != NULL) {
                
                std::cout << pAllConfig << std::endl;
                pFreeString(pAllConfig);

            }
            

        }



    }
    else
    {
        std::cout << "Failed to Connect Printer!" << std::endl;
        FreeLibrary(m_CommSdkDLL);
        FreeLibrary(m_JsonSdkDLL);
        return 1;
    }


    int userInput;

    // 循環等待用戶輸入，直到用戶輸入0為止
    do {

        std::cout << std::endl;
        std::cout << std::endl;
        std::cout << "Press 0 to exit";
        std::cout << std::endl;
        std::cin >> userInput;
    } while (userInput != 0);

    // 使用者輸入0後程式結束
    std::cout << std::endl;
    std::cout << "Program exit" << std::endl;
    std::cout << std::endl;



    _bAsyncListening = false;

    

    if (listenerThread_.joinable()) {
        listenerThread_.join();
    }

    pMessengerRelease();
    pClose();

    
    FreeLibrary(m_CommSdkDLL);
    FreeLibrary(m_JsonSdkDLL);

    //_CrtSetBreakAlloc(1105);
    //_CrtDumpMemoryLeaks();

    return 0;
}


