﻿// TestPrinterDiscovery.cpp : 此檔案包含 'main' 函式。程式會於該處開始執行及結束執行。
//

#include <iostream>
#include <vector>
#include <string>
#include <Windows.h>


enum class Brand {
    ALL,
    TSC,
    PTX
};

// Discovery.dll export
typedef std::vector<std::string>* (__stdcall* PGETPRINTERLIST)(Brand brand, int responseTimeoutMs);
typedef void(__stdcall* PFREEPRINTERLIST)(std::vector<std::string>* pList);

typedef std::vector<std::string>* (__stdcall* PGETPRINTERLIST_IPv6)(std::string PREFIX, std::string INTERFACE_NAME, int responseTimeoutMs);
typedef void(__stdcall* PFREEPRINTERLIST_IPv6)(std::vector<std::string>* pList);

PGETPRINTERLIST pGetPrinterList = nullptr;
PFREEPRINTERLIST pFreePrinterList = nullptr;

PGETPRINTERLIST_IPv6 pGetPrinterList_IPv6 = nullptr;
PFREEPRINTERLIST_IPv6 pFreePrinterList_IPv6 = nullptr;

HINSTANCE hDiscoverySdkDLL = NULL;


int main()
{
    //std::cout << "Hello World!\n";

    _CrtSetReportMode(_CRT_WARN, _CRTDBG_MODE_FILE);
    _CrtSetReportFile(_CRT_WARN, NULL);

    hDiscoverySdkDLL = LoadLibrary(TEXT("Discovery.dll"));
    
    if (hDiscoverySdkDLL == NULL)
    {
        std::cout << "Load Discovery.dll failed!" << std::endl;
        return 1;
    }


    pGetPrinterList = (PGETPRINTERLIST)GetProcAddress(hDiscoverySdkDLL, "GetPrinterList");
    pFreePrinterList = (PFREEPRINTERLIST)GetProcAddress(hDiscoverySdkDLL, "FreePrinterList");
    pGetPrinterList_IPv6 = (PGETPRINTERLIST_IPv6)GetProcAddress(hDiscoverySdkDLL, "GetPrinterList_IPv6");
    pFreePrinterList_IPv6 = (PFREEPRINTERLIST_IPv6)GetProcAddress(hDiscoverySdkDLL, "FreePrinterList_IPv6");


    if (pGetPrinterList == nullptr || pFreePrinterList == nullptr ||
        pGetPrinterList_IPv6 == nullptr || pFreePrinterList_IPv6 == nullptr)
    {
        std::cout << "Load the Discovery.dll APIs failed!" << std::endl;
        if (hDiscoverySdkDLL != nullptr)
            FreeLibrary(hDiscoverySdkDLL);
        return 1;
    }

    std::cout << "Searching for printers..." << std::endl;

    
    std::vector<std::string>* pPrinterList = pGetPrinterList(Brand::ALL, 3000);
    //std::vector<std::string>* pPrinterList = pGetPrinterList(Brand::TSC, 3000);
    //std::vector<std::string>* pPrinterList = pGetPrinterList(Brand::PTX, 3000);

    if (pPrinterList == nullptr || pPrinterList->empty())
    {
        std::cout << "No Printers found." << std::endl;
    }
    else
    {
        std::cout << "Printers found at:" << std::endl;
        for (const auto& ip : *pPrinterList)
        {
            std::cout << ip << std::endl;
        }
    }

    
    if (pPrinterList)
    {
        pFreePrinterList(pPrinterList);
    }


    FreeLibrary(hDiscoverySdkDLL);
    return 0;

}

// 執行程式: Ctrl + F5 或 [偵錯] > [啟動但不偵錯] 功能表
// 偵錯程式: F5 或 [偵錯] > [啟動偵錯] 功能表

// 開始使用的提示: 
//   1. 使用 [方案總管] 視窗，新增/管理檔案
//   2. 使用 [Team Explorer] 視窗，連線到原始檔控制
//   3. 使用 [輸出] 視窗，參閱組建輸出與其他訊息
//   4. 使用 [錯誤清單] 視窗，檢視錯誤
//   5. 前往 [專案] > [新增項目]，建立新的程式碼檔案，或是前往 [專案] > [新增現有項目]，將現有程式碼檔案新增至專案
//   6. 之後要再次開啟此專案時，請前往 [檔案] > [開啟] > [專案]，然後選取 .sln 檔案
