﻿// TestPrinterMonitor.cpp : 此檔案包含 'main' 函式。程式會於該處開始執行及結束執行。
//
#define _CRTDBG_MAP_ALLOC
#include <cstdlib>
#include <crtdbg.h>

#include <iostream>
#include <fstream>
#include <functional>
#include <vector>
#include <utility>
#include <string>
#include <afx.h>
#include <conio.h>
#include <limits>
#include <limits>
#include <Windows.h>
#include <afx.h>


enum COMM_TYP
{
	USB_COMM = 0,
	TCP_COMM,
};

// 定義 Tuple 的結構
//#pragma pack(1)
struct Tuple_c {
	short vendorId;
	short productId;
};
//#pragma pack()

// TCP
enum DescriptorPortType {

	// Data
	DATA,
	// Management
	MGMT,
	// Status
	STATUS
};


struct PrinterInfo {
	std::string Model;
	std::string SerialNumber;
	std::string FirmwarePartNumber;
	std::string FirmwareVersion;
	std::string PrintheadResolution;
	bool HasRfidOption;
	bool HasOdvOption;
};


enum INFO_TYP
{
	ODV_TYP = 0,
	RFID_TYP,
	PRINTER_TYP,

};

using byte = unsigned char;

// CommSDK.dll export
typedef int(__stdcall* PBYTESAVAILABLE)();
typedef bool(__stdcall* PCONNECTED)();
typedef void(__stdcall* PREAD)(byte* buffer, int size);
typedef void(__stdcall* PWRITE)(byte* dataOut, int iDataSize);
typedef void(__stdcall* PCLOSE)();
typedef void(__stdcall* POPEN)();
typedef int(__stdcall* PGETAVAILABLEDEVICES)(Tuple_c** devices, int* count);
typedef void(__stdcall* PUSBCONNECT)(Tuple_c device);
typedef void(__stdcall* PTCPCONNECT)(char* ipAddress, int port);
typedef void(__stdcall* PGETCOMM)(CObject*& ptrComm);
typedef void(__stdcall* PSENDPRINTFILE)(char* ipAddress, char* fileName);


// JsonSDK.dll export
typedef void(__stdcall* PMESSENGERGET)(CObject* ptrComm, COMM_TYP commTyp, int maxInputMsgCapacity, bool usingDataPort);
typedef void(__stdcall* PMESSENGERRELEASE)();
typedef void(__stdcall* PMESSENGERSENDMSG)(char* strCommand, char* strContent);
typedef void(__stdcall* PMESSENGERREADNEXTMSG)(const char* strNextMsg);
typedef void(__stdcall* PMESSENGERSENDMSGANDWAITFORRESPONSE)(char* strCommand, char* strContent, int maxWaitTimeSecs, const char** strResponse);
typedef int(__stdcall* PMESSENGERUNREADMSGCOUNT)();
typedef void(__stdcall* PPRINTERMONITORCONNECTION)(char* lpAddress, INFO_TYP InfoTyp);
typedef void(__stdcall* PGETPRINTERINFO)(PrinterInfo* pPrtInfo, INFO_TYP InfoTyp);
typedef void(__stdcall* PPRINTERMONITORDISPOSE)(INFO_TYP InfoTyp);
typedef bool(__stdcall* PGETENGINESTATUSLISTENING)();
typedef void(__stdcall* PSETENGINESTATUSLISTENING)(bool value);
typedef bool(__stdcall* PGETDISPLAYSTATUSLISTENING)();
typedef void(__stdcall* PSETDISPLAYSTATUSLISTENING)(bool value);
typedef bool(__stdcall* PGETALERTSTATUSLISTENING)();
typedef void(__stdcall* PSETALERTSTATUSLISTENING)(bool value);
typedef void(__stdcall* PSETENGINESTATUSCALLBACK)(void callback(const std::string& engineState));
typedef void(__stdcall* PSETDISPLAYSTATUSCALLBACK)(void callback(const std::vector<std::string>& newDisplayText));
typedef void(__stdcall* PSETALERTSTATUSCALLBACK)(void callback(const std::vector<std::string>& alert));


PBYTESAVAILABLE pBytesAvailable = NULL;
PCONNECTED pConnected = NULL;
PREAD pRead = NULL;
PWRITE pWrite = NULL;
PCLOSE pClose = NULL;
POPEN pOpen = NULL;
PGETAVAILABLEDEVICES pGetAvailableDevices = NULL;
PUSBCONNECT pUsbConnect = NULL;
PTCPCONNECT pTcpConnect = NULL;
PGETCOMM pGetComm = NULL;
PSENDPRINTFILE pSendPrintFile = NULL;


PMESSENGERGET pMessengerGet = NULL;
PMESSENGERRELEASE pMessengerRelease = NULL;
PMESSENGERSENDMSG pMessengerSendMsg = NULL;
PMESSENGERREADNEXTMSG pMessengerReadNextMsg = NULL;
PMESSENGERSENDMSGANDWAITFORRESPONSE pMessengerSendMsgAndWaitForResponse = NULL;
PMESSENGERUNREADMSGCOUNT pMessengerUnreadMsgCount = NULL;
PPRINTERMONITORCONNECTION pPrinterMonitorConnection = NULL;
PGETPRINTERINFO pGetPrinterInfo = NULL;
PPRINTERMONITORDISPOSE pPrinterMonitorDispose = NULL;
PGETENGINESTATUSLISTENING pGetEngineStatusListening = NULL;
PSETENGINESTATUSLISTENING pSetEngineStatusListening = NULL;
PGETDISPLAYSTATUSLISTENING pGetDisplayStatusListening = NULL;
PSETDISPLAYSTATUSLISTENING pSetDisplayStatusListening = NULL;
PGETALERTSTATUSLISTENING pGetAlertStatusListening = NULL;
PSETALERTSTATUSLISTENING pSetAlertStatusListening = NULL;
PSETENGINESTATUSCALLBACK pSetEngineStatusCallback = NULL;
PSETDISPLAYSTATUSCALLBACK pSetDisplayStatusCallback = NULL;
PSETALERTSTATUSCALLBACK pSetAlertStatusCallback = NULL;

HINSTANCE m_CommSdkDLL = NULL;
HINSTANCE m_JsonSdkDLL = NULL;


PrinterInfo PrtInfo;
void ShowPrinterInfo(std::string strIP)
{
	pPrinterMonitorConnection((char*)strIP.c_str(), INFO_TYP::PRINTER_TYP);
	pGetPrinterInfo(&PrtInfo, INFO_TYP::PRINTER_TYP);

	std::cout << std::endl;
	std::cout << "Printer Model: " << PrtInfo.Model << std::endl;
	std::cout << "Printer SN: " << PrtInfo.SerialNumber << std::endl;
	std::cout << "Printer FW PN: " << PrtInfo.FirmwarePartNumber << std::endl;
	std::cout << "Printer FW Ver: " << PrtInfo.FirmwareVersion << std::endl;
	std::cout << "Printhead Resolution (Dots/Inch): " << PrtInfo.PrintheadResolution << std::endl;
	std::cout << std::endl;
	std::cout << "Has RFID: " << (PrtInfo.HasRfidOption ? "yes" : "no") << std::endl;
	std::cout << "Has ODV: " << (PrtInfo.HasOdvOption ? "yes" : "no") << std::endl;

}


void PtrAlertNoticeListener(const std::vector<std::string>& alert)
{
	// Print out alerts: e.g. "2418" ("Print Head Open" fault/alert)
	// "0000" = no alerts
	std::cout << "Printer Alert #: \n  " << alert[0] << " - " << alert[1] << "\n\n";
}

void PtrEngineStatusNoticeListener(const std::string& engineState)
{
	// Print out engine status: e.g. "idle", "offline", "online", "printing"...
	std::cout << "Engine Status: \n  " << engineState << "\n\n";
}

void PtrDisplayStatusNoticeListener(const std::vector<std::string>& newDisplayText)
{
	// Print display msgs: e.g. "ONLINE" "ETHERNET/PGL/LP+" or "PRINT HEAD UP" //"Close Print Head"
	std::cout << "Printer Display: \n";
	for (const std::string& txtLine : newDisplayText) {
		std::cout << "  " << txtLine << "\n";
	}
}


void WaitForSomethingToHappen_PrinterMonitor(const std::string& strIP)
{
	std::string usage = "\nUsage: \r\n '1' print test file \r\n '0' quit\r\n Enter the number and then press <Enter>. Or, press 0 to exit. ";

	std::cout << usage;

	do
	{
		if (_kbhit()) // Check if a key is pressed
		{
			
			char choice;
			std::cin >> choice;


			// Call the function associated with the selected test
			switch (choice)
			{
			case '0': // quit/exit
				return;

			case '1': // send test print job
				pSendPrintFile(const_cast<char*>(strIP.c_str()), const_cast<char*>("Hello_1.pgl"));
				break;

			default:
				std::cout << usage;
				break;
			}
		}
	} while (true);
}


void PrinterMonitor(std::string strIP)
{
	try {
		pPrinterMonitorConnection((char*)strIP.c_str(), INFO_TYP::PRINTER_TYP);

		pSetAlertStatusListening(true);
		pSetAlertStatusCallback(PtrAlertNoticeListener);

		pSetEngineStatusListening(true);
		pSetEngineStatusCallback(PtrEngineStatusNoticeListener);

		pSetDisplayStatusListening(true);
		pSetDisplayStatusCallback(PtrDisplayStatusNoticeListener);


		WaitForSomethingToHappen_PrinterMonitor(strIP);


	}
	catch (const std::exception& e) {
		std::cerr << "Exception Msg: " << e.what() << std::endl;
	}


	pPrinterMonitorDispose(INFO_TYP::PRINTER_TYP);

}


int main()
{
	_CrtSetReportMode(_CRT_WARN, _CRTDBG_MODE_FILE);
	_CrtSetReportFile(_CRT_WARN, NULL);


	m_CommSdkDLL = LoadLibrary(_T("CommSDK.dll"));
	m_JsonSdkDLL = LoadLibrary(_T("JsonSDK.dll"));

	if (m_CommSdkDLL == NULL)
	{
		std::cout << (_T("Load CommSDK.dll failed!"));
		return 1;
	}

	if (m_JsonSdkDLL == NULL)
	{
		std::cout << (_T("Load JsonSDK.dll failed!"));
		return 1;
	}


	pBytesAvailable = (PBYTESAVAILABLE)GetProcAddress(m_CommSdkDLL, "BytesAvailable");
	pConnected = (PCONNECTED)GetProcAddress(m_CommSdkDLL, "Connected");
	pRead = (PREAD)GetProcAddress(m_CommSdkDLL, "Read");
	pWrite = (PWRITE)GetProcAddress(m_CommSdkDLL, "Write");
	pClose = (PCLOSE)GetProcAddress(m_CommSdkDLL, "Close");
	pOpen = (POPEN)GetProcAddress(m_CommSdkDLL, "Open");
	pGetAvailableDevices = (PGETAVAILABLEDEVICES)GetProcAddress(m_CommSdkDLL, "GetAvailableDevices");
	pUsbConnect = (PUSBCONNECT)GetProcAddress(m_CommSdkDLL, "UsbConnect");
	pTcpConnect = (PTCPCONNECT)GetProcAddress(m_CommSdkDLL, "TcpConnect");
	pGetComm = (PGETCOMM)GetProcAddress(m_CommSdkDLL, "GetComm");
	pSendPrintFile = (PSENDPRINTFILE)GetProcAddress(m_CommSdkDLL, "SendPrintFile");



	if (pBytesAvailable == NULL || pConnected == NULL || pRead == NULL || pOpen == NULL ||
		pClose == NULL || pWrite == NULL || pGetAvailableDevices == NULL || pUsbConnect == NULL || 
		pTcpConnect == NULL || pGetComm == NULL || pSendPrintFile == NULL)
	{
		std::cout << (_T("Load the CommSDK.dll APIs failed!"));
		return 1;
	}

	//JsonSDK DLL

	pMessengerGet = (PMESSENGERGET)GetProcAddress(m_JsonSdkDLL, "MessengerGet");
	pMessengerRelease = (PMESSENGERRELEASE)GetProcAddress(m_JsonSdkDLL, "MessengerRelease");
	pMessengerSendMsg = (PMESSENGERSENDMSG)GetProcAddress(m_JsonSdkDLL, "MessengerSendMsg");
	pMessengerReadNextMsg = (PMESSENGERREADNEXTMSG)GetProcAddress(m_JsonSdkDLL, "MessengerReadNextMsg");
	pMessengerSendMsgAndWaitForResponse = (PMESSENGERSENDMSGANDWAITFORRESPONSE)GetProcAddress(m_JsonSdkDLL, "MessengerSendMsgAndWaitForResponse");
	pMessengerUnreadMsgCount = (PMESSENGERUNREADMSGCOUNT)GetProcAddress(m_JsonSdkDLL, "MessengerUnreadMsgCount");
	pPrinterMonitorConnection = (PPRINTERMONITORCONNECTION)GetProcAddress(m_JsonSdkDLL, "PrinterMonitorConnection");
	pGetPrinterInfo = (PGETPRINTERINFO)GetProcAddress(m_JsonSdkDLL, "GetPrinterInfo");
	pPrinterMonitorDispose = (PPRINTERMONITORDISPOSE)GetProcAddress(m_JsonSdkDLL, "PrinterMonitorDispose");
	pGetEngineStatusListening = (PGETDISPLAYSTATUSLISTENING)GetProcAddress(m_JsonSdkDLL, "GetEngineStatusListening");
	pSetEngineStatusListening = (PSETDISPLAYSTATUSLISTENING)GetProcAddress(m_JsonSdkDLL, "SetEngineStatusListening");
	pGetDisplayStatusListening = (PGETDISPLAYSTATUSLISTENING)GetProcAddress(m_JsonSdkDLL, "GetDisplayStatusListening");
	pSetDisplayStatusListening = (PSETDISPLAYSTATUSLISTENING)GetProcAddress(m_JsonSdkDLL, "SetDisplayStatusListening");
	pSetAlertStatusListening = (PSETALERTSTATUSLISTENING)GetProcAddress(m_JsonSdkDLL, "SetAlertStatusListening");
	pGetAlertStatusListening = (PGETALERTSTATUSLISTENING)GetProcAddress(m_JsonSdkDLL, "GetAlertStatusListening");
	pSetEngineStatusCallback = (PSETENGINESTATUSCALLBACK)GetProcAddress(m_JsonSdkDLL, "SetEngineStatusCallback");
	pSetDisplayStatusCallback = (PSETDISPLAYSTATUSCALLBACK)GetProcAddress(m_JsonSdkDLL, "SetDisplayStatusCallback");
	pSetAlertStatusCallback = (PSETALERTSTATUSCALLBACK)GetProcAddress(m_JsonSdkDLL, "SetAlertStatusCallback");
	



	if (pMessengerGet == NULL || pMessengerRelease == NULL || pMessengerSendMsg == NULL || pMessengerReadNextMsg == NULL ||
		pMessengerSendMsgAndWaitForResponse == NULL || pMessengerUnreadMsgCount == NULL || pGetPrinterInfo == NULL ||
		pPrinterMonitorConnection == NULL || pPrinterMonitorDispose == NULL || pGetEngineStatusListening == NULL || pSetEngineStatusListening == NULL || 
		pGetDisplayStatusListening == NULL || pSetDisplayStatusListening == NULL || pSetAlertStatusListening == NULL || pGetAlertStatusListening == NULL || 
		pSetEngineStatusCallback == NULL || pSetDisplayStatusCallback == NULL || pSetAlertStatusCallback == NULL)
	{
		std::cout << (_T("Load the JsonSDK.dll APIs failed!"));
		return 1;
	}

	std::string ptrIp = "10.0.10.179";
	ShowPrinterInfo(ptrIp);

	PrinterMonitor(ptrIp);



	pClose();


	FreeLibrary(m_CommSdkDLL);
	FreeLibrary(m_JsonSdkDLL);
	return 0;

    
}


