﻿// TsplFormTest.cpp : 此檔案包含 'main' 函式。程式會於該處開始執行及結束執行。
//
#define _CRTDBG_MAP_ALLOC
#include <cstdlib>
#include <crtdbg.h>


#pragma warning(disable: 4305)
#pragma warning(disable: 4566)

#include <iostream>
#include <vector>
#include <Windows.h>
#include <tchar.h>
#include <tuple>


enum class ScaleEnum {
    Dot,
    MM,
    Inch
};

enum class MaxicodeModeEnum {
    MODE_2 = 2,
    MODE_3 = 3,
    MODE_4 = 4
};


enum class Pdf417ErrCorrectionEnum
{
    LEVEL_0 = 0,
    LEVEL_1,
    LEVEL_2,
    LEVEL_3,
    LEVEL_4,
    LEVEL_5,
    LEVEL_6,
    LEVEL_7,
    LEVEL_8
};


enum class AztecCodeTypeEnum {
    Default,
    FixedErrCorrection,
    Compact,
    Full,
    Rune
};


enum class RotateEnum
{
    None,
    ClockWise,
    CounterClockWise,
    Inverted
};


enum class QRCodeMaskEnum {
    Mask_0 = 0,
    Mask_1,
    Mask_2,
    Mask_3,
    Mask_4,
    Mask_5,
    Mask_6,
    Mask_7,
    Mask_8
};


enum class QRCodeManualEncodingEnum {
    Numeric,
    AlphaNumeric,
    Binary,
    Kanji
};

enum class QRCodeErrorCorrectionEnum {
    EC_7,
    EC_15,
    EC_25,
    EC_30
};

enum class QRCodeModelEnum {
    MODEL_1,
    MODEL_2
};


enum class RfidMemBlockEnum {
    InvalidMemBlock,
    EPC,
    TID,
    User,
    AccessCode,
    KillCode,
    PC,
    Reserve
};


enum class RfidPasswordTypeEnum {
    None,
    Lock,
    PermaLock,
    Unlock,
    PermaUnlock
};


enum class FontSizeUnitsEnum {
    Ruler,
    Points,
    Percent
};


enum class FontStyleEnum {
    Normal = 0,
    Bold = 1,
    Italic = 2
};


enum class AlignEnum
{
    Default,
    Left,
    Center,
    Right
};


// TSPL
enum class BarcodeTypeEnum_1D
{
    NOT_DEFINED,
    Code_93,
    Code_39,
    Code_128,
    EAN13,
    EAN8,
    UPCA,
    I2of5,
    CODABAR
};


enum class Brand {
    TSC = 1,
    PTX
};



enum COMM_TYP
{
    USB_COMM = 0,
    TCP_COMM,
    BT_COMM,
    COM_COMM
};


#define TSPL 0
#define PGL 1

typedef unsigned __int64 u_int64;

typedef void(__stdcall* PCREATELABEL)(int iPrintLanguageTyp, std::string LabelName, float dotsPerUnit, ScaleEnum unit);
typedef void*(__stdcall* PCREATETEXTS)(float x_start, float y_start, float fontsize_x, float fontsize_y, std::string data, ScaleEnum scale,
     FontSizeUnitsEnum FontSizeUnit, FontStyleEnum FontStyle, AlignEnum Alignment, std::string fontName, RotateEnum rotation);
typedef void* (__stdcall* PCREATELINES)(float start_x, float start_y, float end_x, float end_y, float lineThickness, ScaleEnum scale);
typedef void* (__stdcall* PCREATEBOXS)(float start_x, float start_y, float end_x, float end_y, float lineThickness, ScaleEnum scale);
typedef void* (__stdcall* PCREATEMAXICODEBARCODES)(int iMaxicodeTyp, MaxicodeModeEnum mode, std::string postalCode, std::string countryCode, std::string serviceClass,
    std::string remainingMsg, std::string year, std::string primaryMsg, float start_x, float start_y, ScaleEnum scale, bool ZipperPattern, RotateEnum rotation);
typedef void* (__stdcall* PCREATEPDF417BCODES)(float start_x, float start_y, std::string content, ScaleEnum scale, float xdim, float ydim,
    Pdf417ErrCorrectionEnum ErrorCorrection, int row, int col, RotateEnum rotation);
typedef void* (__stdcall* PCREATEAZTECBARCODES)(float start_x, float start_y, std::string content, ScaleEnum scale, float xdim,
    AztecCodeTypeEnum CodeType, int iFixedErrCorrection, int iLayers, RotateEnum rotation);
typedef void* (__stdcall* PCREATEDATAMATRIXBARCODES)(float start_x, float start_y, std::string content, ScaleEnum scale, float xdim,
    RotateEnum Rotation, bool UseRectangle, std::string MatrixMultiLine, char CtrlChar1, char CtrlChar2, int row, int col);
typedef void* (__stdcall* PCREATEQRBARCODES)(float start_x, float start_y, std::string content, ScaleEnum scale, float xdim,
    QRCodeMaskEnum Mask, std::vector<std::tuple<QRCodeManualEncodingEnum, std::string>>* dataManuallyEncoded, QRCodeErrorCorrectionEnum ErrEnum, QRCodeModelEnum ModelEnum, RotateEnum rotation);
typedef void* (__stdcall* PCREATERFIDENCODE)(unsigned int a32BitField, unsigned int a16BitField, std::string a6CharAsciiString,
    RfidMemBlockEnum MemBlock, int iOffsetFromStart, std::string _10BytesUserData, std::string _4BytesHexUserData, RfidPasswordTypeEnum PasswordEnum, std::string password);
typedef void* (__stdcall* PCREATEBARCODE1D)(float start_x, float start_y, std::string content, ScaleEnum scale, float narrowBar, float wideBar,
    float Height, BarcodeTypeEnum_1D BcdTyp, bool PrintHumanReadable, RotateEnum rotation, bool PdfLocTop);
typedef void (__stdcall* PCLOSELABEL)();
typedef void (__stdcall* PLABELTOSTRING)(std::string& str);
typedef bool (__stdcall* PWINDOWSFONT)(int fontheight, int rotation, int fontstyle,
    int fontunderline, char* szFaceName, void* content, bool isUnicode, Brand brand, char* szFilePath, COMM_TYP commTyp,
    char* ipAddress, int port, u_int64 macAddress, std::string ComPort, int BaudRate);
typedef void* (__stdcall* PICTURE)(int x, int y, std::string strFilePath);


PCREATELABEL pCreateLabel = nullptr;
PCREATETEXTS pCreateTexts = nullptr;
PCREATELINES pCreateLines = nullptr;
PCREATEBOXS pCreateBoxs = nullptr;
PCREATEMAXICODEBARCODES pCreateMaxicodeBarcodes = nullptr;
PCREATEPDF417BCODES pCreatePdf417Bcodes = nullptr;
PCREATEAZTECBARCODES pCreateAztecBarcodes = nullptr;
PCREATEDATAMATRIXBARCODES pCreateDataMatrixBarcodes = nullptr;
PCREATEQRBARCODES pCreateQRBarcodes = nullptr;
PCREATERFIDENCODE pCreateRfidEncode = nullptr;
PCREATEBARCODE1D pCreateBarcode1D = nullptr;
PCLOSELABEL pCloseLabel = nullptr;
PLABELTOSTRING pLabelToString = nullptr;
PWINDOWSFONT pWindowsFont = nullptr;
PICTURE pPicture = nullptr;

HINSTANCE m_SdkDLL = nullptr;


std::string LabelString;

#define NON_USED -1
void SimpleTextLabel(std::string & LabelString)
{
    if (m_SdkDLL != nullptr)
    {
        // TSC
        //std::wstring text = L"測試 Windows Font";
        //pWindowsFont(30, 0, 4, 0, (char*)"Microsoft JhengHei", (void*)text.c_str(), true, Brand::TSC, (char*)"BmpWindowsFont.bmp", COMM_TYP::USB_COMM, nullptr, 0, 0, "", 0);
        //std::wstring text = L"測試繁體中文";
        //pWindowsFont(30, 0, 0, 0, (char*)"Arial", (void*)text.c_str(), true, Brand::TSC, (char*)"BmpWindowsFont.bmp", COMM_TYP::TCP_COMM, (char*)"192.168.50.191", 9100, 0, "", 0);
        pWindowsFont(30, 0, 0, 0, (char*)"Arial", (void*)"Test Windows Font", false, Brand::TSC, (char*)"BmpWindowsFont.bmp", COMM_TYP::USB_COMM, nullptr, 0, 0, "", 0);

        
        
        // PTX
        //std::wstring text = L"測試繁體中文";
        //pWindowsFont(20, 0, 0, 0, (char*)"Arial", (void*)text.c_str(), true, Brand::PTX, (char*)"BmpWindowsFont", COMM_TYP::TCP_COMM, (char*)"192.168.101.61", 9100, 0, "", 0);
        //pWindowsFont(20, 0, 0, 0, (char*)"Arial", (void*)"Test Windows Font", false, Brand::PTX, (char*)"BmpWindowsFont", COMM_TYP::USB_COMM, nullptr, 0, 0, "", 0);
        
        
        
        pCreateLabel(TSPL, "SimpleLabel", 300, ScaleEnum::Inch);
        //pCreateLabel(PGL, "SimpleLabel", 300, ScaleEnum::Inch);

        pCreateLines(2.5f, (float)1/16, 2.5f, 1.0f, (float)1/32, ScaleEnum::Inch);
        pCreateLines(0.12f, 1.0f, 3.88f, 1.0f, (float)1 / 32, ScaleEnum::Inch);
        pCreateLines(0.12f, 3.5f, 3.88f, 3.5f, (float)1 / 32, ScaleEnum::Inch);
        pCreateBoxs(0.5f, 1.25f, 3.5f, 2.25f, (float)1 / 16, ScaleEnum::Inch);
        

        // Text
        
        pCreateTexts(2.0, 1.25 + (float)7 / 16, (float)3 / 16, (float)7 / 16, "MY MAGIC", ScaleEnum::Inch, FontSizeUnitsEnum::Ruler,
            (FontStyleEnum)NON_USED, AlignEnum::Center, "93952.sf", RotateEnum::None);
        pCreateTexts(2.0, 1.25 + 1.0 - (float)3 / 16, (float)3 / 16, (float)7 / 16, "PRODUCT", ScaleEnum::Inch, FontSizeUnitsEnum::Ruler,
            (FontStyleEnum)NON_USED, AlignEnum::Center, "93952.sf", RotateEnum::None);

        
        pCreateTexts(5.0, 5.0, 2.5, 5.0, "TO:", ScaleEnum::MM, FontSizeUnitsEnum::Ruler,
            FontStyleEnum::Bold, AlignEnum::Default, "92248.sf", RotateEnum::None);
        pCreateTexts((2.5 + (float)1/16) * 25.4, 5.0, 2.5, 5.0, "FROM:", ScaleEnum::MM, FontSizeUnitsEnum::Ruler,
            FontStyleEnum::Bold, AlignEnum::Default, "92248.sf", RotateEnum::None);
        
        pCreateTexts((2.5 + (float)1/16 + (float)1/8) * 25.4, 17.0, 2.0, 3.0, "Happy Inc.", ScaleEnum::MM, FontSizeUnitsEnum::Percent,
            FontStyleEnum::Italic, AlignEnum::Default, "92500.sf", RotateEnum::None);


        
        pPicture(100, 200, (char*)"BmpWindowsFont.bmp"); // TSC
        //pPicture(5, 1, (char*)"BmpWindowsFont"); // PTX
        

        pLabelToString(LabelString);
       

    }
    
}

void BcdMaxicodes(std::string& LabelString)
{
    if (m_SdkDLL != nullptr)
    {
        enum
        {
            _MaxicodeMsgStructured = 0,
            _MaxicodeMsgStructuredOpenSystemStandard,
            _MaxicodeMsg,

        };

        pCreateLabel(PGL, "MaxiBcds", 300, ScaleEnum::Inch);
        //pCreateLabel(TSPL, "MaxiBcds", 300, ScaleEnum::Inch);
        pCreateMaxicodeBarcodes(_MaxicodeMsgStructured, MaxicodeModeEnum::MODE_2, "902557317", "800", "200", "Maxicode Carrier Standard", "", "", 0.5, 0.5, ScaleEnum::Inch, false, RotateEnum::None);
        pCreateMaxicodeBarcodes(_MaxicodeMsg, MaxicodeModeEnum::MODE_4, "", "", "", "Maxicode unstructured", "", "123456789", 0.5, 3.5, ScaleEnum::Inch, false, RotateEnum::None);
        pLabelToString(LabelString);
        
    }
   

}


void BcdAztec(std::string& LabelString)
{
    if (m_SdkDLL != nullptr) {

        pCreateLabel(TSPL, "AztecBcodes", 300, ScaleEnum::Inch);
        //pCreateLabel(PGL, "AztecBcodes", 300, ScaleEnum::Inch);
        pCreateAztecBarcodes(0.25, 1.0, "Mr. AirTraveler, seat A, flight 200", ScaleEnum::Inch, (float)0.025, AztecCodeTypeEnum::Default, NON_USED, NON_USED, RotateEnum::None);
        pCreateAztecBarcodes(1.5, 1.0, "Mr. AirTraveler, seat A, flight 200", ScaleEnum::Inch, (float)0.025, AztecCodeTypeEnum::FixedErrCorrection, 30, NON_USED, RotateEnum::None);
        pCreateAztecBarcodes(0.25, 2.25f, "Mr. AirTraveler, seat A, flight 200", ScaleEnum::Inch, (float)0.025, AztecCodeTypeEnum::Compact, NON_USED, 4, RotateEnum::None);
        pCreateAztecBarcodes(0.75, 4.0f, "255", ScaleEnum::Inch, (float)0.025, AztecCodeTypeEnum::Rune, NON_USED, NON_USED, RotateEnum::None);
        pLabelToString(LabelString);

    }
}


void BcdQRCode(std::string& LabelString)
{
    if (m_SdkDLL != nullptr) {

        std::string enText = "Tree in the forest";
        std::string jaText = "森の中の木";

        std::vector<std::tuple<QRCodeManualEncodingEnum, std::string>>* dataManuallyEncoded = nullptr;
        

        
        //pCreateLabel(PGL, "QRBcodes", 300, ScaleEnum::Inch);
        pCreateLabel(TSPL, "QRBcodes", 300, ScaleEnum::Inch);
        pCreateQRBarcodes(0.25f, 1.0f, enText, ScaleEnum::Inch, 0.025f, (QRCodeMaskEnum)NON_USED, dataManuallyEncoded,
            (QRCodeErrorCorrectionEnum)NON_USED, (QRCodeModelEnum)NON_USED, RotateEnum::None);
        pCreateQRBarcodes(1.5f, 1.0f, enText, ScaleEnum::Inch, 0.025f, QRCodeMaskEnum::Mask_4, dataManuallyEncoded,
            (QRCodeErrorCorrectionEnum)NON_USED, (QRCodeModelEnum)NON_USED, RotateEnum::None);


        if (dataManuallyEncoded == nullptr) {

            dataManuallyEncoded = new std::vector<std::tuple<QRCodeManualEncodingEnum, std::string>>;

            dataManuallyEncoded->push_back(std::make_tuple(QRCodeManualEncodingEnum::Numeric, "12345678"));
            dataManuallyEncoded->push_back(std::make_tuple(QRCodeManualEncodingEnum::AlphaNumeric, " TREE IN THE FOREST "));
            dataManuallyEncoded->push_back(std::make_tuple(QRCodeManualEncodingEnum::AlphaNumeric, "森の中の木"));

            pCreateQRBarcodes(1.75f, 3.75f, "", ScaleEnum::Inch, 0.025f, QRCodeMaskEnum::Mask_4, dataManuallyEncoded,
                (QRCodeErrorCorrectionEnum)NON_USED, (QRCodeModelEnum)NON_USED, RotateEnum::None);
        }
        pLabelToString(LabelString);

        delete dataManuallyEncoded;


    }
}



void RfidEncode(std::string& LabelString)
{
    if (m_SdkDLL != nullptr) {
        //pCreateLabel(PGL, "RfidLbl", 300, ScaleEnum::Inch);
        pCreateLabel(TSPL, "RfidLbl", 300, ScaleEnum::Inch);

        unsigned int a32BitField = 0x11223344;
        unsigned short a16BitField = 0xBEEF;
        std::string a6CharAsciiString = "MyData";

        pCreateRfidEncode(a32BitField, a16BitField, a6CharAsciiString, RfidMemBlockEnum::EPC, 0,
            "", "", RfidPasswordTypeEnum::None, "");
        pCreateRfidEncode(a32BitField, a16BitField, a6CharAsciiString, RfidMemBlockEnum::User, 2,
            "MyUserData", "0ABCDE0F", RfidPasswordTypeEnum::None, "");



        pLabelToString(LabelString);
    }

}



void BcdPdf417(std::string& LabelString)
{
    if (m_SdkDLL != nullptr) {
        //pCreateLabel(TSPL, "Pdf417Bcodes", 300, ScaleEnum::Inch);
        pCreateLabel(PGL, "Pdf417Bcodes", 600, ScaleEnum::Inch);

        std::string someText = "The happiness in your life depends on the quality of your thoughts. --Marcus Aurelius";
        std::string someShortText = "PI = 3.1415";
        pCreatePdf417Bcodes(0.25, 0.5, someText, ScaleEnum::Inch, 0.015, 0.05, (Pdf417ErrCorrectionEnum)NON_USED, NON_USED, NON_USED, RotateEnum::None);
        pCreatePdf417Bcodes(0.25, 1.5, someShortText, ScaleEnum::Inch, 0.015, 0.05, Pdf417ErrCorrectionEnum::LEVEL_0, NON_USED, NON_USED, RotateEnum::None);
        pCreatePdf417Bcodes(0.25, 2.0, someShortText, ScaleEnum::Inch, 0.015, 0.05, Pdf417ErrCorrectionEnum::LEVEL_5, NON_USED, NON_USED, RotateEnum::None);
        pCreatePdf417Bcodes(0.25, 3.0, someShortText, ScaleEnum::Inch, 0.015, 0.05, (Pdf417ErrCorrectionEnum)NON_USED, 15, NON_USED, RotateEnum::None);
        pCreatePdf417Bcodes(0.25, 4.0, someShortText, ScaleEnum::Inch, 0.015, 0.05, (Pdf417ErrCorrectionEnum)NON_USED, NON_USED, 5, RotateEnum::None);
        pLabelToString(LabelString);

    }
}



void BcdDataMatrix(std::string& LabelString)
{

    if (m_SdkDLL != nullptr) {
        pCreateLabel(TSPL, "DMatrixBcds", 203, ScaleEnum::Inch);
        //pCreateLabel(PGL, "DMatrixBcds", 300, ScaleEnum::Inch);
        pCreateDataMatrixBarcodes(0.25, 0.25, "Default DataMatrix", ScaleEnum::Inch, NON_USED, RotateEnum::None, false, "", 0, 0, 0, 0);      
        pCreateDataMatrixBarcodes(1.25, 0.25, "Rectangular DataMatrix", ScaleEnum::Inch,0.025, RotateEnum::CounterClockWise, true, "", 0, 0, 0, 0);
        pCreateDataMatrixBarcodes(2.25, 0.25, "Line 1 DataMatrix", ScaleEnum::Inch, NON_USED, RotateEnum::None, false, "Line 2 content/r/nLine 3 content", 0x0D, 0x0A, 0, 0);
        pCreateDataMatrixBarcodes(1.25, 1.75, "DataMatrix with user defined dimensions", ScaleEnum::Inch, 0.03, RotateEnum::None, true, "", 0, 0, 16, 36);
        pLabelToString(LabelString);

    }
}




void Barcode1D(std::string& LabelString)
{
    if (m_SdkDLL != nullptr) {
        pCreateLabel(TSPL, "Barcode1D", 300, ScaleEnum::Inch);
        //pCreateLabel(PGL, "Barcode1D", 300, ScaleEnum::Inch);
        pCreateBarcode1D(0.5, 1.0 + 1.5 + (float)1 / 4 + 1.2, "Code 128", ScaleEnum::Inch, 0.015, 0.015 * 4.1, 1.2, BarcodeTypeEnum_1D::Code_128,
            true, RotateEnum::None, false);
        pCreateBarcode1D(0.5, 3.5 - (float)1 / 8 - 0.6, "CODE 93", ScaleEnum::Inch, 0.025, 0.025 * 4.1, 0.6, BarcodeTypeEnum_1D::Code_93,
            true, RotateEnum::None, false);
        pLabelToString(LabelString);
    }
}



int main()
{

    _CrtSetReportMode(_CRT_WARN, _CRTDBG_MODE_FILE);
    _CrtSetReportFile(_CRT_WARN, NULL);

    m_SdkDLL = LoadLibrary(_T("LabelMakerSDK.dll"));

    if (m_SdkDLL == nullptr)
    {
        std::cout << "Load LabelMakerSDK.dll failed!" << std::endl;
        return 1;
    }

    pCreateLabel = (PCREATELABEL)GetProcAddress(m_SdkDLL, "CreateLabel");
    pCreateTexts = (PCREATETEXTS)GetProcAddress(m_SdkDLL, "CreateTexts");
    pCreateLines = (PCREATELINES)GetProcAddress(m_SdkDLL, "CreateLines");
    pCreateBoxs = (PCREATEBOXS)GetProcAddress(m_SdkDLL, "CreateBoxs");
    pCreateMaxicodeBarcodes = (PCREATEMAXICODEBARCODES)GetProcAddress(m_SdkDLL, "CreateMaxicodeBarcodes");
    pCreatePdf417Bcodes = (PCREATEPDF417BCODES)GetProcAddress(m_SdkDLL, "CreatePdf417Bcodes");
    pCreateAztecBarcodes = (PCREATEAZTECBARCODES)GetProcAddress(m_SdkDLL, "CreateAztecBarcodes");
    pCreateDataMatrixBarcodes = (PCREATEDATAMATRIXBARCODES)GetProcAddress(m_SdkDLL, "CreateDataMatrixBarcodes");
    pCreateQRBarcodes = (PCREATEQRBARCODES)GetProcAddress(m_SdkDLL, "CreateQRBarcodes");
    pCreateRfidEncode = (PCREATERFIDENCODE)GetProcAddress(m_SdkDLL, "CreateRfidEncode");
    pCreateBarcode1D = (PCREATEBARCODE1D)GetProcAddress(m_SdkDLL, "CreateBarcode1D");
    pCloseLabel = (PCLOSELABEL)GetProcAddress(m_SdkDLL, "CloseLabel");
    pLabelToString = (PLABELTOSTRING)GetProcAddress(m_SdkDLL, "LabelToString");
    pWindowsFont = (PWINDOWSFONT)GetProcAddress(m_SdkDLL, "WindowsFont");
    pPicture = (PICTURE)GetProcAddress(m_SdkDLL, "Picture");


    if (pCreateLabel == nullptr || pCreateTexts == nullptr || pCreateLines == nullptr || pCreateBoxs == nullptr ||
        pCreateMaxicodeBarcodes == nullptr || pCreatePdf417Bcodes == nullptr || pCreateAztecBarcodes == nullptr ||
        pCreateDataMatrixBarcodes == nullptr || pCreateQRBarcodes == nullptr || pCreateRfidEncode == nullptr || 
        pCreateBarcode1D == nullptr || pCloseLabel == nullptr || pLabelToString == nullptr || pWindowsFont == nullptr ||
        pPicture == nullptr)
    {
        std::cout << "Load the LabelMakerSDK.dll APIs failed!" << std::endl;
        if (m_SdkDLL != nullptr)
            FreeLibrary(m_SdkDLL);
        return 1;
    }


    LabelString.clear();
    SimpleTextLabel(LabelString);
    //BcdMaxicodes(LabelString);
    //BcdAztec(LabelString);
    //BcdQRCode(LabelString);
    //RfidEncode(LabelString);
    //BcdPdf417(LabelString);
   
    //BcdDataMatrix(LabelString);
    //Barcode1D(LabelString);

    if (!LabelString.empty()) {
        
        std::cout << LabelString << std::endl;



    }


    
    
    pCloseLabel();

    if (m_SdkDLL != nullptr)
        FreeLibrary(m_SdkDLL);

    
    LabelString.clear();


    int userInput;

    // 循環等待用戶輸入，直到用戶輸入0為止
    do {

        std::cout << std::endl;
        std::cout << std::endl;
        std::cout << "Press 0 to exit";
        std::cout << std::endl;
        std::cin >> userInput;
    } while (userInput != 0);

    // 使用者輸入0後程式結束
    std::cout << std::endl;
    std::cout << "Program exit" << std::endl;
    std::cout << std::endl;


    return 0;
}

