#include "CommSDK.h"
#include <cstdio>
#include <iostream>
#include <cstring>
#include <vector>
#include <string>
#include <sstream>
#include <thread>
#include <chrono>
#include <mutex>



#define TSC_USB_VID 0x1203
#define PTX_USB_VID 0x14ae



typedef unsigned char byte;

Tuple_c* devices = nullptr;


bool _bAsyncListening = false;
bool _bConnected = false;
std::mutex _mutex;
std::thread listenerThread_;
std::string currentText;



void loadListOfUsbPrinters() {
    
    int count = 0;

    GetAvailableDevices(&devices, &count);
    std::cout << "Number of devices: " << count << std::endl;

    if (count > 0) {
        bool fDevFound = false;
        for (int i = 0; i < count; i++) {
            std::cout << "Device " << i << ": VendorID= 0x" << std::hex << devices[i].Item1
                << " ProductID= 0x" << devices[i].Item2 << std::endl;

            std::string usbItemDesc;
            if (TSC_USB_VID == devices[i].Item1) {
                usbItemDesc = "TSC";
                fDevFound = true;
            }
            else if (PTX_USB_VID == devices[i].Item1) {
                usbItemDesc = "Printronix";
                fDevFound = true;
            }

            
            if (fDevFound) {
                std::ostringstream oss;
                oss << std::hex << devices[i].Item1;
                std::string vendorIdHex = oss.str();
                oss.str("");  // 清除 oss 的內容以供重用
                oss << std::hex << devices[i].Item2;
                std::string productIdHex = oss.str();

                usbItemDesc += ", 0x" + vendorIdHex + ", 0x" + productIdHex;
                std::cout << usbItemDesc << std::endl;
            }
        }
    }

    
    
}


void ListenerAsync() 
{
    while (_bAsyncListening && Connected()) {
        std::this_thread::sleep_for(std::chrono::milliseconds(500));

        if (!_bAsyncListening)
            break;

        std::lock_guard<std::mutex> lock(_mutex);

        
        int iBytes = BytesAvailable();
        byte* pBuf = nullptr; 

        if (!_bAsyncListening)
            break;

        if (iBytes > 0) {
           
            pBuf = new byte[iBytes];
            Read(pBuf, iBytes);

            if (!_bAsyncListening)
                break;

            std::string str(reinterpret_cast<char*>(pBuf), iBytes);
            currentText += str;
            std::cout << std::endl;
            std::cout << std::endl;
            std::cout << "Response:";
            std::cout << currentText << std::endl;

            delete[] pBuf;
        }
        else {
            std::this_thread::sleep_for(std::chrono::milliseconds(10));
        }
    }

}




void RunAsyncListen() 
{

    if (_bAsyncListening) {
        std::cout << "---Deactivate Listener" << std::endl;
        _bAsyncListening = false;
        if (listenerThread_.joinable()) {
            listenerThread_.join();
        }
    }
    else {
        if (!Connected()) {
            std::cerr << "Connect first. Can't listen without a valid open/active connection." << std::endl;
            return;
        }
        std::cout << "Listening....." << std::endl;
        _bAsyncListening = true;
        listenerThread_ = std::thread(ListenerAsync);
        listenerThread_.detach();
        std::this_thread::sleep_for(std::chrono::seconds(1));
    }

}



int main()
{
    
    loadListOfUsbPrinters();

    
    
    // USB
    if (devices != nullptr)
        UsbConnect(devices[0]); // 直接調用函數
    else
    {
        std::cerr << "Failed to call UsbConnect API" << std::endl;
        return 1;
    }
    
    
   
    // NET
    //TcpConnect((char*)"10.100.15.210", 9100); // 直接調用函數
    //TcpConnect((char*)"192.168.50.191", 9100); // 直接調用函數
    //TcpConnect((char*)"fe80::208:96ff:fe40:9b04%en0", 9100); // Link Local IPv6 Address
    //TcpConnect((char*)"2001:b030:2219:c40:208:96ff:fe40:9b04", 9100); // Global Unicast IPv6 Address
    
    
    //nc 2001:b030:2219:c40:208:96ff:fe40:9b04%en0 9100
    //LF 236
    //netstat -an | grep 9100 | grep TIME_WAIT
    //sudo lsof -i :9100
    //sudo sysctl -w net.inet.tcp.msl=1000
    
    
    //*******************每次換IP連不上時，可以試試以下指令清除 route & ndp
    //sudo route -n flush
    //sudo ndp -an | awk '{print $1}' | xargs -I {} sudo ndp -d {}
    

    Open(); // 直接調用函數

    if (Connected())
    {
        std::string content;

        
        // Print Job
        content += "SIZE 3,2\r\n";
        content += "GAP 0 mm, 0 mm\r\n";
        content += "DIRECTION 1\r\n";
        content += "CLS\r\n";
        content += "TEXT 10, 30, \"3\", 0, 1, 1, \"123456\"\r\n";
        content += "BARCODE 10, 100, \"EAN13\", 80, 1, 0, 2, 4, \"123456789012\"\r\n";
        content += "TEXT 10, 70, \"4\", 0, 1, 1, \"TEST PRINTOUT\"\r\n";
        content += "PRINT 1, 1\r\n";
        
        
        /*
        // PGL
        content += "!PTX_SETUP\r\n";
        content += "PRINTJOB-START;1234\r\n";
        content += "PTX_END\r\n";

        content += "~NORMAL\r\n";

        content += "~CREATE;C39;72\r\n";
        content += "SCALE;DOT\r\n";
        content += "PAGE;30;40\r\n";
        content += "ALPHA\r\n";
        content += "C10;1;37;0;0;@HELLO@\r\n";
        content += "C16;54;37;0;0;@*World*@\r\n";
        content += "STOP\r\n";
        content += "BARCODE\r\n";
        content += "C128C;XRD3:3:6:6:9:9:12:12;H6;10;64\r\n";
        content += "@World@\r\n";
        content += "STOP\r\n";
        content += "END\r\n";
        content += "~EXECUTE;C39\r\n";
        content += "~NORMAL\r\n";

        content += "!PTX_SETUP\r\n";
        content += "PRINTJOB-END;1234\r\n";
        content += "PTX_END\r\n";
        // Print Job
        */
        
        
        //AsyncListen
        /*
        RunAsyncListen();
        content += "A$=\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\"\r\n";
        content += "OUT A$\r\n";
        */
        //AsyncListen
    
        
        
        std::cout << std::endl;
        std::cout << "Send to Printer:" << std::endl;
        std::cout << content;
        const char* pStr = content.c_str();
        Write((byte*)pStr, (int)strlen(pStr)); // 直接調用函數
        
        
        
        /*
        // WriteAndWaitForResponse
        content += "FEED 100\r\n";
        content += "OUT \"12345678\"\r\n";
        std::cout << std::endl;
        std::cout << "Send to Printer:" << std::endl;
        std::cout << content;
        const char* pStr = content.c_str();
        byte* pResponse = WriteAndWaitForResponse((byte*)pStr, static_cast<int>(content.size()), 1000, 500, (char*)"\r\n"); // 直接調用函數
        
        
        if (pResponse == nullptr)
        {
            std::cerr << "Failed to Respond" << std::endl;
            Close();
            return 1;
        }
            
            
        std::string str(reinterpret_cast<char*>(pResponse), strlen(reinterpret_cast<char*>(pResponse)));
        std::cout << std::endl;
        std::cout << std::endl;
        std::cout << "Response:";
        std::cout << str << std::endl;
        */
        
        
    }
    else
    {
        std::cerr << "Failed to Connect Printer" << std::endl;
        return 1;
    }

    if (devices != nullptr)
        delete[] devices;

    int userInput;

    // 循環等待用戶輸入，直到用戶輸入0為止
    do {
        std::cout << std::endl;
        std::cout << "Press 0 to exit";
        std::cout << std::endl;
        std::cin >> userInput;
    } while (userInput != 0);

    std::cout << std::endl;
    std::cout << "Program exit" << std::endl;
    std::cout << std::endl;

    _bAsyncListening = false;

    Close(); // 直接調用函數

    return 0;
    
}



