#include "LabelMakerSDK.h"
#include <cstdio>
#include <iostream>
#include <vector>
#include <tuple>



#define TSPL 0
#define PGL 1


std::string LabelString;

#define NON_USED -1
void SimpleTextLabel(std::string& LabelString)
{
    
    {
        
        
      // TSC
      
      //WindowsFont(30, 0, 0, 0, "Arial", "測試 Windows Font", Brand::TSC, (char*)"BmpWindowsFont.png", COMM_TYP::USB_COMM, nullptr, 0);
      //WindowsFont(30, 0, 0, 0, "Arial", "測試繁體中文功能", Brand::TSC, (char*)"BmpWindowsFont.png", COMM_TYP::USB_COMM, nullptr, 0);
      WindowsFont(30, 0, 0, 0, "Arial", "Test Windows Font", Brand::TSC, (char*)"BmpWindowsFont.png", COMM_TYP::USB_COMM, nullptr, 0);
        

       // PTX
       //WindowsFont(20, 0, 0, 0, "Arial", "測試 Windows Font", Brand::PTX, (char*)"BmpWindowsFont", COMM_TYP::USB_COMM, nullptr, 0);
       //WindowsFont(20, 0, 0, 0, "Arial", "測試繁體中文", Brand::PTX, (char*)"BmpWindowsFont", COMM_TYP::USB_COMM, nullptr, 0);
       //WindowsFont(20, 0, 0, 0, "Arial", "Test Windows Font", Brand::PTX, (char*)"BmpWindowsFont", COMM_TYP::USB_COMM, nullptr, 0);
       
        
      
        
        
        
        CreateLabel(TSPL, "SimpleLabel", 300, ScaleEnum::Inch);
        //CreateLabel(PGL, "SimpleLabel", 300, ScaleEnum::Inch);


        CreateLines(2.5f, (float)1/16, 2.5f, 1.0f, (float)1/32, ScaleEnum::Inch);
        CreateLines(0.12f, 1.0f, 3.88f, 1.0f, (float)1 / 32, ScaleEnum::Inch);
        CreateLines(0.12f, 3.5f, 3.88f, 3.5f, (float)1 / 32, ScaleEnum::Inch);
        CreateBoxs(0.5f, 1.25f, 3.5f, 2.25f, (float)1 / 16, ScaleEnum::Inch);


        // Text
        CreateTexts(2.0, 1.25 + (float)7 / 16, (float)3 / 16, (float)7 / 16, "MY MAGIC", ScaleEnum::Inch, FontSizeUnitsEnum::Ruler,
            (FontStyleEnum)NON_USED, AlignEnum::Center, "93952.sf", RotateEnum::None);
        CreateTexts(2.0, 1.25 + 1.0 - (float)3 / 16, (float)3 / 16, (float)7 / 16, "PRODUCT", ScaleEnum::Inch, FontSizeUnitsEnum::Ruler,
            (FontStyleEnum)NON_USED, AlignEnum::Center, "93952.sf", RotateEnum::None);


        CreateTexts(5.0, 5.0, 2.5, 5.0, "TO:", ScaleEnum::MM, FontSizeUnitsEnum::Ruler,
            FontStyleEnum::Bold, AlignEnum::Default, "92248.sf", RotateEnum::None);
        CreateTexts((2.5 + (float)1 / 16) * 25.4, 5.0, 2.5, 5.0, "FROM:", ScaleEnum::MM, FontSizeUnitsEnum::Ruler,
            FontStyleEnum::Bold, AlignEnum::Default, "92248.sf", RotateEnum::None);

        CreateTexts((2.5 + (float)1/16 + (float)1/8) * 25.4, 17.0, 2.0, 3.0, "Happy Inc.", ScaleEnum::MM, FontSizeUnitsEnum::Percent,
            FontStyleEnum::Italic, AlignEnum::Default, "92500.sf", RotateEnum::None);
        
        
        PictureEx(100, 200, (char*)"BmpWindowsFont.png"); // TSC
        //PictureEx(5, 1, (char*)"BmpWindowsFont"); // PTX
        
       
        

        LabelToString(LabelString);


    }

}

void BcdMaxicodes(std::string& LabelString)
{
    
    {
        enum
        {
            _MaxicodeMsgStructured = 0,
            _MaxicodeMsgStructuredOpenSystemStandard,
            _MaxicodeMsg,

        };

        CreateLabel(PGL, "MaxiBcds", 300, ScaleEnum::Inch);
        //CreateLabel(TSPL, "MaxiBcds", 300, ScaleEnum::Inch);
        CreateMaxicodeBarcodes(_MaxicodeMsgStructured, MaxicodeModeEnum::MODE_2, "902557317", "800", "200", "Maxicode Carrier Standard", "", "", 0.5, 0.5, ScaleEnum::Inch, false, RotateEnum::None);
        CreateMaxicodeBarcodes(_MaxicodeMsg, MaxicodeModeEnum::MODE_4, "", "", "", "Maxicode unstructured", "", "123456789", 0.5, 3.5, ScaleEnum::Inch, false, RotateEnum::None);
        LabelToString(LabelString);

    }


}


void BcdAztec(std::string& LabelString)
{
    
    {

        CreateLabel(TSPL, "AztecBcodes", 300, ScaleEnum::Inch);
        //CreateLabel(PGL, "AztecBcodes", 300, ScaleEnum::Inch);
        CreateAztecBarcodes(0.25, 1.0, "Mr. AirTraveler, seat A, flight 200", ScaleEnum::Inch, (float)0.025, AztecCodeTypeEnum::Default, NON_USED, NON_USED, RotateEnum::None);
        CreateAztecBarcodes(1.5, 1.0, "Mr. AirTraveler, seat A, flight 200", ScaleEnum::Inch, (float)0.025, AztecCodeTypeEnum::FixedErrCorrection, 30, NON_USED, RotateEnum::None);
        CreateAztecBarcodes(0.25, 2.25f, "Mr. AirTraveler, seat A, flight 200", ScaleEnum::Inch, (float)0.025, AztecCodeTypeEnum::Compact, NON_USED, 4, RotateEnum::None);
        CreateAztecBarcodes(0.75, 4.0f, "255", ScaleEnum::Inch, (float)0.025, AztecCodeTypeEnum::Rune, NON_USED, NON_USED, RotateEnum::None);
        LabelToString(LabelString);

    }
}


void BcdQRCode(std::string& LabelString)
{
    
    {

        std::string enText = "Tree in the forest";
        std::string jaText = "森の中の木";

        std::vector<std::tuple<QRCodeManualEncodingEnum, std::string>>* dataManuallyEncoded = nullptr;



        //CreateLabel(PGL, "QRBcodes", 300, ScaleEnum::Inch);
        CreateLabel(TSPL, "QRBcodes", 300, ScaleEnum::Inch);
        CreateQRBarcodes(0.25f, 1.0f, enText, ScaleEnum::Inch, 0.025f, (QRCodeMaskEnum)NON_USED, dataManuallyEncoded,
            (QRCodeErrorCorrectionEnum)NON_USED, (QRCodeModelEnum)NON_USED, RotateEnum::None);
        CreateQRBarcodes(1.5f, 1.0f, enText, ScaleEnum::Inch, 0.025f, QRCodeMaskEnum::Mask_4, dataManuallyEncoded,
            (QRCodeErrorCorrectionEnum)NON_USED, (QRCodeModelEnum)NON_USED, RotateEnum::None);


        if (dataManuallyEncoded == nullptr) {

            dataManuallyEncoded = new std::vector<std::tuple<QRCodeManualEncodingEnum, std::string>>;

            dataManuallyEncoded->push_back(std::make_tuple(QRCodeManualEncodingEnum::Numeric, "12345678"));
            dataManuallyEncoded->push_back(std::make_tuple(QRCodeManualEncodingEnum::AlphaNumeric, " TREE IN THE FOREST "));
            dataManuallyEncoded->push_back(std::make_tuple(QRCodeManualEncodingEnum::AlphaNumeric, "森の中の木"));

            CreateQRBarcodes(1.75f, 3.75f, "", ScaleEnum::Inch, 0.025f, QRCodeMaskEnum::Mask_4, dataManuallyEncoded,
                (QRCodeErrorCorrectionEnum)NON_USED, (QRCodeModelEnum)NON_USED, RotateEnum::None);
        }
        LabelToString(LabelString);

        delete dataManuallyEncoded;


    }
}



void RfidEncode(std::string& LabelString)
{
   
    {
        //CreateLabel(PGL, "RfidLbl", 300, ScaleEnum::Inch);
        CreateLabel(TSPL, "RfidLbl", 300, ScaleEnum::Inch);

        unsigned int a32BitField = 0x11223344;
        unsigned short a16BitField = 0xBEEF;
        std::string a6CharAsciiString = "MyData";

        CreateRfidEncode(a32BitField, a16BitField, a6CharAsciiString, RfidMemBlockEnum::EPC, 0,
            "", "", RfidPasswordTypeEnum::None, "");
        CreateRfidEncode(a32BitField, a16BitField, a6CharAsciiString, RfidMemBlockEnum::User, 2,
            "MyUserData", "0ABCDE0F", RfidPasswordTypeEnum::None, "");



        LabelToString(LabelString);
    }

}



void BcdPdf417(std::string& LabelString)
{
    
    {
        CreateLabel(TSPL, "Pdf417Bcodes", 300, ScaleEnum::Inch);
        //CreateLabel(PGL, "Pdf417Bcodes", 300, ScaleEnum::Inch);

        std::string someText = "The happiness in your life depends on the quality of your thoughts. --Marcus Aurelius";
        std::string someShortText = "PI = 3.1415";
        CreatePdf417Bcodes(0.25, 0.5, someText, ScaleEnum::Inch, 0.015, 0.05, (Pdf417ErrCorrectionEnum)NON_USED, NON_USED, NON_USED, RotateEnum::None);
        CreatePdf417Bcodes(0.25, 1.5, someShortText, ScaleEnum::Inch, 0.015, 0.05, Pdf417ErrCorrectionEnum::LEVEL_0, NON_USED, NON_USED, RotateEnum::None);
        CreatePdf417Bcodes(0.25, 2.0, someShortText, ScaleEnum::Inch, 0.015, 0.05, Pdf417ErrCorrectionEnum::LEVEL_5, NON_USED, NON_USED, RotateEnum::None);
        CreatePdf417Bcodes(0.25, 3.0, someShortText, ScaleEnum::Inch, 0.015, 0.05, (Pdf417ErrCorrectionEnum)NON_USED, 15, NON_USED, RotateEnum::None);
        CreatePdf417Bcodes(0.25, 4.0, someShortText, ScaleEnum::Inch, 0.015, 0.05, (Pdf417ErrCorrectionEnum)NON_USED, NON_USED, 5, RotateEnum::None);
        LabelToString(LabelString);

    }
}



void BcdDataMatrix(std::string& LabelString)
{

    
    {
        CreateLabel(TSPL, "DMatrixBcds", 203, ScaleEnum::Inch);
        //CreateLabel(PGL, "DMatrixBcds", 300, ScaleEnum::Inch);
        CreateDataMatrixBarcodes(0.25, 0.25, "Default DataMatrix", ScaleEnum::Inch, NON_USED, RotateEnum::None, false, "", 0, 0, 0, 0);
        CreateDataMatrixBarcodes(1.25, 0.25, "Rectangular DataMatrix", ScaleEnum::Inch, 0.025, RotateEnum::CounterClockWise, true, "", 0, 0, 0, 0);
        CreateDataMatrixBarcodes(2.25, 0.25, "Line 1 DataMatrix", ScaleEnum::Inch, NON_USED, RotateEnum::None, false, "Line 2 content/r/nLine 3 content", 0x0D, 0x0A, 0, 0);
        CreateDataMatrixBarcodes(1.25, 1.75, "DataMatrix with user defined dimensions", ScaleEnum::Inch, 0.03, RotateEnum::None, true, "", 0, 0, 16, 36);
        LabelToString(LabelString);

    }
}




void Barcode1D(std::string& LabelString)
{
    
    {
        CreateLabel(TSPL, "Barcode1D", 300, ScaleEnum::Inch);
        //CreateLabel(PGL, "Barcode1D", 300, ScaleEnum::Inch);
        CreateBarcode1D(0.5, 1.0 + 1.5 + (float)1 / 4 + 1.2, "Code 128", ScaleEnum::Inch, 0.015, 0.015 * 4.1, 1.2, BarcodeTypeEnum_1D::Code_128,
            true, RotateEnum::None, false);
        CreateBarcode1D(0.5, 3.5 - (float)1 / 8 - 0.6, "CODE 93", ScaleEnum::Inch, 0.025, 0.025 * 4.1, 0.6, BarcodeTypeEnum_1D::Code_93,
            true, RotateEnum::None, false);
        LabelToString(LabelString);
    }
}



int main()
{

    LabelString.clear();
    SimpleTextLabel(LabelString);
    //BcdMaxicodes(LabelString);
    //BcdAztec(LabelString);
    //BcdQRCode(LabelString);
    //RfidEncode(LabelString);
    //BcdPdf417(LabelString);
    //BcdDataMatrix(LabelString);
    //Barcode1D(LabelString);

    if (!LabelString.empty()) {

        std::cout << LabelString << std::endl;



    }


    CloseLabel();


    LabelString.clear();


    return 0;
}

