#include "CommSDK.h"
#include "JsonSDK.h"
#include <cstdio>
#include <iostream>
#include <cstring>
#include <vector>
#include <string>
#include <sstream>
#include <thread>
#include <chrono>
#include <mutex>



#define TSC_USB_VID 0x1203
#define PTX_USB_VID 0x14ae


#define _USB_COMM 0
#define _TCP_COMM 1

typedef unsigned char byte;


Tuple_c* devices = nullptr;



#define MAX_INPUT_MSG_CAPACITY 20
#define MAX_WAIT_TIME_SECS 5



bool _bAsyncListening = false;
bool _bConnected = false;
std::mutex _mutex;
std::thread listenerThread_;
std::string currentText;


void loadListOfUsbPrinters() {

    int count = 0;

    GetAvailableDevices(&devices, &count);
    std::cout << "Number of devices: " << count << std::endl;

    if (count > 0) {
        bool fDevFound = false;
        for (int i = 0; i < count; i++) {
            std::cout << "Device " << i << ": VendorID= 0x" << std::hex << devices[i].Item1
                << " ProductID= 0x" << devices[i].Item2 << std::endl;

            std::string usbItemDesc;
            if (TSC_USB_VID == devices[i].Item1) {
                usbItemDesc = "TSC";
                fDevFound = true;
            }
            else if (PTX_USB_VID == devices[i].Item2) {
                usbItemDesc = "Printronix";
                fDevFound = true;
            }

           
            if (fDevFound) {
                std::ostringstream oss;
                oss << std::hex << devices[i].Item1;
                std::string vendorIdHex = oss.str();
                oss.str("");  // 清除 oss 的內容以供重用
                oss << std::hex << devices[i].Item2;
                std::string productIdHex = oss.str();

                usbItemDesc += ", 0x" + vendorIdHex + ", 0x" + productIdHex;
                std::cout << usbItemDesc << std::endl;
            }
        }
    }



}


void ListenerAsync()
{
    while (_bAsyncListening && Connected()) {
        std::this_thread::sleep_for(std::chrono::milliseconds(50));

        if (!_bAsyncListening)
            break;

        std::lock_guard<std::mutex> lock(_mutex);


        int iBytes;
        iBytes = BytesAvailable();
       

        if (!_bAsyncListening)
            break;

        int iUnreadMsgCount = MessengerUnreadMsgCount();
        if (iUnreadMsgCount > 0) {

            const char* strNextMsg = NULL;
            MessengerReadNextMsg(&strNextMsg);

            if (!_bAsyncListening)
                break;

            if (strNextMsg != NULL)
            {
                int length = (int)strlen(strNextMsg);
                std::string str(reinterpret_cast<const char*>(strNextMsg), length);
                currentText += str;
                std::cout << std::endl;
                std::cout << std::endl;
                std::cout << "Response:";
                std::cout << currentText << std::endl;
                free((void*)strNextMsg);

            }


           
        }
        else {
            std::this_thread::sleep_for(std::chrono::milliseconds(10));
        }
    }

}




void RunAsyncListen()
{

    if (_bAsyncListening) {
        std::cout << "---Deactivate Listener" << std::endl;
        _bAsyncListening = false;
        if (listenerThread_.joinable()) {
            listenerThread_.join();
        }
    }
    else {
        if (!Connected()) {
            std::cerr << "Connect first. Can't listen without a valid open/active connection." << std::endl;
            return;
        }
        std::cout << "Listening....." << std::endl;
        _bAsyncListening = true;
        listenerThread_ = std::thread(ListenerAsync);
        listenerThread_.detach();
        std::this_thread::sleep_for(std::chrono::seconds(1));
    }

}



int main()
{
    
    

    /*
    // USB
    loadListOfUsbPrinters();
    if (devices != nullptr)
        UsbConnect(devices[0]);
    else
    {
        std::cout << "Failed to call UsbConnect API!" << std::endl;
        return 1;
    }
    */
    
    

    // NET
    TcpConnect((char*)"10.0.10.171", 3007);


    Open();

    COMM_TYP commTyp = (COMM_TYP)_TCP_COMM;
    //COMM_TYP commTyp = (COMM_TYP)_USB_COMM;
    void* commPtr = NULL;

    if (Connected())
    {
        GetComm(commPtr);
        MessengerGet(commPtr, commTyp, MAX_INPUT_MSG_CAPACITY, false);
        //MessengerGet(commPtr, commTyp, MAX_INPUT_MSG_CAPACITY, true);

        RunAsyncListen();

        if (commPtr != NULL)
        {
            
            char* pCmdStr = (char*)"Cfg.Item";

            std::string content;
            content += "{\r\n";
            content += "\"Speed\" : null,\r\n";
            //content += "\"ODV.Symbol\" : null,\r\n";
            content += "\"Label.Sensor\":null\r\n";
            content += "}\r\n";
           

            std::cout << std::endl;
            std::cout << "Send to Printer:" << std::endl;
            std::cout << "\"Command\": \"Cfg.Item\"" << std::endl;
            std::cout << "\"Content\":" << std::endl;
            std::cout << content;
            const char* pContentStr = content.c_str();
            
            _bAsyncListening = false;
            if (_bAsyncListening)
            {
                MessengerSendMsg(pCmdStr, (char*)pContentStr);
            }
            else
            {
                const char* strResponse = NULL;
                MessengerSendMsgAndWaitForResponse(pCmdStr, (char*)pContentStr, MAX_WAIT_TIME_SECS, &strResponse);
                if (strResponse != NULL)
                {
                    int length = (int)strlen(strResponse);
                    std::string str(reinterpret_cast<const char*>(strResponse), length);
                    currentText += str;
                    std::cout << std::endl;
                    std::cout << std::endl;
                    std::cout << "Response:";
                    std::cout << currentText << std::endl;
                    free((void*)strResponse);
                    
                }

           }
           
            
            
           /*
           //char* values = GetPrinterAllValues(commPtr, commTyp, false);
           char* values = GetPrinterAllValues(commPtr, commTyp, true);
           if (values != NULL) {
               std::cout << values << std::endl;
               FreeString(values);
           }
           */

           
           /*
           const std::string& key = "Ethernet.MAC";
           char* value = GetPrinterValue(commPtr, commTyp, false, key.c_str());
           if (value) {
               std::cout << value << std::endl;
               FreeString(value);
           }
           */
           

           /*
           std::vector<std::string> keys = { "Ethernet.IP", "Ethernet.MAC", "Ethernet.Speed" };
           char* values = GetPrinterValues(commPtr, commTyp, false, keys);

           if (values != NULL) {
               std::cout << values << std::endl;
               FreeString(values);
           }
           */
           
           


           /*
           const std::string _key = "Ethernet.Speed";
           const std::string _value = "eAutomatic";
           bool result = SetPrinterValue(commPtr, commTyp, false, _key.c_str(), _value.c_str());
           if (result) {
               std::cout << "Successfully set " << _key << " to " << _value << std::endl;
           }
           else {
               std::cerr << "Failed to set " << _key << std::endl;
           }
           */



           /*
           std::map<std::string, std::string> keyValues = {
              {"Ethernet.Speed", "eAutomatic"},
              {"Image.Width-in", "3.5"}
             
           };
           bool _result = SetPrinterValues(commPtr, commTyp, false, &keyValues);
           if (_result) {
               std::cout << "Successfully set values." << std::endl;
           }
           else {
               std::cerr << "Failed to set values." << std::endl;
           }
           */

           
           /*
           std::string key_ = "Speed.Print-mmps";
           //std::string key_ = "BT.PairMethod";
           char* Properties = GetPrinterProperties(commPtr, commTyp, false, key_.c_str());
           if (Properties != NULL) {
               std::cout << Properties << std::endl;
               FreeString(Properties);
           }
           */




           
           /*
           const char* keyProps[] = { "Speed", "Label.Sensor" };
           size_t keyCount = sizeof(keyProps) / sizeof(keyProps[0]);
           char* PropertiesEx = GetPrinterPropertiesEx(commPtr, commTyp, false, keyProps, keyCount);
           if (PropertiesEx != NULL) {
               std::cout << PropertiesEx << std::endl;
               FreeString(PropertiesEx);
           }
           */
           
           



           /*
           char* AllProperties = GetPrinterAllProperties(commPtr, commTyp, false);
           //char* AllProperties = GetPrinterAllProperties(commPtr, commTyp, true);
           if (AllProperties != NULL) {
               std::cout << AllProperties << std::endl;
               FreeString(AllProperties);
           }
           */
           
           


           
           /*
           char* pConfig = GetPrinterConfig(commPtr, commTyp, false, 2);
           if (pConfig != NULL) {
               std::cout << pConfig << std::endl;
           }
           bool result = SetPrinterConfig(commPtr, commTyp, false, pConfig);
           if (result) {
               std::cout << "Successfully set " << std::endl;
           }
           else {
               std::cerr << "Failed to set " << std::endl;
           }
           if (pConfig != NULL)
               FreeString(pConfig);
           */
           
           


           /*
           char* pAllConfig = GetPrinterAllConfig(commPtr, commTyp, false);
           if (pAllConfig != NULL) {
               
               std::cout << pAllConfig << std::endl;
               FreeString(pAllConfig);

           }
           */




        }



    }
    else
    {
        std::cout << "Failed to Connect Printer " << std::endl;
        return 1;
    }

    if (devices != nullptr)
        delete[] devices;

    int userInput;

    // 循環等待用戶輸入，直到用戶輸入0為止
    do {

        std::cout << std::endl;
        std::cout << std::endl;
        std::cout << "Press 0 to exit";
        std::cout << std::endl;
        std::cin >> userInput;
    } while (userInput != 0);

    // 使用者輸入0後程式結束
    std::cout << std::endl;
    std::cout << "Program exit" << std::endl;
    std::cout << std::endl;

    _bAsyncListening = false;


   

    MessengerRelease();
    Close();
   
    if (listenerThread_.joinable()) {
        listenerThread_.join();
    }


    return 0;

}


