#pragma once
#include <cstdlib> // for malloc
#include <cstdint> // for uint64_t

enum class Brand {
    TSC = 1,
    PTX
};

#include <string>


typedef unsigned char byte;


enum COMM_IDX
{
    USB_COMM = 0,
    TCP_COMM,
    BT_COMM
};


// 定義 Tuple 的結構
struct Tuple_c {
    short Item1;
    short Item2;
};


enum DescriptorPortType {
    DATA,
    MGMT,
    STATUS
};






// Define the function prototypes
extern "C" {

    int BytesAvailable();
    bool Connected();
    const char* Descriptor();
    const char* DescriptorValidate(const char* descriptorHint, DescriptorPortType portTypeHint);
    void Read(byte* buffer, int size);
    void Write(byte* dataOut, int iDataSize);
    byte* WriteAndWaitForResponse(byte* dataOut, int iDataSize, int responseStartTimeOut, int responseEndTimeOut, char* completetionToken);
    short GetV_ID();
    short GetP_ID();
    void Close();
    void Open();
    void IpAddress(const char** ipAddress);
    int Port();
    void SendPrintFile(char* ipAddress, char* fileName);
    void SendPrintString(char* ipAddress, char* data, int iDataSize);
    int GetAvailableDevices(Tuple_c** devices, int* count);
    void UsbConnect(Tuple_c device);
    void TcpConnect(char* ipAddress, int port);
    void TcpConnectEx(char* descriptor);
    void BtConnect(uint64_t macAddress);
    void GetComm(void*& ptrComm);

    //bool WindowsFont(int x, int y, int fontheight, int rotation, int fontstyle,
    //                 int fontunderline, char* szFaceName, void* content, bool isUnicode, Brand brand);
    bool WindowsFont(int x, int y, int fontheight, int rotation, int fontstyle, int fontunderline, const std::string& fontName, const std::string& content, Brand brand);

}
