#pragma once
#include <vector>
#include <string>


// IPv6
#include <iostream>
#include <thread>
#include <mutex>
#include <sstream>
#include <atomic>
#include <chrono>
#include <cstdlib>


enum class Brand {
    ALL,
    TSC,
    PTX
};


// Define the function prototypes
extern "C" {

    std::vector<std::string>* GetPrinterList(Brand brand, int responseTimeoutMs);
    void FreePrinterList(std::vector<std::string>* pList);


    // IPv6
    std::vector<std::string>* GetPrinterList_IPv6(std::string PREFIX, std::string INTERFACE_NAME, int responseTimeoutMs);
    void FreePrinterList_IPv6(std::vector<std::string>* pList);



}
