#pragma once
#include <cstdlib> // for malloc
#include <cstdint> // for uint64_t
#include <string>
#include <cstring>


#include <vector>
#include <tuple>


enum class ScaleEnum {
    Dot,
    MM,
    Inch
};


enum class FontSizeUnitsEnum {
    Ruler,
    Points,
    Percent
};


enum class FontStyleEnum {
    Normal = 0,
    Bold = 1,
    Italic = 2
};


enum class AlignEnum
{
    Default,
    Left,
    Center,
    Right
};


enum class RotateEnum
{
    None,
    ClockWise,
    CounterClockWise,
    Inverted
};


enum class BarcodeTypeEnum_1D
{
    NOT_DEFINED,
    Code_93,
    Code_39,
    Code_128,
    EAN13,
    EAN8,
    UPCA,
    I2of5,
    CODABAR
};


enum class MaxicodeModeEnum {
    MODE_2 = 2,
    MODE_3 = 3,
    MODE_4 = 4
};


enum class Pdf417ErrCorrectionEnum
{
    LEVEL_0 = 0,
    LEVEL_1,
    LEVEL_2,
    LEVEL_3,
    LEVEL_4,
    LEVEL_5,
    LEVEL_6,
    LEVEL_7,
    LEVEL_8
};


enum class AztecCodeTypeEnum {
    Default,
    FixedErrCorrection,
    Compact,
    Full,
    Rune
};


enum class QRCodeMaskEnum {
    Mask_0 = 0,
    Mask_1,
    Mask_2,
    Mask_3,
    Mask_4,
    Mask_5,
    Mask_6,
    Mask_7,
    Mask_8
};

enum class QRCodeModelEnum {
    MODEL_1,
    MODEL_2
};

enum class QRCodeErrorCorrectionEnum {
    EC_7,
    EC_15,
    EC_25,
    EC_30
};

enum class QRCodeManualEncodingEnum {
    Numeric,
    AlphaNumeric,
    Binary,
    Kanji
};


enum class RfidPasswordTypeEnum {
    None,
    Lock,
    PermaLock,
    Unlock,
    PermaUnlock
};

enum class RfidMemBlockEnum {
    InvalidMemBlock,
    EPC,
    TID,
    User,
    AccessCode,
    KillCode,
    PC,
    Reserve
};



enum class Brand {
    TSC = 1,
    PTX
};


enum COMM_TYP
{
    USB_COMM = 0,
    TCP_COMM,
   
};


extern "C" {

    void CreateLabel(int iPrintLanguageTyp, std::string LabelName, float dotsPerUnit, ScaleEnum unit);

    void* CreateTexts(float x_start, float y_start, float fontsize_x, float fontsize_y, std::string data, ScaleEnum scale,
        FontSizeUnitsEnum FontSizeUnit, FontStyleEnum FontStyle, AlignEnum Alignment, std::string fontName, RotateEnum rotation);

    void* CreateBarcode1D(float start_x, float start_y, std::string content, ScaleEnum scale, float narrowBar, float wideBar,
        float Height, BarcodeTypeEnum_1D BcdTyp, bool PrintHumanReadable, RotateEnum rotation, bool PdfLocTop);


    void* PictureEx(int x, int y, std::string strFilePath);


    bool WindowsFont(int fontheight, int rotation, int fontstyle, int fontunderline, const std::string& fontName, const std::string& content, Brand brand, char* szFilePath, COMM_TYP commTyp, char* ipAddress, int port);


    void* CreateLines(float start_x, float start_y, float end_x, float end_y, float lineThickness, ScaleEnum scale);

    void* CreateBoxs(float start_x, float start_y, float end_x, float end_y, float lineThickness, ScaleEnum scale);


    void* CreateMaxicodeBarcodes(int iMaxicodeTyp, MaxicodeModeEnum mode, std::string postalCode, std::string countryCode, std::string serviceClass,
        std::string remainingMsg, std::string year, std::string primaryMsg, float start_x, float start_y, ScaleEnum scale, bool ZipperPattern, RotateEnum rotation);

    void* CreatePdf417Bcodes(float start_x, float start_y, std::string content, ScaleEnum scale, float xdim, float ydim,
        Pdf417ErrCorrectionEnum ErrorCorrection, int row, int col, RotateEnum rotation);


    void* CreateAztecBarcodes(float start_x, float start_y, std::string content, ScaleEnum scale, float xdim,
        AztecCodeTypeEnum CodeType, int iFixedErrCorrection, int iLayers, RotateEnum rotation);


    void* CreateDataMatrixBarcodes(float start_x, float start_y, std::string content, ScaleEnum scale, float xdim,
        RotateEnum Rotation, bool UseRectangle, std::string MatrixMultiLine, char CtrlChar1, char CtrlChar2, int row, int col);


    void* CreateQRBarcodes(float start_x, float start_y, std::string content, ScaleEnum scale, float xdim,
        QRCodeMaskEnum Mask, std::vector<std::tuple<QRCodeManualEncodingEnum, std::string>>* dataManuallyEncoded,
        QRCodeErrorCorrectionEnum errEnum, QRCodeModelEnum modelEnum, RotateEnum rotation);

    void* CreateRfidEncode(unsigned int a32BitField, unsigned int a16BitField, std::string a6CharAsciiString,
        RfidMemBlockEnum MemBlock, int iOffsetFromStart, std::string _10BytesUserData, std::string _4BytesHexUserData,
        RfidPasswordTypeEnum PasswordEnum, std::string Password);

    void LabelToString(std::string& str);
    void CloseLabel();


}
