#import <Foundation/Foundation.h>
#import "mgmt.h"
#import "label_maker.h"
#import "monitor.h"
#import "discovery.h"
//Please remark the define or not to test.
//#define Label_Maker_TSPL_Case
//#define Mgmt_Case
//#define Label_Maker_PGL_Case
#define Monitor
//#define Printer_Discovery

@import UniPRT;


#ifdef Label_Maker_TSPL_Case
int main(int argc, const char * argv[]) {
    @autoreleasepool {
        Label *picture_and_windowsfont_test = TsplPictureTest();
        NSLog(@"Picture and Windows Font test: \r\n%@", picture_and_windowsfont_test);
        
        Label *pictureTest = PictureTest();
        NSLog(@"Picture test: \r\n%@", pictureTest);

        Label *label = BcdPdf417();
        NSLog(@"Label: \r\n%@", label);

        Label *simpleLabel = SimpleTextLabel(@"Mr. Milky Cheese", @"123 No Way Road");
        NSLog(@"SimpleTextLabel: \r\n%@", simpleLabel);

        Label *rfidLabel = RfidEncode();
        NSLog(@"RfidLabel: \r\n%@", rfidLabel);

        Label *maxicodesLabel = BcdMaxicodes();
        NSLog(@"MaxicodesLabel: \r\n%@", maxicodesLabel);
        
        Label *dataMatrixLabel = BcdDataMatrix();
        NSLog(@"DataMatrixLabel: \r\n%@", dataMatrixLabel);
        
        Label *aztecLabel = BcdAztec();
        NSLog(@"AztecLabel: \r\n%@", aztecLabel);
        Label *qrCodeLabel = BcdQRCode();
        NSLog(@"QRCodeLabel: \r\n%@", qrCodeLabel);
        
    }
    return 0;
}


//PGL
#elif defined(Label_Maker_PGL_Case)




int main(int argc, const char * argv[]) {
    @autoreleasepool {
        NSLog(@"%@", PglRfidEncode());
        NSLog(@"%@", PglBcdPdf417());
        NSLog(@"%@", PglBcdAztec());
        NSLog(@"%@", PglBcdQRCode());
        NSLog(@"%@", PglBcdDataMatrix());
        NSLog(@"%@", PglBcdMaxicodes());
        NSLog(@"%@", PglSimpleLabel(@"Mr. Einstein", @"123 Relativity Road"));
        NSLog(@"%@", PglRuleredLabel(4.0f, 6.0f, YES, 1.0f/8.0f));
        NSLog(@"%@", PglRuleredLabel(4.0f * 25.4f, 6.0f * 25.4f, NO, 1.0f/8.0f));
        NSLog(@"%@", PglPictureTest());
    }
    return 0;
}

#elif defined(Mgmt_Case)

int main(int argc, const char * argv[]) {
    @autoreleasepool {
//        bt_mgmt(<#NSString *address#>)
        tcp_mgmt(@"192.168.101.74");
//        ble_mgmt()
//        usb_mgmt(<#NSString *address#>)
    }
    return 0;
}

#elif defined(Monitor)
int main(int argc, const char * argv[]) {
    @autoreleasepool {
        rfid_moniter(argc, argv, @"10.0.10.185");
        //printer_monitor(argc, argv, @"10.0.10.175");
        //odv_moniter(argc, argv, @"10.0.10.175");
    }
    return 0;
}

#elif defined(Printer_Discovery)
int main(int argc, const char * argv[]) {
    @autoreleasepool {
        discovery(argc, argv);
    }
    return 0;
}

#endif
        
