@import UniPRT;
#import "mgmt.h"
#import <Foundation/Foundation.h>

#define MAX_INPUT_MSG_CAPACITY 20
#define MAX_WAIT_TIME_SECS 15

void usb_mgmt(void){
    UsbConnection *usbConnection = [[UsbConnection alloc] init];
    NSArray<NSArray *> *devices = [usbConnection availableDevices];

    CommType commTypeUsb = USB_COMM;

    NSLog(@"Available USB devices: %@", devices);

    NSArray *deviceInfo = devices[0];

    NSString *vendorId = deviceInfo[0];
    NSString *productId = deviceInfo[1]; 
    UsbComm *usbComm = [[UsbComm alloc] initWithVendorId:vendorId productId:productId];
    [usbComm open];

    JsonComm *jsonComm = [[JsonComm alloc] initWithComm:usbComm commType:commTypeUsb];
    jsonComm.usingDataPort = YES;
    
        
    //Initialize SettingsReadWrite with JsonComm
    SettingsReadWrite *settingReadWrite = [[SettingsReadWrite alloc] initWithUsbComm:usbComm usingDataPort:YES];

    // Example usage: Get values for specific keys
    NSArray<NSString *> *partOfKeys = @[@"BT.PairMethod", @"BT.ConnectName", @"System.KeyboardCC", @"System.Wireless.MenuJob-d"];
    NSDictionary<NSString *, NSString *> *partOfValue = [settingReadWrite getValuesForKeys:partOfKeys timeout:10000];
    NSLog(@"Get keys::::%@", partOfValue);

    // Get all properties
    NSDictionary<NSString *, Setting *> *allProperties = [settingReadWrite getAllPropertiesWithTimeout:20000];
    NSLog(@"All properties:::%@", allProperties);

    //get all values
    NSDictionary<NSString *, NSString *> *allvalues = [settingReadWrite getAllValuesWithTimeout:20000];
    NSLog(@"All Values:::: %@", allvalues);


    // Get properties for specific keys
    NSDictionary<NSString *, Setting *> *propkeys = [settingReadWrite getPropertiesForKeys:partOfKeys timeout:10000];
    NSLog(@"Prop keys:::%@", propkeys);

    // Get a specific property
    Setting *propkey = [settingReadWrite getPropertiesForKey:@"BT.PairMethod" timeout:5000];
    NSLog(@"Property key:::%@", propkey);
    
    // Initialize JsonConfig with JsonComm for configuration handling
    JsonConfig *jsonconfig = [[JsonConfig alloc] initWithJsonComm:jsonComm];
    
    // Get all configurations
    NSArray<Config *> *allConfig = [jsonconfig getAllConfigWithTimeout:10000];
    NSLog(@"All config:::\r\n%@", allConfig);
    
    CFRunLoopRun();  // Keeps the application running
    
}

void bt_mgmt(NSString *address){
    NSString *btPort = address;
    BtComm *btComm = [[BtComm alloc] initWithDeviceAddress:btPort];
    [btComm open];
    CommType commTypeBt = BT_COMM;
    
    JsonComm *jsonComm = [[JsonComm alloc] initWithComm:btComm commType:commTypeBt];
    
    //Initialize SettingsReadWrite with JsonComm
    SettingsReadWrite *settingReadWrite = [[SettingsReadWrite alloc] initWithBtComm:btComm usingDataPort:YES];

    // Example usage: Get values for specific keys
    NSArray<NSString *> *partOfKeys = @[@"BT.PairMethod", @"BT.ConnectName", @"System.KeyboardCC", @"System.Wireless.MenuJob-d"];
    NSDictionary<NSString *, NSString *> *partOfValue = [settingReadWrite getValuesForKeys:partOfKeys timeout:10000];
    NSLog(@"Get keys::::%@", partOfValue);

    // Get all properties
    NSDictionary<NSString *, Setting *> *allProperties = [settingReadWrite getAllPropertiesWithTimeout:20000];
    NSLog(@"All properties:::%@", allProperties);

    //get all values
    NSDictionary<NSString *, NSString *> *allvalues = [settingReadWrite getAllValuesWithTimeout:20000];
    NSLog(@"All Values:::: %@", allvalues);


    // Get properties for specific keys
    NSDictionary<NSString *, Setting *> *propkeys = [settingReadWrite getPropertiesForKeys:partOfKeys timeout:10000];
    NSLog(@"Prop keys:::%@", propkeys);

    // Get a specific property
    Setting *propkey = [settingReadWrite getPropertiesForKey:@"BT.PairMethod" timeout:5000];
    NSLog(@"Property key:::%@", propkey);
    
    // Initialize JsonConfig with JsonComm for configuration handling
    JsonConfig *jsonconfig = [[JsonConfig alloc] initWithJsonComm:jsonComm];
    
    // Get all configurations
    NSArray<Config *> *allConfig = [jsonconfig getAllConfigWithTimeout:10000];
    NSLog(@"All config:::\r\n%@", allConfig);
    
    CFRunLoopRun();  // Keeps the application running
}

void ble_mgmt(NSString *address){
    BleComm *bleComm = [[BleComm alloc] init];

    // 🔧 設定特徵值準備好後的 callback（在 SDK 觸發）
    __block BOOL characteristicsReady = NO;
    bleComm.characteristicsReadyCallback = ^{
        NSLog(@"🎯 Characteristics ready callback triggered.");
        characteristicsReady = YES;
    };

    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        // 等 BLE ready
        while (bleComm.centralManager.state != CBManagerStatePoweredOn) {
            NSLog(@"⏳ 等待 BLE 啟動中...");
            [NSThread sleepForTimeInterval:0.1];
        }

        NSLog(@"✅ BLE 已啟動");

        // 掃描設備
        [bleComm availableDevices];
        [NSThread sleepForTimeInterval:10.0]; // 等 delegate 掃到裝置

        NSArray<NSString *> *devices_list = bleComm.discoveredDevices;
        NSString *targetDeviceName = @"PS-233A6C";
        NSString *deviceNameToOpen = nil;

        for (NSString *name in devices_list) {
            if ([name isEqualToString:targetDeviceName]) {
                deviceNameToOpen = name;
                break;
            }
        }

        if (!deviceNameToOpen) {
            NSLog(@"❌ Target BLE device (%@) not found.", targetDeviceName);
            return;
        }

        [bleComm open:deviceNameToOpen];
        NSLog(@"✅ Attempting to connect to BLE device: %@", deviceNameToOpen);

        // ⏳ 等待 characteristicsReadyCallback 觸發
        int waitCounter = 0;
        while (!characteristicsReady && waitCounter++ < 100) {
            [NSThread sleepForTimeInterval:0.1];
        }

        if (![bleComm isConnected]) {
            NSLog(@"❌ Failed to open BLE device: %@", deviceNameToOpen);
            return;
        }

        NSLog(@"✅ Connected to BLE device: %@", deviceNameToOpen);
        CommType commTypeBle = BLE_COMM;
        JsonComm *jsonComm = [[JsonComm alloc] initWithComm:bleComm commType:commTypeBle];
        jsonComm.usingDataPort = YES;

//        Initialize SettingsReadWrite with JsonComm
        SettingsReadWrite *settingReadWrite = [[SettingsReadWrite alloc] initWithBleComm:bleComm usingDataPort:YES];

        // Example usage: Get values for specific keys
        NSArray<NSString *> *partOfKeys = @[@"BT.PairMethod", @"BT.ConnectName"];
        NSDictionary<NSString *, NSString *> *partOfValue = [settingReadWrite getValuesForKeys:partOfKeys timeout:10000];
        NSLog(@"Get keys::::%@", partOfValue);\

        //Get all properties
        NSDictionary<NSString *, Setting *> *allProperties = [settingReadWrite getAllPropertiesWithTimeout:45000];
        NSLog(@"All properties:::%@", allProperties);

        //get all values
        NSDictionary<NSString *, NSString *> *allvalues = [settingReadWrite getAllValuesWithTimeout:25000];
        NSLog(@"All Values:::: %@", allvalues);

        // Get properties for specific keys
        NSDictionary<NSString *, Setting *> *propkeys = [settingReadWrite getPropertiesForKeys:partOfKeys timeout:10000];
        NSLog(@"Prop keys:::%@", propkeys);

        // Get a specific property
        Setting *propkey = [settingReadWrite getPropertiesForKey:@"BT.PairMethod" timeout:10000];
        NSLog(@"Property key:::%@", propkey);

        // Initialize JsonConfig with JsonComm for configuration handling
        JsonConfig *jsonconfig = [[JsonConfig alloc] initWithJsonComm:jsonComm];

        // Get all configurations
        NSArray<Config *> *allConfig = [jsonconfig getAllConfigWithTimeout:400000];
        NSLog(@"All config:::\r\n%@", allConfig);
    });
}

void tcp_mgmt(NSString *address){
    NSString *ip = address;
    CommType commType = TCP_COMM;
    
    TcpComm *tcpComm = [[TcpComm alloc] initWithIPAddress:ip port:DEFAULT_MGMT_PORT];
    [tcpComm open];
    
    JsonComm *jsonComm = [[JsonComm alloc] initWithComm:tcpComm commType:commType];
    
    //Initialize SettingsReadWrite with JsonComm
    SettingsReadWrite *settingReadWrite = [[SettingsReadWrite alloc] initWithTcpComm:tcpComm usingDataPort:NO];

    // Example usage: Get values for specific keys
    NSArray<NSString *> *partOfKeys = @[@"BT.PairMethod", @"BT.ConnectName", @"System.KeyboardCC", @"System.Wireless.MenuJob-d"];
    NSDictionary<NSString *, NSString *> *partOfValue = [settingReadWrite getValuesForKeys:partOfKeys timeout:10000];
    NSLog(@"Get keys::::%@", partOfValue);

    // Get all properties
    NSDictionary<NSString *, Setting *> *allProperties = [settingReadWrite getAllPropertiesWithTimeout:20000];
    NSLog(@"All properties:::%@", allProperties);

    //get all values
    NSDictionary<NSString *, NSString *> *allvalues = [settingReadWrite getAllValuesWithTimeout:20000];
    NSLog(@"All Values:::: %@", allvalues);


    // Get properties for specific keys
    NSDictionary<NSString *, Setting *> *propkeys = [settingReadWrite getPropertiesForKeys:partOfKeys timeout:10000];
    NSLog(@"Prop keys:::%@", propkeys);

    // Get a specific property
    Setting *propkey = [settingReadWrite getPropertiesForKey:@"BT.PairMethod" timeout:5000];
    NSLog(@"Property key:::%@", propkey);
    
    // Initialize JsonConfig with JsonComm for configuration handling
    JsonConfig *jsonconfig = [[JsonConfig alloc] initWithJsonComm:jsonComm];
    
    // Get all configurations
    NSArray<Config *> *allConfig = [jsonconfig getAllConfigWithTimeout:10000];
    NSLog(@"All config:::\r\n%@", allConfig);
    
    CFRunLoopRun();  // Keeps the application running
}
