#import <Foundation/Foundation.h>
@import UniPRT;

int rfid_moniter(int argc, const char * argv[], NSString *ip) {
    @autoreleasepool {
        NSString *ipAddress = ip;
        TcpComm *tcpComm = [[TcpComm alloc] initWithIPAddress:ipAddress port:DEFAULT_MGMT_PORT];
        [tcpComm open];

        RfidMonitor *rfidMonitor = [[RfidMonitor alloc] initWithTcpComm:tcpComm];
        PrinterMonitor *printerMonitor = [[PrinterMonitor alloc] initWithTcpComm:tcpComm];
        
        int choice = 0;
        do {
            NSLog(@"\nMenu:");
            NSLog(@"1 - Get Printer Info");
            NSLog(@"2 - Listen to RfidReport");
            NSLog(@"3 - Print example file");
            NSLog(@"4 - Exit");
            NSLog(@"Enter your choice (1-4):");

            char buffer[10];
            fgets(buffer, 10, stdin);
            choice = atoi(buffer);

            switch (choice) {
                case 1: {
                    PrinterInfo *printerInfo = [printerMonitor getPrinterInfo];
                    NSLog(@"\n======= RFID Printer Info: ");
                    NSLog(@"Printer Model: %@", printerInfo.model);
                    NSLog(@"Printer SN: %@", printerInfo.serialNumber);
                    NSLog(@"Printer FW PN: %@", printerInfo.firmwarePartNumber);
                    NSLog(@"Printer FW Ver: %@", printerInfo.firmwareVersion);
                    NSLog(@"Printhead Resolution (Dots/Inch): %@", printerInfo.printheadResolution);
                    NSLog(@"Has RFID: %@", printerInfo.hasRfidOption ? @"Yes" : @"No");
                    break;
                }
                case 2: {
                    [NSThread detachNewThreadWithBlock:^{
                        rfidMonitor.rfidReportCallback = ^(RfidReport *report) {
                            if (report.failed) {
                                NSLog(@"\nRFID Failed.");
                            } else {
                                NSLog(@"\nRFID Passed.");
                                NSLog(@"Write Action: %@", report.isWriteOperation ? @"Yes" : @"No");
                                NSLog(@"Data: \n%@", report.data);
                            }
                        };
                        [rfidMonitor SetRfidReportListening:YES];
                    }];
                    break;
                }
                case 3: {
                    TcpComm *tcpComm2 = [[TcpComm alloc] initWithIPAddress:@"10.0.10.185" port:9100];
                    [tcpComm2 sendPrintFile:@"10.0.10.185" fileName:@"/Users/bob_huang/Downloads/tspl_rfid_test.txt"];
                    NSLog(@"Sending RFID print job...");
                    break;
                }
                case 4:
                    NSLog(@"Exiting...");
                    break;
                default:
                    NSLog(@"Invalid choice. Please enter a number between 1 and 4.");
            }
        } while (choice != 4);
    }
    return 0;
}

int printer_monitor(int argc, const char * argv[], NSString * ip) {
    @autoreleasepool {
        NSString *ipAddress = ip;
        TcpComm *tcpComm = [[TcpComm alloc] initWithIPAddress:ipAddress port:3007];
        [tcpComm open];

        PrinterMonitor *printerMonitor = [[PrinterMonitor alloc] initWithTcpComm:tcpComm];

        int choice = 0;
        do {
            NSLog(@"\nMenu:");
            NSLog(@"1 - Get Printer Info");
            NSLog(@"2 - Listen to Engine Status");
            NSLog(@"3 - Listen to Display Status");
            NSLog(@"4 - Listen to Alert Status");
            NSLog(@"5 - Print example file");
            NSLog(@"6 - Exit");
            NSLog(@"Enter your choice (1-6):");

            char buffer[10];
            fgets(buffer, 10, stdin);
            choice = atoi(buffer);

            switch (choice) {
                case 1: {
                    PrinterInfo *prtInfo = [printerMonitor getPrinterInfo];
                    NSLog(@"Printer Model: %@", [prtInfo model]);
                    NSLog(@"Printer SN: %@", [prtInfo serialNumber]);
                    NSLog(@"Printer FW PN: %@", [prtInfo firmwarePartNumber]);
                    NSLog(@"Printer FW Ver: %@", [prtInfo firmwareVersion]);
                    NSLog(@"Printhead Resolution (Dots/Inch): %@", [prtInfo printheadResolution]);
                    NSLog(@"Has RFID: %@", [prtInfo hasRfidOption] ? @"Yes" : @"No");
                    NSLog(@"Has ODV: %@", [prtInfo hasOdvOption] ? @"Yes" : @"No");
                    break;
                }
                case 2: {
                    [NSThread detachNewThreadWithBlock:^{
                        printerMonitor.engineStatusCallback = ^(NSString *status) {
                            NSLog(@"Engine status update: %@", status);
                        };
                        [printerMonitor SetEngineStatusListening:YES];
                    }];
                    break;
                }
                case 3: {
                    [NSThread detachNewThreadWithBlock:^{
                        printerMonitor.displayStatusCallback = ^(NSArray<NSString *> *status) {
                            NSLog(@"Display status update: %@", [status componentsJoinedByString:@", "]);
                        };
                        [printerMonitor SetDisplayStatusListening:YES];
                    }];
                    break;
                }
                case 4: {
                    [NSThread detachNewThreadWithBlock:^{
                        printerMonitor.alertStatusCallback = ^(NSArray<NSString *> *status) {
                            NSLog(@"Alert status update: %@", [status componentsJoinedByString:@", "]);
                        };
                        [printerMonitor SetAlertStatusListening:YES];
                    }];
                    break;
                }
                case 5: {
                    TcpComm *tcpComm2 = [[TcpComm alloc] initWithIPAddress:@"10.0.10.186" port:9100];
                    [tcpComm2 open];
                    [tcpComm2 sendPrintFile:@"10.0.10.186" fileName:@"/Users/realbuber/Documents/doc/TestPrinterMonitor/Hello_1.pgl"];
                    NSLog(@"Print file sent.");
                    break;
                }
                case 6:
                    NSLog(@"Exiting...");
                    break;
                default:
                    NSLog(@"Invalid choice. Please enter a number between 1 and 6.");
            }
        } while (choice != 6);
    }
    return 0;
}

int odv_monitor(int argc, const char * argv[], NSString * ip) {
    @autoreleasepool {
        NSString *ipAddress = ip;
        TcpComm *tcpComm = [[TcpComm alloc] initWithIPAddress:ipAddress port:DEFAULT_MGMT_PORT];
        [tcpComm open];
        OdvMonitor *odvMonitor = [[OdvMonitor alloc] initWithTcpComm:tcpComm];
        PrinterMonitor *printerMonitor = [[PrinterMonitor alloc] initWithTcpComm:tcpComm];
        
        int choice = 0;
        do
        {
            NSLog(@"\nMenu:");
            NSLog(@"1 - Get Printer Info");
            NSLog(@"2 - Listen to OdvReport");
            NSLog(@"3 - Print example file");
            NSLog(@"4 - Exit");
            NSLog(@"Enter your choice (1-4):");

            char buffer[10];
            fgets(buffer, 10, stdin);
            choice = atoi(buffer);

            switch (choice) {
                case 1: {
                    
                    PrinterInfo *printerInfo = [printerMonitor getPrinterInfo];
                    NSLog(@"\n======= ODV Printer Info: ");
                    NSLog(@"Printer Model: %@", printerInfo.model);
                    NSLog(@"Printer SN: %@", printerInfo.serialNumber);
                    NSLog(@"Printer FW PN: %@", printerInfo.firmwarePartNumber);
                    NSLog(@"Printer FW Ver: %@", printerInfo.firmwareVersion);
                    NSLog(@"Printhead Resolution (Dots/Inch): %@", printerInfo.printheadResolution);
                    NSLog(@"Has ODV: %@", printerInfo.hasOdvOption ? @"Yes" : @"No");
                    break;
                }
                case 2: {
                    [NSThread detachNewThreadWithBlock:^{
                        odvMonitor.odvReportCallback = ^(OdvReport *report) {
                            if ([report failed]) {
                                NSLog(@"\nBarcode Failed.");
                            } else {
                                NSLog(@"\nBarcode Passed.");
                                NSLog(@"Grade: %f", [report overallGradeAsFloat]);

                                if ([report overallGradeAsFloat] > 3.5) {
                                    NSLog(@"Print Quality passed. \n Overall Grade= %.2f", [report overallGradeAsFloat]);
                                } else {
                                    NSLog(@"Print Quality Failed. \n Overall Grade= %.2f", [report overallGradeAsFloat]);
                                }

                                NSLog(@"Barcode Symbology: %@", [report symbology]);
                                NSLog(@"Barcode Data: %@", [report data]);
                            }
                        };
                        [odvMonitor SetOdvReportListening:YES];
                    }];
                    break;
                }
                case 3: {
                    TcpComm *tcpComm2 = [[TcpComm alloc] initWithIPAddress:@"10.0.10.171" port:9100];
                    [tcpComm2 sendPrintFile:@"10.0.10.171" fileName:@"/Users/realbuber/Downloads/TestOdvMonitor/DM_PRINTRONIX_1.pgl"];
                    NSLog(@"Sending datamatrix barcode print job...");
                    break;
                }
                case 4:
                    NSLog(@"Exiting...");
                    break;
                default:
                    NSLog(@"Invalid choice. Please enter a number between 1 and 4.");
            }
        } while (choice != 4);
    }
    return 0;
}
