import Foundation
import UniPRT

let MAX_INPUT_MSG_CAPACITY = 20
let MAX_WAIT_TIME_SECS = 15

func usb_mgmt() {
    
        let commType = CommType.USB_COMM
        let usbconnection = UsbConnection()
    
        if let devices = usbconnection.availableDevices(),
           let deviceInfo = devices.first,  // 选择第一个设备
           let vendorId = deviceInfo[0] as? String,
           let productId = deviceInfo[1] as? String {

            // 初始化 UsbComm 实例
            let comm = UsbComm(vendorId: vendorId, productId: productId)

            comm?.open()
        
        let jsonComm = JsonComm(comm: comm, commType: commType.rawValue)
        jsonComm?.usingDataPort = true
        let settingReadWrite = SettingsReadWrite(jsonComm: jsonComm)
       
        if let setting = settingReadWrite?.setValue("eJustWork", forKey: "BT.PairMethod"){
            print("setValue:::: \(setting)")
        }
        
            if let settings = settingReadWrite?.setValues(["BT.PairMethod":"eNumericComp","BT.ConnectName":"BT-PTX3"], timeout: 10000){
            print("setValues:::: \(settings)")
        }
        
        let partOfKeys = ["BT.PairMethod", "BT.ConnectName"]
        
            if let propkey = settingReadWrite?.getPropertiesForKey("BT.PairMethod", timeout: 10000){
            print("getPropertiesForKey:::\(String(describing: propkey))")
        }
        
        
            if let partOfValue = settingReadWrite?.getValuesForKeys(partOfKeys, timeout: 100000) {
            print("getValuesForKeys:::: \(partOfValue)")
        }
        
            if let AllValue = settingReadWrite?.getAllValues(withTimeout: 30000){
            print("getAllValues:::: \(AllValue)")
        }
        
            if let partOfValue = settingReadWrite?.getValuesForKeys(partOfKeys, timeout: 10000) {
            print("getValuesForKeys:::: \(partOfValue)")
        }
        
            if let propKeys = settingReadWrite?.getPropertiesForKeys(partOfKeys, timeout: 10000) {
            print("getPropertiesForKeys::: \(propKeys)")
        }
        
            if let allProperties = settingReadWrite?.getAllProperties(withTimeout: 30000) {
            print("getAllProperties::: \(allProperties)")
        }
        
        //JsonConfig only support PTX printer.
        let jsonconfig = JsonConfig(jsonComm: jsonComm)

            let config = jsonconfig?.getWithNumber(1, timeout: 20000)

        print("Config: \(String(describing: config))")


        config?.setName("123")
        config?.setNumber(1)
        config?.setModel("T820")
            let success = jsonconfig?.setConfig(config, 5000)

        if success == true {
            print("Configuration set successfully.")
        } else {
            print("Failed to set configuration.")
        }


        let tempConfig: Config? = config
        print("tempConfig:::\(String(describing: tempConfig))")
        
        let allCfg = jsonconfig?.getAllConfig(withTimeout: 300000)
        print("allConfig:::\(String(describing: allCfg))")
    
    }
}

func tcp_mgmt(ipAddress: String) {
    
    let commType = CommType.TCP_COMM
       
    
    let comm: String = ipAddress
    
    let jsonComm = JsonComm(comm: comm, commType: commType.rawValue)
    let settingReadWrite = SettingsReadWrite(jsonComm: jsonComm)
   
    if let setting = settingReadWrite?.setValue("eJustWork", forKey: "BT.PairMethod"){
        print("setValue:::: \(setting)")
    }
    
        if let settings = settingReadWrite?.setValues(["BT.PairMethod":"eNumericComp","BT.ConnectName":"BT-PTX3"], timeout: 10000){
        print("setValues:::: \(settings)")
    }
    
    let partOfKeys = ["BT.PairMethod", "BT.ConnectName"]
    
        if let propkey = settingReadWrite?.getPropertiesForKey("BT.PairMethod", timeout: 10000){
        print("getPropertiesForKey:::\(String(describing: propkey))")
    }
    
    
        if let partOfValue = settingReadWrite?.getValuesForKeys(partOfKeys, timeout: 100000) {
        print("getValuesForKeys:::: \(partOfValue)")
    }
    
        if let AllValue = settingReadWrite?.getAllValues(withTimeout: 30000){
        print("getAllValues:::: \(AllValue)")
    }
    
        if let partOfValue = settingReadWrite?.getValuesForKeys(partOfKeys, timeout: 10000) {
        print("getValuesForKeys:::: \(partOfValue)")
    }
    
        if let propKeys = settingReadWrite?.getPropertiesForKeys(partOfKeys, timeout: 10000) {
        print("getPropertiesForKeys::: \(propKeys)")
    }
    
        if let allProperties = settingReadWrite?.getAllProperties(withTimeout: 30000) {
        print("getAllProperties::: \(allProperties)")
    }
    
    //JsonConfig only support PTX printer.
    let jsonconfig = JsonConfig(jsonComm: jsonComm)

        let config = jsonconfig?.getWithNumber(1, timeout: 20000)

    print("Config: \(String(describing: config))")


    config?.setName("123")
    config?.setNumber(1)
    config?.setModel("T820")
        let success = jsonconfig?.setConfig(config, 5000)

    if success == true {
        print("Configuration set successfully.")
    } else {
        print("Failed to set configuration.")
    }


    let tempConfig: Config? = config
    print("tempConfig:::\(String(describing: tempConfig))")
    
    let allCfg = jsonconfig?.getAllConfig(withTimeout: 300000)
    print("allConfig:::\(String(describing: allCfg))")
    
    
}

func ble_mgmt(device_name: String) {
    let bleComm = BleComm()
    var characteristicsReady = false

    // 🔧 Callback when characteristics are ready
    bleComm.characteristicsReadyCallback = {
        print("🎯 Characteristics ready callback triggered.")
        characteristicsReady = true
    }

    DispatchQueue.global(qos: .default).async {
        //  Wait for BLE to power on
        while bleComm.centralManager.state != .poweredOn {
            print(" Waiting for BLE to power on...")
            Thread.sleep(forTimeInterval: 0.1)
        }
        print(" BLE is powered on")

        //  Start scanning
        bleComm.availableDevices()
        Thread.sleep(forTimeInterval: 10.0) // wait for delegate callbacks

        // Find target device
        let devicesList = bleComm.discoveredDevices
        let targetDeviceName = device_name
        guard let deviceNameToOpen = devicesList.first(where: { $0 as! String == targetDeviceName }) else {
            print(" Target BLE device (\(targetDeviceName)) not found.")
            return
        }

        //  Connect
        bleComm.open(deviceNameToOpen as! String)
        print(" Attempting to connect to BLE device: \(deviceNameToOpen)")

        //  Wait for characteristicsReadyCallback
        var waitCounter = 0
        while !characteristicsReady && waitCounter < 100 {
            Thread.sleep(forTimeInterval: 0.1)
            waitCounter += 1
        }

        // Verify connection
        guard bleComm.isConnected() else {
            print("❌ Failed to open BLE device: \(deviceNameToOpen)")
            return
        }
        print("Connected to BLE device: \(deviceNameToOpen)")

        //  Settings read/write helper
        let settingsRW = SettingsReadWrite(bleComm: bleComm, usingDataPort: true)

        //  Get specific values
        let keys = ["BT.PairMethod", "BT.ConnectName"]
        let partialValues = settingsRW?.getValuesForKeys(keys, timeout: 10_000)
        print("Get values for keys: \(String(describing: partialValues))")

        //  Get all properties
        let allProperties = settingsRW?.getAllProperties(withTimeout: 45_000)
        print("All properties: \(String(describing: allProperties))")

        //  Get all values
        let allValues = settingsRW?.getAllValues(withTimeout: 25_000)
        print("All values: \(String(describing: allValues))")

        //  Get properties for keys
        let propKeys = settingsRW?.getPropertiesForKeys(keys, timeout: 10_000)
        print("Properties for keys: \(String(describing: propKeys))")

        // Get a single property
        let singleProp = settingsRW?.getPropertiesForKey("BT.PairMethod", timeout: 10_000)

        //  Configuration handling
        let commType = CommType.BLE_COMM
        let jsonComm = JsonComm(comm: bleComm, commType: commType.rawValue)
        jsonComm?.usingDataPort = true
        let jsonConfig = JsonConfig(jsonComm: jsonComm)
        let allConfig = jsonConfig?.getAllConfig(withTimeout: 400_000)
        print("All configurations:\n\(String(describing: allConfig))")
    }
}

func bt_mgmt(address: String) {
    // Initialize Bluetooth Classic communication
    let btComm = BtComm(deviceAddress: address)
    btComm?.open()
    let commTypeBt = CommType.BT_COMM.rawValue

    // Wrap in JsonComm for JSON messaging
    let jsonComm = JsonComm(comm: btComm, commType: commTypeBt)
    jsonComm?.usingDataPort = true

    // Initialize SettingsReadWrite helper
    let settingsRW = SettingsReadWrite(btComm: btComm, usingDataPort: true)

    // Example: get values for specific keys
    let keys = ["BT.PairMethod",
                "BT.ConnectName",
                "System.KeyboardCC",
                "System.Wireless.MenuJob-d"]
    let partialValues = settingsRW?.getValuesForKeys(keys, timeout: 10_000)
    print("Get keys: \(String(describing: partialValues))")

    // Get all properties
    let allProperties = settingsRW?.getAllProperties(withTimeout: 30_000)
    print("All properties: \(String(describing: allProperties))")

    // Get all values
    let allValues = settingsRW?.getAllValues(withTimeout: 20_000)
    print("All values: \(String(describing: allValues))")

    // Get properties for specific keys
    let propKeys = settingsRW?.getPropertiesForKeys(keys, timeout: 10_000)
    print("Prop keys: \(String(describing: propKeys))")

    // Get a single property
    let singleProp = settingsRW?.getPropertiesForKey("BT.PairMethod", timeout: 5_000)
    print("Property key: \(String(describing: singleProp))")

    // Configuration handling via JsonConfig
    let jsonConfig = JsonConfig(jsonComm: jsonComm)
    let allConfig = jsonConfig?.getAllConfig(withTimeout: 10_000)
    print("All config:\n\(String(describing: allConfig))")

    // Keep the run loop alive if needed
    CFRunLoopRun()
}
